/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.config;

import com.atlassian.core.util.collection.EasyList;
import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.bean.SubTaskBean;
import com.atlassian.jira.bean.SubTaskBeanImpl;
import com.atlassian.jira.config.ConstantsManager;
import com.atlassian.jira.config.SubTaskManager;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.event.type.EventType;
import com.atlassian.jira.exception.CreateException;
import com.atlassian.jira.exception.DataAccessException;
import com.atlassian.jira.exception.RemoveException;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueManager;
import com.atlassian.jira.issue.fields.config.manager.IssueTypeSchemeManager;
import com.atlassian.jira.issue.history.ChangeItemBean;
import com.atlassian.jira.issue.issuetype.IssueType;
import com.atlassian.jira.issue.link.IssueLink;
import com.atlassian.jira.issue.link.IssueLinkManager;
import com.atlassian.jira.issue.link.IssueLinkType;
import com.atlassian.jira.issue.link.IssueLinkTypeManager;
import com.atlassian.jira.issue.link.SequenceIssueLinkComparator;
import com.atlassian.jira.issue.util.IssueUpdateBean;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.util.CollectionReorderer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.apache.log4j.Logger;
import org.ofbiz.core.entity.GenericValue;

public class DefaultSubTaskManager
implements SubTaskManager {
    private static final Logger log = Logger.getLogger(DefaultSubTaskManager.class);
    private static final String ISSUE_TYPE_NAME = "IssueType";
    private static final String DEFAULT_SUB_TASK_ISSUE_TYPE_NAME = "Sub-task";
    private static final Long DEFAULT_SUB_TASK_ISSUE_TYPE_SEQUENCE = new Long(0L);
    private static final String DEFAULT_SUB_TASK_ISSUE_TYPE_DESCRIPTION = "The sub-task of the issue";
    private static final String DEFAULT_SUB_TASK_ISSUE_TYPE_ICON_URL = "/images/icons/issue_subtask.gif";
    private final IssueLinkTypeManager issueLinkTypeManager;
    private final IssueLinkManager issueLinkManager;
    private final PermissionManager permissionManager;
    private final ApplicationProperties applicationProperties;
    private final CollectionReorderer collectionReorderer;
    private final ConstantsManager constantsManager;
    private final IssueTypeSchemeManager issueTypeSchemeManager;
    private final IssueManager issueManager;

    public DefaultSubTaskManager(ConstantsManager constantsManager, IssueLinkTypeManager issueLinkTypeManager, IssueLinkManager issueLinkManager, PermissionManager permissionManager, ApplicationProperties applicationProperties, CollectionReorderer collectionReorderer, IssueTypeSchemeManager issueTypeSchemeManager, IssueManager issueManager) {
        this.constantsManager = constantsManager;
        this.issueLinkTypeManager = issueLinkTypeManager;
        this.issueLinkManager = issueLinkManager;
        this.permissionManager = permissionManager;
        this.applicationProperties = applicationProperties;
        this.collectionReorderer = collectionReorderer;
        this.issueTypeSchemeManager = issueTypeSchemeManager;
        this.issueManager = issueManager;
    }

    public void enableSubTasks() throws CreateException {
        Collection subTaskIssueTypes;
        Collection subTaskIssueLinks = this.getSubTaskIssueLinkTypes();
        if (subTaskIssueLinks == null || subTaskIssueLinks.isEmpty()) {
            this.issueLinkTypeManager.createIssueLinkType("jira_subtask_link", "jira_subtask_outward", "jira_subtask_inward", "jira_subtask");
        }
        if ((subTaskIssueTypes = this.constantsManager.getSubTaskIssueTypeObjects()) == null || subTaskIssueTypes.isEmpty()) {
            this.createSubTaskIssueType(DEFAULT_SUB_TASK_ISSUE_TYPE_NAME, DEFAULT_SUB_TASK_ISSUE_TYPE_SEQUENCE, DEFAULT_SUB_TASK_ISSUE_TYPE_DESCRIPTION, DEFAULT_SUB_TASK_ISSUE_TYPE_ICON_URL);
        }
        this.applicationProperties.setOption("jira.option.allowsubtasks", true);
    }

    public void disableSubTasks() {
        this.applicationProperties.setOption("jira.option.allowsubtasks", false);
    }

    public Collection<IssueType> getSubTaskIssueTypeObjects() {
        return this.constantsManager.getSubTaskIssueTypeObjects();
    }

    public boolean isSubTasksEnabled() {
        return this.applicationProperties.getOption("jira.option.allowsubtasks");
    }

    public GenericValue createSubTaskIssueType(String name, Long sequence, String description, String iconurl) throws CreateException {
        if (this.issueTypeExistsByName(name)) {
            throw new CreateException("Issue Type with name '" + name + "' already exists.");
        }
        GenericValue subTask = this.constantsManager.createIssueType(name, sequence, "jira_subtask", description, iconurl);
        this.issueTypeSchemeManager.addOptionToDefault(subTask.getString("id"));
        return subTask;
    }

    public IssueType insertSubTaskIssueType(String name, Long sequence, String description, String iconurl) throws CreateException {
        if (this.issueTypeExistsByName(name)) {
            throw new CreateException("Issue Type with name '" + name + "' already exists.");
        }
        IssueType subTaskIssueType = this.constantsManager.insertIssueType(name, sequence, "jira_subtask", description, iconurl);
        this.issueTypeSchemeManager.addOptionToDefault(subTaskIssueType.getId());
        return subTaskIssueType;
    }

    public void updateSubTaskIssueType(String id, String name, Long sequence, String description, String iconurl) throws DataAccessException {
        this.constantsManager.updateIssueType(id, name, sequence, "jira_subtask", description, iconurl);
    }

    private Collection getSubTaskIssueLinkTypes() {
        return this.issueLinkTypeManager.getIssueLinkTypesByStyle("jira_subtask");
    }

    public boolean issueTypeExistsByName(String name) {
        return this.constantsManager.constantExists(ISSUE_TYPE_NAME, name);
    }

    public void moveSubTaskIssueTypeUp(String id) throws DataAccessException {
        if (id == null) {
            throw new IllegalArgumentException("Id cannot be null.");
        }
        ArrayList<GenericValue> subTasksIssueTypes = new ArrayList<GenericValue>(this.constantsManager.getEditableSubTaskIssueTypes());
        GenericValue issueType = this.getSubTaskIssueTypeById(id);
        this.collectionReorderer.increasePosition(subTasksIssueTypes, issueType);
        this.recalculateSequencesAndStore(subTasksIssueTypes);
    }

    public void moveSubTaskIssueTypeDown(String id) throws DataAccessException {
        if (id == null) {
            throw new IllegalArgumentException("Id cannot be null.");
        }
        ArrayList<GenericValue> subTasksIssueTypes = new ArrayList<GenericValue>(this.constantsManager.getEditableSubTaskIssueTypes());
        GenericValue issueType = this.constantsManager.getIssueType(id);
        this.collectionReorderer.decreasePosition(subTasksIssueTypes, issueType);
        this.recalculateSequencesAndStore(subTasksIssueTypes);
    }

    public GenericValue getSubTaskIssueTypeById(String id) {
        if (id == null) {
            throw new IllegalArgumentException("Id cannot be null.");
        }
        GenericValue issueTypeGV = this.constantsManager.getIssueType(id);
        if (issueTypeGV != null && !this.isSubTaskIssueType(issueTypeGV)) {
            throw new IllegalArgumentException("The issue type with id '" + id + "' is not a sub-task issue type.");
        }
        return issueTypeGV;
    }

    public IssueType getSubTaskIssueType(String id) {
        if (id == null) {
            throw new IllegalArgumentException("Id cannot be null.");
        }
        IssueType issueType = this.constantsManager.getIssueTypeObject(id);
        if (issueType == null) {
            return null;
        }
        if (issueType.isSubTask()) {
            return issueType;
        }
        throw new IllegalArgumentException("The issue type with id '" + id + "' is not a sub-task issue type.");
    }

    private void recalculateSequencesAndStore(List<GenericValue> c) throws DataAccessException {
        int i = 0;
        for (GenericValue genericValue : c) {
            genericValue.set("sequence", (Object)new Long(i));
            ++i;
        }
        try {
            this.constantsManager.storeIssueTypes(c);
        }
        catch (DataAccessException e) {
            throw new DataAccessException("Error occurred while storing sub-task issue types.", (Throwable)e);
        }
    }

    public void removeSubTaskIssueType(String name) throws RemoveException {
        IssueType issueType = (IssueType)this.constantsManager.getIssueConstantByName(ISSUE_TYPE_NAME, name);
        if (issueType != null) {
            if (!issueType.isSubTask()) {
                throw new RemoveException("Issue Type with name '" + name + "' is not a sub-task issue type.");
            }
        } else {
            throw new RemoveException("Issue Type with name '" + name + "' does not exist.");
        }
        this.constantsManager.removeIssueType(issueType.getId());
    }

    public boolean issueTypeExistsById(String id) {
        return this.getSubTaskIssueTypeById(id) != null;
    }

    public boolean isSubTask(GenericValue issue) {
        return this.getParentIssueId(issue) != null;
    }

    public boolean isSubTaskIssueType(GenericValue issueType) {
        return "jira_subtask".equals(issueType.getString("style"));
    }

    public Long getParentIssueId(GenericValue issue) {
        this.ensureIssueNotNull(issue);
        List inwardLinks = this.issueLinkManager.getInwardLinks(issue.getLong("id"));
        for (IssueLink inwardLink : inwardLinks) {
            if (!inwardLink.getIssueLinkType().isSubTaskLinkType()) continue;
            return inwardLink.getLong("source");
        }
        return null;
    }

    public GenericValue getParentIssue(GenericValue subtask) {
        GenericValue parentIssue = null;
        Long parentId = this.getParentIssueId(subtask);
        try {
            parentIssue = this.issueManager.getIssue(parentId);
        }
        catch (Throwable e) {
            // empty catch block
        }
        return parentIssue;
    }

    public SubTaskBean getSubTaskBean(GenericValue issue, User remoteUser) {
        SubTaskBeanImpl subTaskBean = new SubTaskBeanImpl();
        List<IssueLink> subTaskIssueLinks = this.getSubTaskIssueLinks(issue.getLong("id"));
        for (IssueLink subTaskIssueLink : subTaskIssueLinks) {
            Issue subTaskIssue = subTaskIssueLink.getDestinationObject();
            if (!this.permissionManager.hasPermission(10, subTaskIssue, remoteUser)) continue;
            subTaskBean.addSubTask(subTaskIssueLink.getSequence(), subTaskIssue.getGenericValue(), issue);
        }
        return subTaskBean;
    }

    public SubTaskBean getSubTaskBean(Issue issue, User remoteUser) {
        SubTaskBeanImpl subTaskBean = new SubTaskBeanImpl();
        List<IssueLink> subTaskIssueLinks = this.getSubTaskIssueLinks(issue.getLong("id"));
        for (IssueLink subTaskIssueLink : subTaskIssueLinks) {
            Issue subTaskIssue = subTaskIssueLink.getDestinationObject();
            if (!this.permissionManager.hasPermission(10, subTaskIssue, remoteUser)) continue;
            subTaskBean.addSubTask(subTaskIssueLink.getSequence(), subTaskIssue, issue);
        }
        return subTaskBean;
    }

    public void moveSubTask(GenericValue parentIssue, Long currentSequence, Long sequence) {
        List<IssueLink> subTaskIssueLinks = this.getSubTaskIssueLinks(parentIssue.getLong("id"));
        this.issueLinkManager.moveIssueLink(subTaskIssueLinks, currentSequence, sequence);
    }

    public void moveSubTask(Issue parentIssue, Long currentSequence, Long sequence) {
        this.moveSubTask(parentIssue.getGenericValue(), currentSequence, sequence);
    }

    public void resetSequences(Issue issue) {
        this.resetSequences(issue.getId());
    }

    private void resetSequences(Long issueId) {
        List<IssueLink> subTaskIssueLinks = this.getSubTaskIssueLinks(issueId);
        this.issueLinkManager.resetSequences(subTaskIssueLinks);
    }

    public Collection<Long> getAllSubTaskIssueIds() {
        IssueLinkType subTaskIssueLinkType = this.getSubTaskIssueLinkType();
        Collection issueLinks = this.issueLinkManager.getIssueLinks(subTaskIssueLinkType.getId());
        HashSet<Long> subTaskIssueIds = new HashSet<Long>();
        for (IssueLink issueLink : issueLinks) {
            subTaskIssueIds.add(issueLink.getDestinationId());
        }
        return subTaskIssueIds;
    }

    private void ensureIssueNotNull(GenericValue issue) {
        if (issue == null) {
            throw new IllegalArgumentException("Issue cannot be null.");
        }
        if (!"Issue".equals(issue.getEntityName())) {
            throw new IllegalArgumentException("The argument must be an issue.");
        }
    }

    public List<IssueLink> getSubTaskIssueLinks(Long issueId) {
        List outwardLinks = this.issueLinkManager.getOutwardLinks(issueId);
        Iterator iterator = outwardLinks.iterator();
        while (iterator.hasNext()) {
            IssueLink outwardLink = (IssueLink)iterator.next();
            if (outwardLink.getIssueLinkType().isSubTaskLinkType()) continue;
            iterator.remove();
        }
        Collections.sort(outwardLinks, new SequenceIssueLinkComparator());
        return outwardLinks;
    }

    public Collection<GenericValue> getSubTasks(GenericValue issue) {
        LinkedList<GenericValue> subTaskIssues = new LinkedList<GenericValue>();
        for (IssueLink issueLink : this.getSubTaskIssueLinks(issue.getLong("id"))) {
            subTaskIssues.add(issueLink.getDestinationObject().getGenericValue());
        }
        return subTaskIssues;
    }

    public Collection<Issue> getSubTaskObjects(Issue parentIssue) {
        LinkedList<Issue> subTaskIssues = new LinkedList<Issue>();
        for (IssueLink issueLink : this.getSubTaskIssueLinks(parentIssue.getId())) {
            subTaskIssues.add(issueLink.getDestinationObject());
        }
        return subTaskIssues;
    }

    public void createSubTaskIssueLink(GenericValue parentIssue, GenericValue subTaskIssue, User remoteUser) throws CreateException {
        if (parentIssue == null) {
            throw new IllegalArgumentException("Parent Issue cannot be null.");
        }
        if (subTaskIssue == null) {
            throw new IllegalArgumentException("Sub-Task Issue cannot be null.");
        }
        List<IssueLink> subTaskIssueLinks = this.getSubTaskIssueLinks(parentIssue.getLong("id"));
        Long sequence = subTaskIssueLinks == null ? new Long(0L) : new Long(subTaskIssueLinks.size());
        this.issueLinkManager.createIssueLink(parentIssue.getLong("id"), subTaskIssue.getLong("id"), this.getSubTaskIssueLinkType().getId(), sequence, remoteUser);
    }

    public void createSubTaskIssueLink(Issue parentIssue, Issue subTaskIssue, User remoteUser) throws CreateException {
        this.createSubTaskIssueLink(parentIssue.getGenericValue(), subTaskIssue.getGenericValue(), remoteUser);
    }

    private IssueLinkType getSubTaskIssueLinkType() {
        Collection subTaskIssueLinkTypes = this.getSubTaskIssueLinkTypes();
        if (subTaskIssueLinkTypes != null && !subTaskIssueLinkTypes.isEmpty()) {
            if (subTaskIssueLinkTypes.size() > 1) {
                log.warn((Object)("Found '" + subTaskIssueLinkTypes.size() + "' sub-task issue link types. Returning first one."));
            }
            return (IssueLinkType)subTaskIssueLinkTypes.iterator().next();
        }
        return null;
    }

    public IssueUpdateBean changeParent(GenericValue subTask, GenericValue newParentIssue, User currentUser) throws RemoveException, CreateException {
        GenericValue oldParentIssue = this.getParentIssue(subTask);
        List inwardLinks = this.issueLinkManager.getInwardLinks(subTask.getLong("id"));
        for (IssueLink issueLink : inwardLinks) {
            if (!issueLink.getIssueLinkType().isSubTaskLinkType()) continue;
            this.issueLinkManager.removeIssueLink(issueLink, currentUser);
        }
        this.createSubTaskIssueLink(newParentIssue, subTask, currentUser);
        this.resetSequences(newParentIssue.getLong("id"));
        this.resetSequences(oldParentIssue.getLong("id"));
        ChangeItemBean cibParent = new ChangeItemBean("custom", "Parent Issue", oldParentIssue.getString("key"), oldParentIssue.getString("key"), newParentIssue.getString("key"), newParentIssue.getString("key"));
        GenericValue newSubTask = (GenericValue)subTask.clone();
        newSubTask.set("security", (Object)newParentIssue.getLong("security"));
        IssueUpdateBean issueUpdateBean = new IssueUpdateBean(newSubTask, subTask, EventType.ISSUE_UPDATED_ID, currentUser);
        issueUpdateBean.setChangeItems((Collection)EasyList.build((Object)cibParent));
        return issueUpdateBean;
    }

    public IssueUpdateBean changeParent(Issue subTask, Issue parentIssue, User currentUser) throws RemoveException, CreateException {
        return this.changeParent(subTask.getGenericValue(), parentIssue.getGenericValue(), currentUser);
    }
}

