/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.bc.workflow;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.bc.ServiceOutcome;
import com.atlassian.jira.bc.ServiceOutcomeImpl;
import com.atlassian.jira.bc.project.ProjectAction;
import com.atlassian.jira.bc.workflow.WorkflowSchemeService;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.jira.workflow.DraftWorkflowScheme;
import com.atlassian.jira.workflow.WorkflowScheme;
import com.atlassian.jira.workflow.WorkflowSchemeManager;
import javax.annotation.Nonnull;

public class DefaultWorkflowSchemeService
implements WorkflowSchemeService {
    private final PermissionManager permissionManager;
    private final I18nHelper.BeanFactory i18Factory;
    private final WorkflowSchemeManager workflowSchemeManager;

    public DefaultWorkflowSchemeService(PermissionManager permissionManager, I18nHelper.BeanFactory i18Factory, WorkflowSchemeManager workflowSchemeManager) {
        this.permissionManager = permissionManager;
        this.i18Factory = i18Factory;
        this.workflowSchemeManager = workflowSchemeManager;
    }

    public ServiceOutcome<DraftWorkflowScheme> createDraft(ApplicationUser creator, long parentId) {
        if (!this.hasAdminPermission(creator)) {
            return this.getError(creator, "admin.workflowschemes.service.error.no.admin.permission");
        }
        ServiceOutcome<WorkflowScheme> parentSchemeOutcome = this.getWorkflowScheme(creator, parentId);
        if (!parentSchemeOutcome.isValid()) {
            return ServiceOutcomeImpl.from(parentSchemeOutcome.getErrorCollection(), null);
        }
        WorkflowScheme workflowScheme = (WorkflowScheme)parentSchemeOutcome.getReturnedValue();
        if (!this.workflowSchemeManager.isActive(workflowScheme)) {
            return this.getError(creator, "admin.workflowschemes.service.error.not.active");
        }
        if (this.workflowSchemeManager.hasDraft(workflowScheme)) {
            return this.getError(creator, "admin.workflowschemes.service.error.has.draft");
        }
        DraftWorkflowScheme draft = this.workflowSchemeManager.createDraftOf(creator, workflowScheme);
        return ServiceOutcomeImpl.ok(draft);
    }

    public ServiceOutcome<WorkflowScheme> getWorkflowScheme(ApplicationUser user, long id) {
        WorkflowScheme workflowScheme = this.workflowSchemeManager.getWorkflowSchemeObj(id);
        if (workflowScheme == null) {
            return this.getError(user, "admin.workflowschemes.service.error.does.not.exist");
        }
        return ServiceOutcomeImpl.ok(workflowScheme);
    }

    public ServiceOutcome<DraftWorkflowScheme> getDraftWorkflowScheme(ApplicationUser user, @Nonnull WorkflowScheme parentScheme) {
        Assertions.notNull((String)"scheme", (Object)parentScheme);
        return ServiceOutcomeImpl.ok(!parentScheme.isDefault() ? this.workflowSchemeManager.getDraftForParent(parentScheme) : null);
    }

    public ServiceOutcome<Void> deleteWorkflowScheme(ApplicationUser user, @Nonnull WorkflowScheme scheme) {
        Assertions.notNull((String)"scheme", (Object)scheme);
        if (!this.hasAdminPermission(user)) {
            return this.getError(user, "admin.workflowschemes.service.error.no.admin.permission");
        }
        if (scheme.isDefault()) {
            return this.getError(user, "admin.workflowschemes.service.error.cant.delete.default");
        }
        if (this.isActive(scheme)) {
            return this.getError(user, "admin.workflowschemes.service.error.delete.active");
        }
        if (!this.workflowSchemeManager.deleteWorkflowScheme(scheme)) {
            return this.getError(user, "admin.workflowschemes.service.error.delete.error");
        }
        return ServiceOutcomeImpl.ok(null);
    }

    public boolean isActive(WorkflowScheme workflowScheme) {
        return this.workflowSchemeManager.isActive((WorkflowScheme)Assertions.notNull((String)"workflowScheme", (Object)workflowScheme));
    }

    public ServiceOutcome<WorkflowScheme> getSchemeForProject(ApplicationUser user, @Nonnull Project project) {
        if (!this.hasPermissionToEditProject(user, project)) {
            return this.getError(user, "admin.workflowschemes.service.error.no.permission.project");
        }
        return ServiceOutcomeImpl.ok(this.workflowSchemeManager.getWorkflowSchemeObj(project));
    }

    boolean hasPermissionToEditProject(ApplicationUser user, Project project) {
        return ProjectAction.EDIT_PROJECT_CONFIG.hasPermission(this.permissionManager, (User)user, project);
    }

    private <T> ServiceOutcome<T> getError(ApplicationUser user, String key) {
        return ServiceOutcomeImpl.error(this.i18Factory.getInstance((User)user).getText(key));
    }

    private boolean hasAdminPermission(ApplicationUser user) {
        return this.permissionManager.hasPermission(0, (User)user);
    }
}

