/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.bc.user.search;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.bc.JiraServiceContext;
import com.atlassian.jira.bc.user.search.UserMatcherPredicate;
import com.atlassian.jira.bc.user.search.UserPickerSearchService;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.issue.comparator.UserBestNameComparator;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.user.util.UserManager;
import com.atlassian.jira.util.StopWatch;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class DefaultUserPickerSearchService
implements UserPickerSearchService {
    private static final Logger log = Logger.getLogger(DefaultUserPickerSearchService.class);
    private final UserManager userManager;
    private final ApplicationProperties applicationProperties;
    private final PermissionManager permissionManager;
    private static final String VISIBILITY_PUBLIC = "show";
    private static final String VISIBILITY_USER = "user";
    private static final String VISIBILITY_MASKED = "mask";

    public DefaultUserPickerSearchService(UserManager userManager, ApplicationProperties applicationProperties, PermissionManager permissionManager) {
        this.userManager = userManager;
        this.applicationProperties = applicationProperties;
        this.permissionManager = permissionManager;
    }

    public List<User> findUsers(JiraServiceContext jiraServiceContext, String query) {
        if (StringUtils.isBlank((String)query)) {
            return Collections.emptyList();
        }
        return this.findUsersAllowEmptyQuery(jiraServiceContext, query);
    }

    public List<User> findUsersAllowEmptyQuery(JiraServiceContext jiraServiceContext, String query) {
        String convertedQuery;
        if (!this.canPerformAjaxSearch(jiraServiceContext)) {
            return Collections.emptyList();
        }
        StopWatch stopWatch = new StopWatch();
        String string = convertedQuery = query == null ? "" : query.toLowerCase().trim();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Running user-picker search: '" + convertedQuery + "'"));
        }
        ArrayList<User> returnUsers = new ArrayList<User>();
        boolean canShowEmailAddresses = this.canShowEmailAddresses(jiraServiceContext);
        Collection allUsers = this.userManager.getUsers();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Found all " + allUsers.size() + " users in " + stopWatch.getIntervalTime() + "ms"));
        }
        UserMatcherPredicate userMatcher = new UserMatcherPredicate(convertedQuery, canShowEmailAddresses);
        for (User user : allUsers) {
            if (!user.isActive() || !userMatcher.apply(user)) continue;
            returnUsers.add(user);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Matched " + returnUsers.size() + " users in " + stopWatch.getIntervalTime() + "ms"));
        }
        Collections.sort(returnUsers, new UserBestNameComparator(jiraServiceContext.getI18nBean().getLocale()));
        if (log.isDebugEnabled()) {
            log.debug((Object)("Sorted top " + returnUsers.size() + " users in " + stopWatch.getIntervalTime() + "ms"));
            log.debug((Object)("User-picker search completed in " + stopWatch.getTotalTime() + "ms"));
        }
        return returnUsers;
    }

    public boolean canShowEmailAddresses(JiraServiceContext jiraServiceContext) {
        String emailVisibility;
        return this.canPerformAjaxSearch(jiraServiceContext) && (VISIBILITY_PUBLIC.equals(emailVisibility = this.applicationProperties.getDefaultBackedString("jira.option.emailvisible")) || VISIBILITY_MASKED.equals(emailVisibility) || VISIBILITY_USER.equals(emailVisibility) && jiraServiceContext.getLoggedInUser() != null);
    }

    public boolean canPerformAjaxSearch(JiraServiceContext jiraServiceContext) {
        User loggedInUser = jiraServiceContext != null ? jiraServiceContext.getLoggedInUser() : null;
        return this.canPerformAjaxSearch(loggedInUser);
    }

    public boolean canPerformAjaxSearch(User user) {
        return this.permissionManager.hasPermission(27, user);
    }
}

