/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.bc.admin;

import com.atlassian.util.concurrent.LazyReference;
import com.atlassian.validation.ApplicationPropertyEnumerator;
import com.atlassian.validation.BooleanValidator;
import com.atlassian.validation.IntegerValidator;
import com.atlassian.validation.NonValidator;
import com.atlassian.validation.Validator;
import com.atlassian.validation.ValidatorFactory;
import com.google.common.base.Supplier;
import java.util.HashMap;
import java.util.Map;

public class ApplicationPropertyMetadata {
    private static final Map<String, Validator> DEFAULT_VALIDATORS_BY_TYPE = new HashMap<String, Validator>();
    private String key;
    private String type;
    private String defaultValue;
    private Supplier<? extends Validator> validator;
    private boolean userEditable;
    private boolean requiresRestart;
    private String name;
    private String nameKey;
    private String desc;
    private String descKey;
    private ApplicationPropertyEnumerator enumerator;

    private static Supplier<Validator> validatorResolver(final String type) {
        return new LazyReference<Validator>(){

            protected Validator create() throws Exception {
                Validator validator = (Validator)DEFAULT_VALIDATORS_BY_TYPE.get(type);
                if (validator == null) {
                    validator = new NonValidator();
                }
                return validator;
            }
        };
    }

    private ApplicationPropertyMetadata(String key, String type, String defaultValue, Supplier<? extends Validator> validatorSupplier, boolean userEditable, boolean requiresRestart, String name, String nameKey, String desc, String descKey, ApplicationPropertyEnumerator enumerator) {
        this.key = key;
        this.type = type;
        this.defaultValue = defaultValue;
        this.userEditable = userEditable;
        this.requiresRestart = requiresRestart;
        this.name = name;
        this.nameKey = nameKey;
        this.desc = desc;
        this.descKey = descKey;
        this.validator = validatorSupplier;
        this.enumerator = enumerator;
    }

    public String getType() {
        return this.type;
    }

    public String getKey() {
        return this.key;
    }

    public boolean isUserEditable() {
        return this.userEditable;
    }

    public boolean isRequiresRestart() {
        return this.requiresRestart;
    }

    public String getName() {
        return this.name;
    }

    public String getNameKey() {
        return this.nameKey;
    }

    public String getDescription() {
        return this.desc;
    }

    public String getDescriptionKey() {
        return this.descKey;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public Validator getValidator() {
        return (Validator)this.validator.get();
    }

    public ApplicationPropertyEnumerator getEnumerator() {
        if (!"enum".equals(this.type)) {
            throw new IllegalStateException("Tried to get enumerator for a non-enum type");
        }
        return this.enumerator;
    }

    public Validator.Result validate(String value) {
        return ((Validator)this.validator.get()).validate(value);
    }

    static {
        DEFAULT_VALIDATORS_BY_TYPE.put("string", new NonValidator());
        DEFAULT_VALIDATORS_BY_TYPE.put("uint", new IntegerValidator(0, Integer.MAX_VALUE));
        DEFAULT_VALIDATORS_BY_TYPE.put("int", new IntegerValidator());
        DEFAULT_VALIDATORS_BY_TYPE.put("boolean", new BooleanValidator());
    }

    public static class Builder {
        private String key;
        private String type;
        private String defaultValue;
        private Supplier<? extends Validator> validator;
        private boolean userEditable;
        private boolean requiresRestart;
        private String name;
        private String nameKey;
        private String desc;
        private String descKey;
        private ApplicationPropertyEnumerator enumerator;

        public String key() {
            return this.key;
        }

        public Builder key(String key) {
            this.key = key;
            return this;
        }

        public String type() {
            return this.type;
        }

        public Builder type(String type) {
            this.type = type;
            return this;
        }

        public String defaultValue() {
            return this.defaultValue;
        }

        public Builder defaultValue(String defaultValue) {
            this.defaultValue = defaultValue;
            return this;
        }

        public Supplier<? extends Validator> validator() {
            return this.validator;
        }

        public Builder validatorName(String validatorName) {
            this.validator = validatorName == null ? ApplicationPropertyMetadata.validatorResolver(this.type) : new ValidatorFactory().getInstanceLazyReference(validatorName);
            return this;
        }

        public Builder validator(Supplier<? extends Validator> validator) {
            this.validator = validator;
            return this;
        }

        public boolean userEditable() {
            return this.userEditable;
        }

        public Builder userEditable(boolean userEditable) {
            this.userEditable = userEditable;
            return this;
        }

        public boolean requiresRestart() {
            return this.requiresRestart;
        }

        public Builder requiresRestart(boolean requiresRestart) {
            this.requiresRestart = requiresRestart;
            return this;
        }

        public String name() {
            return this.name;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public String nameKey() {
            return this.nameKey;
        }

        public Builder nameKey(String nameKey) {
            this.nameKey = nameKey;
            return this;
        }

        public String desc() {
            return this.desc;
        }

        public Builder desc(String desc) {
            this.desc = desc;
            return this;
        }

        public String descKey() {
            return this.descKey;
        }

        public Builder descKey(String descKey) {
            this.descKey = descKey;
            return this;
        }

        public ApplicationPropertyEnumerator enumerator() {
            return this.enumerator;
        }

        public Builder enumerator(ApplicationPropertyEnumerator enumerator) {
            this.enumerator = enumerator;
            return this;
        }

        public ApplicationPropertyMetadata build() {
            return new ApplicationPropertyMetadata(this.key, this.type, this.defaultValue, this.validator, this.userEditable, this.requiresRestart, this.name, this.nameKey, this.desc, this.descKey, this.enumerator);
        }
    }
}

