/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.avatar;

import com.atlassian.core.util.map.EasyMap;
import com.atlassian.jira.avatar.Avatar;
import com.atlassian.jira.avatar.AvatarImpl;
import com.atlassian.jira.avatar.AvatarStore;
import com.atlassian.jira.exception.DataAccessException;
import com.atlassian.jira.ofbiz.OfBizDelegator;
import com.atlassian.jira.user.util.UserNames;
import com.atlassian.jira.util.dbc.Assertions;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.ofbiz.core.entity.GenericEntityException;
import org.ofbiz.core.entity.GenericValue;

public class OfbizAvatarStore
implements AvatarStore {
    static final String AVATAR_ENTITY = "Avatar";
    static final String ID = "id";
    static final String FILE_NAME = "fileName";
    static final String CONTENT_TYPE = "contentType";
    static final String AVATAR_TYPE = "avatarType";
    static final String OWNER = "owner";
    static final String SYSTEM_AVATAR = "systemAvatar";
    static final Integer IS_SYSTEM = 1;
    static final Integer NOT_SYSTEM = 0;
    private OfBizDelegator ofBizDelegator;

    public OfbizAvatarStore(OfBizDelegator ofBizDelegator) {
        this.ofBizDelegator = ofBizDelegator;
    }

    @Override
    public Avatar getById(Long avatarId) {
        Assertions.notNull((String)"avatarId", (Object)avatarId);
        GenericValue gv = this.ofBizDelegator.findById(AVATAR_ENTITY, avatarId);
        return gv == null ? null : this.gvToAvatar(gv);
    }

    @Override
    public boolean delete(Long avatarId) {
        Assertions.notNull((String)"avatarId", (Object)avatarId);
        int numRemoved = this.ofBizDelegator.removeByAnd(AVATAR_ENTITY, EasyMap.build((Object)ID, (Object)avatarId));
        return numRemoved != 0;
    }

    @Override
    public void update(Avatar avatar) {
        Assertions.notNull((String)"avatar", (Object)avatar);
        Long avatarId = (Long)Assertions.notNull((String)"avatar.id", (Object)avatar.getId());
        Assertions.notNull((String)"avatar.fileName", (Object)avatar.getFileName());
        Assertions.notNull((String)"avatar.contentType", (Object)avatar.getContentType());
        Assertions.notNull((String)"avatar.avatarType", (Object)avatar.getAvatarType());
        Assertions.notNull((String)"avatar.owner", (Object)avatar.getOwner());
        GenericValue gv = this.ofBizDelegator.findById(AVATAR_ENTITY, avatarId);
        gv.setNonPKFields(this.getNonPkFields(avatar));
        try {
            gv.store();
        }
        catch (GenericEntityException e) {
            throw new DataAccessException((Throwable)e);
        }
    }

    @Override
    public Avatar create(Avatar avatar) {
        Assertions.notNull((String)"avatar", (Object)avatar);
        Assertions.stateTrue((String)"avatar.id must be null", (avatar.getId() == null ? 1 : 0) != 0);
        Assertions.notNull((String)"avatar.fileName", (Object)avatar.getFileName());
        Assertions.notNull((String)"avatar.contentType", (Object)avatar.getContentType());
        Assertions.notNull((String)"avatar.avatarType", (Object)avatar.getAvatarType());
        return this.gvToAvatar(this.ofBizDelegator.createValue(AVATAR_ENTITY, this.getNonPkFields(avatar)));
    }

    @Override
    public List<Avatar> getAllSystemAvatars(Avatar.Type type) {
        return this.getAvatars(EasyMap.build((Object)SYSTEM_AVATAR, (Object)IS_SYSTEM, (Object)AVATAR_TYPE, (Object)type.getName()));
    }

    @Override
    public List<Avatar> getCustomAvatarsForOwner(Avatar.Type type, String ownerId) {
        Assertions.notNull((String)"type", (Object)type);
        Assertions.notNull((String)"ownerId", (Object)ownerId);
        return this.getAvatars(EasyMap.build((Object)SYSTEM_AVATAR, (Object)NOT_SYSTEM, (Object)AVATAR_TYPE, (Object)type.getName(), (Object)OWNER, (Object)UserNames.toKey(ownerId)));
    }

    List<Avatar> getAvatars(Map constraint) {
        ArrayList<Avatar> systemAvatars = new ArrayList<Avatar>();
        for (GenericValue gv : this.ofBizDelegator.findByAnd(AVATAR_ENTITY, constraint)) {
            systemAvatars.add(this.gvToAvatar(gv));
        }
        return systemAvatars;
    }

    private Map getNonPkFields(Avatar avatar) {
        HashMap<String, Object> fields = new HashMap<String, Object>();
        fields.put(FILE_NAME, avatar.getFileName());
        fields.put(CONTENT_TYPE, avatar.getContentType());
        fields.put(AVATAR_TYPE, avatar.getAvatarType().getName());
        fields.put(OWNER, UserNames.toKey(avatar.getOwner()));
        fields.put(SYSTEM_AVATAR, avatar.isSystemAvatar() ? IS_SYSTEM : NOT_SYSTEM);
        return fields;
    }

    Avatar gvToAvatar(GenericValue gv) {
        return new AvatarImpl(gv.getLong(ID), gv.getString(FILE_NAME), gv.getString(CONTENT_TYPE), Avatar.Type.getByName((String)gv.getString(AVATAR_TYPE)), gv.getString(OWNER), gv.getInteger(SYSTEM_AVATAR) != 0);
    }
}

