/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.applinks;

import com.atlassian.applinks.api.ApplicationId;
import com.atlassian.applinks.api.ApplicationType;
import com.atlassian.applinks.api.EntityType;
import com.atlassian.applinks.api.application.jira.JiraApplicationType;
import com.atlassian.applinks.api.application.jira.JiraProjectEntityType;
import com.atlassian.applinks.host.OsgiServiceProxyFactory;
import com.atlassian.applinks.host.spi.AbstractInternalHostApplication;
import com.atlassian.applinks.host.spi.DefaultEntityReference;
import com.atlassian.applinks.host.spi.EntityReference;
import com.atlassian.applinks.spi.util.TypeAccessor;
import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.bc.license.JiraLicenseService;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.extension.Startable;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.util.velocity.VelocityRequestContextFactory;
import com.atlassian.plugin.PluginAccessor;
import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collections;
import java.util.UUID;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;

public class JiraAppLinksHostApplication
extends AbstractInternalHostApplication
implements Startable {
    private final ApplicationProperties applicationProperties;
    private final JiraLicenseService jiraLicenseService;
    private final VelocityRequestContextFactory velocityRequestContextFactory;
    private final ProjectManager projectManager;
    private final JiraAuthenticationContext jiraAuthenticationContext;
    private final OsgiServiceProxyFactory osgiServiceProxyFactory;
    private final PermissionManager permissionManager;
    public static final long TIMEOUT = 10000L;
    private TypeAccessor typeAccessor;
    private final ThreadLocal<Boolean> skipPermissionCheck = new ThreadLocal();

    public JiraAppLinksHostApplication(PluginAccessor pluginAccessor, ApplicationProperties applicationProperties, JiraLicenseService jiraLicenseService, VelocityRequestContextFactory velocityRequestContextFactory, ProjectManager projectManager, JiraAuthenticationContext jiraAuthenticationContext, OsgiServiceProxyFactory osgiServiceProxyFactory, PermissionManager permissionManager) {
        super(pluginAccessor);
        this.applicationProperties = applicationProperties;
        this.jiraLicenseService = jiraLicenseService;
        this.velocityRequestContextFactory = velocityRequestContextFactory;
        this.projectManager = projectManager;
        this.jiraAuthenticationContext = jiraAuthenticationContext;
        this.osgiServiceProxyFactory = osgiServiceProxyFactory;
        this.permissionManager = permissionManager;
    }

    public URI getDocumentationBaseUrl() {
        return URI.create("http://confluence.atlassian.com/display/APPLINKS");
    }

    public String getName() {
        return this.applicationProperties.getString("jira.title");
    }

    public ApplicationType getType() {
        return this.typeAccessor.getApplicationType(JiraApplicationType.class);
    }

    public Iterable<EntityReference> getLocalEntities() {
        Iterable projects = Iterables.filter((Iterable)this.projectManager.getProjectObjects(), (Predicate)new Predicate<Project>(){

            public boolean apply(@Nullable Project input) {
                return input != null && JiraAppLinksHostApplication.this.checkProjectPermissions(input);
            }
        });
        if (!projects.iterator().hasNext()) {
            return Collections.emptyList();
        }
        return Lists.newArrayList((Iterable)Iterables.transform((Iterable)projects, (Function)new ProjectToEntityRef()));
    }

    public boolean doesEntityExist(String key, Class<? extends EntityType> type) {
        Project project;
        if (JiraProjectEntityType.class.isAssignableFrom(type) && (project = this.projectManager.getProjectObjByKey(key)) != null) {
            return this.checkProjectPermissions(project);
        }
        return false;
    }

    public boolean doesEntityExistNoPermissionCheck(String key, Class<? extends EntityType> type) {
        Project project;
        return JiraProjectEntityType.class.isAssignableFrom(type) && (project = this.projectManager.getProjectObjByKey(key)) != null;
    }

    public EntityReference toEntityReference(Object domainObject) {
        if (domainObject instanceof Project) {
            Project jiraProject = (Project)domainObject;
            return new DefaultEntityReference(jiraProject.getKey(), jiraProject.getName(), (EntityType)this.entityType(JiraProjectEntityType.class));
        }
        throw new IllegalArgumentException("Entity is not supported: " + domainObject);
    }

    public EntityReference toEntityReference(String key, Class<? extends EntityType> type) {
        if (type != null && JiraProjectEntityType.class.isAssignableFrom(type)) {
            Project project = this.projectManager.getProjectObjByKey(key);
            if (project == null) {
                throw new IllegalArgumentException("The specified key could not be resolved to a project: " + key);
            }
            return new DefaultEntityReference(project.getKey(), project.getName(), (EntityType)this.entityType(JiraProjectEntityType.class));
        }
        throw new IllegalArgumentException("Entity type is not supported: " + type);
    }

    public boolean canManageEntityLinksFor(EntityReference entityReference) {
        Project project;
        if (entityReference != null && entityReference.getType() instanceof JiraProjectEntityType && (project = this.projectManager.getProjectObjByKey(entityReference.getKey())) != null) {
            return this.checkProjectPermissions(project);
        }
        return false;
    }

    private boolean checkProjectPermissions(Project project) {
        if (this.skipPermissions()) {
            return true;
        }
        if (project == null) {
            return false;
        }
        return this.permissionManager.hasPermission(10, project, this.jiraAuthenticationContext.getLoggedInUser()) || this.permissionManager.hasPermission(0, this.jiraAuthenticationContext.getLoggedInUser()) || this.permissionManager.hasPermission(23, project, this.jiraAuthenticationContext.getLoggedInUser());
    }

    private boolean skipPermissions() {
        return this.skipPermissionCheck.get() == null ? false : this.skipPermissionCheck.get();
    }

    public void setSkipPermissionCheck(boolean skip) {
        this.skipPermissionCheck.set(skip);
    }

    public void clearSkipPermissionCheck() {
        this.skipPermissionCheck.remove();
    }

    public boolean hasPublicSignup() {
        return "public".equals(this.applicationProperties.getString("jira.mode"));
    }

    public ApplicationId getId() {
        String serverId = this.jiraLicenseService.getServerId();
        try {
            return new ApplicationId(UUID.nameUUIDFromBytes(serverId.getBytes("UTF-8")).toString());
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException("UTF-8 is not supported. WTF?", e);
        }
    }

    public URI getBaseUrl() {
        String baseUrl = this.applicationProperties.getString("jira.baseurl");
        if (StringUtils.isEmpty((String)baseUrl)) {
            baseUrl = this.velocityRequestContextFactory.getJiraVelocityRequestContext().getCanonicalBaseUrl();
        }
        try {
            return new URI(baseUrl);
        }
        catch (URISyntaxException e) {
            throw new IllegalStateException("Invalid base url: " + baseUrl, e);
        }
    }

    private <T extends EntityType> T entityType(Class<T> entityTypeClass) {
        return (T)this.typeAccessor.getEntityType(entityTypeClass);
    }

    private User getUser() {
        return this.jiraAuthenticationContext.getLoggedInUser();
    }

    public void start() throws Exception {
        this.typeAccessor = (TypeAccessor)this.osgiServiceProxyFactory.createProxy(TypeAccessor.class, 10000L);
    }

    private class ProjectToEntityRef
    implements Function<Project, EntityReference> {
        private ProjectToEntityRef() {
        }

        public EntityReference apply(@Nullable Project from) {
            return new DefaultEntityReference(from.getKey(), from.getName(), JiraAppLinksHostApplication.this.entityType(JiraProjectEntityType.class));
        }
    }
}

