/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.validation;

import com.atlassian.validation.Failure;
import com.atlassian.validation.Success;
import com.atlassian.validation.Validator;
import com.opensymphony.util.TextUtils;

public final class IntegerValidator
implements Validator {
    private final int min;
    private final int max;

    public IntegerValidator() {
        this(Integer.MIN_VALUE, Integer.MAX_VALUE);
    }

    public IntegerValidator(int minValue, int maxValue) {
        this.min = minValue;
        this.max = maxValue;
    }

    @Override
    public Validator.Result validate(String value) {
        try {
            int integerValue = Integer.parseInt(value);
            if (integerValue < this.min) {
                return new Failure("Value must be at least " + this.min);
            }
            if (integerValue > this.max) {
                return new Failure("Value must be no more than " + this.max);
            }
            return new Success(value);
        }
        catch (NumberFormatException e) {
            String html = '\'' + TextUtils.htmlEncode((String)value) + "' cannot be parsed to an integer.";
            String text = '\'' + value + "' cannot be parsed to an integer.";
            return new Failure(text, html);
        }
    }
}

