/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.workflow;

import com.atlassian.core.ofbiz.association.AssociationManager;
import com.atlassian.crowd.embedded.api.User;
import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.config.ConstantsManager;
import com.atlassian.jira.entity.EntityUtils;
import com.atlassian.jira.event.ClearCacheEvent;
import com.atlassian.jira.event.workflow.WorkflowSchemeAddedToProjectEvent;
import com.atlassian.jira.event.workflow.WorkflowSchemeCopiedEvent;
import com.atlassian.jira.event.workflow.WorkflowSchemeCreatedEvent;
import com.atlassian.jira.event.workflow.WorkflowSchemeDeletedEvent;
import com.atlassian.jira.event.workflow.WorkflowSchemeUpdatedEvent;
import com.atlassian.jira.exception.DataAccessException;
import com.atlassian.jira.exception.RemoveException;
import com.atlassian.jira.extension.Startable;
import com.atlassian.jira.ofbiz.FieldMap;
import com.atlassian.jira.ofbiz.OfBizDelegator;
import com.atlassian.jira.permission.PermissionContextFactory;
import com.atlassian.jira.permission.PermissionTypeManager;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.scheme.AbstractSchemeManager;
import com.atlassian.jira.scheme.Scheme;
import com.atlassian.jira.scheme.SchemeEntity;
import com.atlassian.jira.scheme.SchemeFactory;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.groups.GroupManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.util.UserManager;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.collect.MapBuilder;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.jira.workflow.AssignableWorkflowScheme;
import com.atlassian.jira.workflow.AssignableWorkflowSchemeBuilder;
import com.atlassian.jira.workflow.AssignableWorkflowSchemeStore;
import com.atlassian.jira.workflow.DefaultWorkflowScheme;
import com.atlassian.jira.workflow.DraftWorkflowScheme;
import com.atlassian.jira.workflow.DraftWorkflowSchemeBuilder;
import com.atlassian.jira.workflow.DraftWorkflowSchemeImpl;
import com.atlassian.jira.workflow.DraftWorkflowSchemeStore;
import com.atlassian.jira.workflow.JiraWorkflow;
import com.atlassian.jira.workflow.WorkflowException;
import com.atlassian.jira.workflow.WorkflowManager;
import com.atlassian.jira.workflow.WorkflowScheme;
import com.atlassian.jira.workflow.WorkflowSchemeImpl;
import com.atlassian.jira.workflow.WorkflowSchemeManager;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.jcip.annotations.GuardedBy;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.ofbiz.core.entity.EntityUtil;
import org.ofbiz.core.entity.GenericEntityException;
import org.ofbiz.core.entity.GenericValue;

public class DefaultWorkflowSchemeManager
extends AbstractSchemeManager
implements WorkflowSchemeManager,
Startable {
    private static final Logger log = Logger.getLogger(DefaultWorkflowSchemeManager.class);
    private static final String ALL_ISSUE_TYPES = "0";
    private static final String SCHEME_ENTITY_NAME = "WorkflowScheme";
    private static final String WORKFLOW_ENTITY_NAME = "WorkflowSchemeEntity";
    private static final String SCHEME_DESC = "Workflow";
    private static final String DEFAULT_NAME_KEY = "admin.schemes.workflows.default";
    private static final String DEFAULT_DESC_KEY = "admin.schemes.workflows.default.desc";
    private static final String COLUMN_ISSUETYPE = "issuetype";
    private static final String COLUMN_WORKFLOW = "workflow";
    private final AssignableWorkflowScheme defaultScheme;
    private final Map<Long, Map<String, GenericValue>> cache = new ConcurrentHashMap<Long, Map<String, GenericValue>>();
    private final ActiveWorkflowCache activeWorkflowCache = new ActiveWorkflowCache();
    private final WorkflowManager workflowManager;
    private final ConstantsManager constantsManager;
    private final OfBizDelegator ofBizDelegator;
    private final EventPublisher eventPublisher;
    private final DraftWorkflowSchemeStore draftWorkflowSchemeStore;
    private final UserManager userManager;
    private final I18nHelper.BeanFactory i18nFactory;
    private final AssignableWorkflowSchemeStore assignableWorkflowSchemeStore;

    public DefaultWorkflowSchemeManager(ProjectManager projectManager, PermissionTypeManager permissionTypeManager, PermissionContextFactory permissionContextFactory, SchemeFactory schemeFactory, WorkflowManager workflowManager, ConstantsManager constantsManager, OfBizDelegator ofBizDelegator, EventPublisher eventPublisher, AssociationManager associationManager, GroupManager groupManager, DraftWorkflowSchemeStore draftWorkflowSchemeStore, JiraAuthenticationContext context, UserManager userManager, I18nHelper.BeanFactory i18nFactory, AssignableWorkflowSchemeStore assignableWorkflowSchemeStore) {
        super(projectManager, permissionTypeManager, permissionContextFactory, schemeFactory, associationManager, ofBizDelegator, groupManager);
        this.workflowManager = workflowManager;
        this.constantsManager = constantsManager;
        this.ofBizDelegator = ofBizDelegator;
        this.eventPublisher = eventPublisher;
        this.draftWorkflowSchemeStore = draftWorkflowSchemeStore;
        this.userManager = userManager;
        this.i18nFactory = i18nFactory;
        this.assignableWorkflowSchemeStore = assignableWorkflowSchemeStore;
        this.defaultScheme = new DefaultWorkflowScheme(context);
    }

    public void start() throws Exception {
        this.eventPublisher.register((Object)this);
    }

    @Override
    @EventListener
    public void onClearCache(ClearCacheEvent event) {
        super.onClearCache(event);
        this.clearWorkflowCache();
    }

    @Override
    public String getSchemeEntityName() {
        return SCHEME_ENTITY_NAME;
    }

    @Override
    public String getEntityName() {
        return WORKFLOW_ENTITY_NAME;
    }

    public void clearWorkflowCache() {
        this.activeWorkflowCache.clear();
        this.clearCache();
    }

    @Override
    public String getSchemeDesc() {
        return SCHEME_DESC;
    }

    @Override
    public String getDefaultNameKey() {
        return DEFAULT_NAME_KEY;
    }

    @Override
    public String getDefaultDescriptionKey() {
        return DEFAULT_DESC_KEY;
    }

    public GenericValue getWorkflowScheme(GenericValue project) throws GenericEntityException {
        return EntityUtil.getOnly(this.getSchemes(project));
    }

    private Map<String, String> toWorkflowMap(Iterable<GenericValue> related) {
        HashMap mapping = Maps.newHashMap();
        for (GenericValue value : related) {
            String issuetype = value.getString(COLUMN_ISSUETYPE);
            String workflow = value.getString(COLUMN_WORKFLOW);
            if (issuetype == null) continue;
            if (ALL_ISSUE_TYPES.equals(issuetype)) {
                mapping.put(null, workflow);
                continue;
            }
            mapping.put(issuetype, workflow);
        }
        return mapping;
    }

    public boolean hasDraft(@Nonnull AssignableWorkflowScheme scheme) {
        Assertions.notNull((String)"scheme", (Object)scheme);
        return !scheme.isDefault() && scheme.getId() != null && this.draftWorkflowSchemeStore.hasDraftForParent(scheme.getId());
    }

    @Nonnull
    public AssignableWorkflowScheme createScheme(@Nonnull AssignableWorkflowScheme workflowScheme) {
        Assertions.notNull((String)"wokflowScheme", (Object)workflowScheme);
        AssignableWorkflowSchemeStore.AssignableState.Builder builder = this.assignableWorkflowSchemeStore.builder();
        builder.setName(workflowScheme.getName()).setDescription(workflowScheme.getDescription()).setMappings(workflowScheme.getMappings());
        AssignableWorkflowSchemeStore.AssignableState savedState = this.assignableWorkflowSchemeStore.create(builder.build());
        return DefaultWorkflowSchemeManager.toWorkflowScheme(savedState);
    }

    public GenericValue createSchemeEntity(GenericValue scheme, SchemeEntity schemeEntity) throws GenericEntityException {
        return this.createSchemeEntity(scheme.getLong("id"), schemeEntity);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GenericValue createSchemeEntity(long schemeId, SchemeEntity schemeEntity) throws GenericEntityException {
        if (!(schemeEntity.getEntityTypeId() instanceof String)) {
            throw new IllegalArgumentException("Workflow scheme IDs must be String values.");
        }
        try {
            GenericValue genericValue = EntityUtils.createValue(this.getEntityName(), (Map<String, Object>)FieldMap.build((String)"scheme", (Object)schemeId, (String)COLUMN_WORKFLOW, (Object)schemeEntity.getType(), (String)COLUMN_ISSUETYPE, (Object)schemeEntity.getEntityTypeId().toString()));
            return genericValue;
        }
        finally {
            this.clearCache();
        }
    }

    private void clearCache() {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Clearing workflow scheme entity cache, had " + this.cache.size() + " entries"));
        }
        this.cache.clear();
    }

    public List<GenericValue> getEntities(GenericValue scheme, String issuetype) throws GenericEntityException {
        Map<String, GenericValue> genericValueMap = this.getAndCacheSchemeMap(scheme);
        GenericValue value = genericValueMap.get(issuetype);
        if (value == null) {
            return Collections.emptyList();
        }
        return Collections.singletonList(value);
    }

    public Map<String, String> getWorkflowMap(Project project) {
        GenericValue schemeForProject = this.getSchemeForProject(project);
        return this.getWorkflowMap(schemeForProject);
    }

    @VisibleForTesting
    Map<String, String> getWorkflowMap(GenericValue schemeForProject) {
        if (schemeForProject == null) {
            return MapBuilder.build(null, (Object)"jira");
        }
        Map<String, GenericValue> schemeMap = this.getAndCacheSchemeMap(schemeForProject);
        return this.toWorkflowMap(schemeMap.values());
    }

    public String getWorkflowName(Project project, String issueType) {
        return this.getWorkflowName(this.getSchemeForProject(project), issueType);
    }

    public String getWorkflowName(GenericValue scheme, String issueType) {
        if (scheme != null) {
            Map<String, GenericValue> map = this.getAndCacheSchemeMap(scheme);
            GenericValue value = map.get(issueType);
            if (value == null) {
                value = map.get(ALL_ISSUE_TYPES);
            }
            if (value != null) {
                return value.getString(COLUMN_WORKFLOW);
            }
        }
        return "jira";
    }

    public boolean isUsingDefaultScheme(Project project) {
        return this.getSchemeForProject(project) == null;
    }

    @VisibleForTesting
    GenericValue getSchemeForProject(Project project) {
        return this.getSchemeForProject(project.getGenericValue());
    }

    @VisibleForTesting
    GenericValue getSchemeForProject(GenericValue project) {
        try {
            return EntityUtil.getOnly(this.getSchemes(project));
        }
        catch (GenericEntityException e) {
            throw new DataAccessException((Throwable)e);
        }
    }

    private static Long getCacheKeyForScheme(GenericValue scheme) {
        return scheme.getLong("id");
    }

    private Map<String, GenericValue> getAndCacheSchemeMap(GenericValue scheme) {
        if (scheme == null) {
            return Collections.emptyMap();
        }
        Long cacheKeyForScheme = DefaultWorkflowSchemeManager.getCacheKeyForScheme(scheme);
        Map<String, GenericValue> cachedEntry = this.cache.get(cacheKeyForScheme);
        if (cachedEntry != null) {
            return cachedEntry;
        }
        Map<String, GenericValue> schemeMap = this.getSchemeMapFromDatabase(scheme);
        this.cache.put(cacheKeyForScheme, Collections.unmodifiableMap(schemeMap));
        return schemeMap;
    }

    private Map<String, GenericValue> getSchemeMapFromDatabase(GenericValue scheme) {
        List valueList;
        try {
            valueList = scheme.getRelated("Child" + scheme.getEntityName() + "Entity");
        }
        catch (GenericEntityException e) {
            throw new DataAccessException((Throwable)e);
        }
        HashMap<String, GenericValue> schemeMap = new HashMap<String, GenericValue>();
        for (GenericValue value : valueList) {
            String issueType = value.getString(COLUMN_ISSUETYPE);
            if (issueType == null) continue;
            schemeMap.put(issueType, value);
        }
        return schemeMap;
    }

    @Override
    public GenericValue copySchemeEntity(GenericValue scheme, GenericValue entity) throws GenericEntityException {
        SchemeEntity schemeEntity = new SchemeEntity(entity.getString(COLUMN_WORKFLOW), (Object)entity.getString(COLUMN_ISSUETYPE));
        return this.createSchemeEntity(scheme, schemeEntity);
    }

    public List<GenericValue> getEntities(GenericValue scheme, Long entityTypeId) throws GenericEntityException {
        throw new IllegalArgumentException("Workflow scheme IDs must be String values.");
    }

    public List<GenericValue> getEntities(GenericValue scheme, Long entityTypeId, String parameter) throws GenericEntityException {
        throw new IllegalArgumentException("Workflow scheme IDs must be String values.");
    }

    public List<GenericValue> getEntities(GenericValue scheme, String type, Long entityTypeId) throws GenericEntityException {
        throw new IllegalArgumentException("Workflow scheme IDs must be String values.");
    }

    public boolean hasSchemeAuthority(Long entityType, GenericValue entity) {
        return false;
    }

    public boolean hasSchemeAuthority(Long entityType, GenericValue entity, User user, boolean issueCreation) {
        return false;
    }

    public GenericValue getDefaultEntity(GenericValue scheme) throws GenericEntityException {
        return EntityUtil.getOnly(this.getEntities(scheme, ALL_ISSUE_TYPES));
    }

    public AssignableWorkflowScheme getDefaultWorkflowScheme() {
        return this.defaultScheme;
    }

    public List<GenericValue> getNonDefaultEntities(GenericValue scheme) throws GenericEntityException {
        List<GenericValue> entities = this.getEntities(scheme);
        Iterator<GenericValue> iterator = entities.iterator();
        while (iterator.hasNext()) {
            GenericValue genericValue = iterator.next();
            if (!ALL_ISSUE_TYPES.equals(genericValue.getString(COLUMN_ISSUETYPE))) continue;
            iterator.remove();
            break;
        }
        return entities;
    }

    public Collection<String> getActiveWorkflowNames() throws GenericEntityException, WorkflowException {
        return this.activeWorkflowCache.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addWorkflowToScheme(GenericValue scheme, String workflowName, String issueTypeId) throws GenericEntityException {
        try {
            SchemeEntity schemeEntity = new SchemeEntity(workflowName, (Object)issueTypeId);
            if (this.getEntities(scheme, issueTypeId).isEmpty()) {
                this.createSchemeEntity(scheme, schemeEntity);
            }
        }
        finally {
            this.clearWorkflowCache();
        }
    }

    @Nonnull
    public DraftWorkflowScheme createDraftOf(ApplicationUser creator, @Nonnull AssignableWorkflowScheme workflowScheme) {
        Assertions.notNull((String)"workflowScheme", (Object)workflowScheme);
        Assertions.not((String)"workflowScheme.default", (boolean)workflowScheme.isDefault());
        Assertions.notNull((String)"workflowScheme.id", (Object)workflowScheme.getId());
        Assertions.not((String)"scheme already has draft.", (boolean)this.hasDraft(workflowScheme));
        DraftWorkflowSchemeStore.DraftState.Builder builder = this.draftWorkflowSchemeStore.builder(workflowScheme.getId());
        builder.setMappings(workflowScheme.getMappings());
        builder.setLastModifiedUser(creator != null ? creator.getKey() : null);
        DraftWorkflowSchemeStore.DraftState state = this.draftWorkflowSchemeStore.create(builder.build());
        return this.toWorkflowScheme(state);
    }

    @Nonnull
    public DraftWorkflowScheme createDraft(ApplicationUser creator, @Nonnull DraftWorkflowScheme workflowScheme) {
        Assertions.notNull((String)"workflowScheme", (Object)workflowScheme);
        AssignableWorkflowScheme parentScheme = workflowScheme.getParentScheme();
        Assertions.notNull((String)"workflowScheme.parentScheme", (Object)parentScheme);
        Assertions.notNull((String)"workflowScheme.parentScheme.id", (Object)parentScheme.getId());
        Assertions.not((String)"scheme already has draft.", (boolean)this.hasDraft(parentScheme));
        DraftWorkflowSchemeStore.DraftState.Builder builder = this.draftWorkflowSchemeStore.builder(parentScheme.getId());
        builder.setMappings(workflowScheme.getMappings());
        builder.setLastModifiedUser(creator != null ? creator.getKey() : null);
        DraftWorkflowSchemeStore.DraftState state = this.draftWorkflowSchemeStore.create(builder.build());
        return this.toWorkflowScheme(state);
    }

    public void updateSchemesForRenamedWorkflow(String oldWorkflowName, String newWorkflowName) {
        if (StringUtils.isBlank((String)oldWorkflowName)) {
            throw new IllegalArgumentException("oldWorkflowName must not be null or empty string");
        }
        if (StringUtils.isBlank((String)newWorkflowName)) {
            throw new IllegalArgumentException("newWorkflowName must not be null or empty string");
        }
        this.ofBizDelegator.bulkUpdateByAnd(this.getEntityName(), (Map)ImmutableMap.of((Object)COLUMN_WORKFLOW, (Object)newWorkflowName), (Map)ImmutableMap.of((Object)COLUMN_WORKFLOW, (Object)oldWorkflowName));
        this.draftWorkflowSchemeStore.renameWorkflow(oldWorkflowName, newWorkflowName);
        this.clearWorkflowCache();
    }

    public Collection<GenericValue> getSchemesForWorkflow(JiraWorkflow workflow) {
        LinkedList<GenericValue> schemes = new LinkedList<GenericValue>();
        HashSet<Long> schemeIds = new HashSet<Long>();
        List schemeEntities = this.ofBizDelegator.findByAnd(this.getEntityName(), MapBuilder.build((Object)COLUMN_WORKFLOW, (Object)workflow.getName()));
        for (GenericValue schemeEntity : schemeEntities) {
            Long schemeId = schemeEntity.getLong("scheme");
            if (schemeIds.contains(schemeId)) continue;
            schemes.add(this.getScheme(schemeId));
            schemeIds.add(schemeId);
        }
        return schemes;
    }

    public Iterable<WorkflowScheme> getSchemesForWorkflowIncludingDrafts(JiraWorkflow workflow) {
        if (workflow.isSystemWorkflow()) {
            throw new IllegalArgumentException("Can't get schemes for system workflow");
        }
        Collection<GenericValue> schemes = this.getSchemesForWorkflow(workflow);
        Iterable draftSchemeStates = this.draftWorkflowSchemeStore.getSchemesUsingWorkflow(workflow);
        ArrayList allSchemes = Lists.newArrayListWithCapacity((int)(schemes.size() + Iterables.size(draftSchemeStates)));
        for (GenericValue schemeGenericValue : schemes) {
            allSchemes.add(this.toWorkflowScheme(schemeGenericValue));
        }
        for (DraftWorkflowSchemeStore.DraftState draftState : draftSchemeStates) {
            allSchemes.add(this.toWorkflowScheme(draftState));
        }
        return allSchemes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteEntity(Long id) throws DataAccessException {
        try {
            super.deleteEntity(id);
        }
        finally {
            this.clearCache();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeEntities(GenericValue scheme, Long entityTypeId) throws RemoveException {
        try {
            boolean bl = super.removeEntities(scheme, entityTypeId);
            return bl;
        }
        finally {
            this.clearCache();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GenericValue createScheme(String name, String description) throws GenericEntityException {
        try {
            GenericValue genericValue = super.createScheme(name, description);
            return genericValue;
        }
        finally {
            this.clearCache();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Scheme createSchemeObject(String name, String description) {
        try {
            Scheme scheme = super.createSchemeObject(name, description);
            if (scheme != null) {
                this.eventPublisher.publish((Object)new WorkflowSchemeCreatedEvent(scheme));
            }
            Scheme scheme2 = scheme;
            return scheme2;
        }
        finally {
            this.clearCache();
        }
    }

    @Override
    public Scheme copyScheme(Scheme scheme) {
        Scheme result = super.copyScheme(scheme);
        if (result != null) {
            this.eventPublisher.publish((Object)new WorkflowSchemeCopiedEvent(scheme, result));
        }
        return result;
    }

    @Override
    public void updateScheme(Scheme scheme) throws DataAccessException {
        super.updateScheme(scheme);
        this.eventPublisher.publish((Object)new WorkflowSchemeUpdatedEvent(scheme));
    }

    @Override
    public void deleteScheme(Long id) {
        if (id == null) {
            return;
        }
        try {
            super.deleteScheme(id);
        }
        catch (GenericEntityException e) {
            throw new DataAccessException((Throwable)e);
        }
        this.draftWorkflowSchemeStore.deleteByParentId(id);
        this.eventPublisher.publish((Object)new WorkflowSchemeDeletedEvent(id));
    }

    @Override
    public void addSchemeToProject(GenericValue project, GenericValue scheme) throws GenericEntityException {
        super.addSchemeToProject(project, scheme);
        Long projectId = project == null ? null : project.getLong("id");
        Long schemeId = scheme == null ? null : scheme.getLong("id");
        this.eventPublisher.publish((Object)new WorkflowSchemeAddedToProjectEvent(projectId, schemeId));
    }

    @Override
    public void addSchemeToProject(Project project, Scheme scheme) throws DataAccessException {
        super.addSchemeToProject(project, scheme);
        Long projectId = project == null ? null : project.getId();
        Long schemeId = scheme == null ? null : scheme.getId();
        this.eventPublisher.publish((Object)new WorkflowSchemeAddedToProjectEvent(projectId, schemeId));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void flushProjectSchemes() {
        try {
            super.flushProjectSchemes();
        }
        finally {
            this.clearCache();
        }
    }

    protected List<GenericValue> getAllIssueTypes() {
        return this.constantsManager.getAllIssueTypes();
    }

    protected JiraWorkflow getWorkflowFromScheme(GenericValue workflowScheme, String issueTypeId) {
        return this.workflowManager.getWorkflowFromScheme(workflowScheme, issueTypeId);
    }

    @Nullable
    public AssignableWorkflowScheme getWorkflowSchemeObj(long id) {
        return this.toWorkflowScheme(this.getScheme(id));
    }

    public AssignableWorkflowScheme getWorkflowSchemeObj(String name) {
        return this.toWorkflowScheme(this.getScheme(name));
    }

    public DraftWorkflowScheme getDraftForParent(@Nonnull AssignableWorkflowScheme scheme) {
        Assertions.notNull((String)"scheme", (Object)scheme);
        if (scheme.isDefault() || scheme.getId() == null) {
            return null;
        }
        return this.getDraftForParent(scheme.getId());
    }

    private DraftWorkflowScheme getDraftForParent(long parentId) {
        DraftWorkflowSchemeStore.DraftState draftScheme = this.draftWorkflowSchemeStore.getDraftForParent(parentId);
        return this.toWorkflowScheme(draftScheme);
    }

    public DraftWorkflowScheme getDraft(long id) {
        DraftWorkflowSchemeStore.DraftState draftScheme = (DraftWorkflowSchemeStore.DraftState)this.draftWorkflowSchemeStore.get(id);
        return this.toWorkflowScheme(draftScheme);
    }

    public AssignableWorkflowScheme getParentForDraft(long draftSchemeId) {
        long parentId = this.draftWorkflowSchemeStore.getParentId(draftSchemeId);
        return this.getWorkflowSchemeObj(parentId);
    }

    public boolean isActive(@Nonnull WorkflowScheme scheme) {
        Assertions.notNull((String)"scheme", (Object)scheme);
        if (scheme.isDraft()) {
            return false;
        }
        if (scheme.isDefault()) {
            List projectObjects = this.projectManager.getProjectObjects();
            for (Project projectObject : projectObjects) {
                if (!this.isUsingDefaultScheme(projectObject)) continue;
                return true;
            }
            return false;
        }
        if (scheme.getId() == null) {
            return false;
        }
        try {
            GenericValue genericValue = this.getScheme(scheme.getId());
            if (genericValue != null) {
                List<GenericValue> projects = this.getProjects(genericValue);
                return !projects.isEmpty();
            }
            return false;
        }
        catch (GenericEntityException e) {
            throw new DataAccessException((Throwable)e);
        }
    }

    public boolean deleteWorkflowScheme(@Nonnull WorkflowScheme scheme) {
        Assertions.notNull((String)"scheme", (Object)scheme);
        Assertions.not((String)"scheme.default", (boolean)scheme.isDefault());
        Assertions.notNull((String)"scheme.id", (Object)scheme.getId());
        if (scheme.isDraft()) {
            return this.draftWorkflowSchemeStore.delete(scheme.getId());
        }
        Assertions.not((String)"Cannot delete active scheme.", (boolean)this.isActive(scheme));
        this.deleteScheme(scheme.getId());
        return true;
    }

    public DraftWorkflowScheme updateDraftWorkflowScheme(ApplicationUser user, @Nonnull DraftWorkflowScheme scheme) {
        Assertions.notNull((String)"scheme", (Object)scheme);
        Assertions.notNull((String)"scheme.id", (Object)scheme.getId());
        DraftWorkflowSchemeStore.DraftState savedState = (DraftWorkflowSchemeStore.DraftState)this.draftWorkflowSchemeStore.get(scheme.getId());
        Assertions.notNull((String)String.format("scheme with id %d does not exist.", scheme.getId()), (Object)savedState);
        DraftWorkflowSchemeStore.DraftState.Builder builder = savedState.builder();
        builder.setMappings(scheme.getMappings());
        builder.setLastModifiedUser(user == null ? null : user.getKey());
        return this.toWorkflowScheme(this.draftWorkflowSchemeStore.update(builder.build()));
    }

    public AssignableWorkflowScheme updateWorkflowScheme(@Nonnull AssignableWorkflowScheme workflowScheme) {
        Assertions.notNull((String)"scheme", (Object)workflowScheme);
        Scheme scheme = this.getSchemeObject(workflowScheme.getId());
        Collection entities = scheme.getEntities();
        for (SchemeEntity entity : entities) {
            this.deleteEntity(entity.getId());
        }
        scheme = new Scheme(workflowScheme.getId(), this.getSchemeEntityName(), workflowScheme.getName(), workflowScheme.getDescription(), Collections.emptyList());
        this.updateScheme(scheme);
        this.createSchemeEntities(workflowScheme);
        return this.getWorkflowSchemeObj(workflowScheme.getId());
    }

    private void createSchemeEntities(AssignableWorkflowScheme workflowScheme) {
        for (Map.Entry mappingEntry : workflowScheme.getMappings().entrySet()) {
            String issueTypeId = (String)mappingEntry.getKey();
            if (issueTypeId == null) {
                issueTypeId = ALL_ISSUE_TYPES;
            }
            String workflowName = (String)mappingEntry.getValue();
            SchemeEntity schemeEntity = new SchemeEntity(workflowName, (Object)issueTypeId);
            try {
                this.createSchemeEntity(workflowScheme.getId(), schemeEntity);
            }
            catch (GenericEntityException e) {
                throw new DataAccessException((Throwable)e);
            }
        }
    }

    @Nonnull
    public AssignableWorkflowScheme getWorkflowSchemeObj(@Nonnull Project project) {
        Assertions.notNull((String)"project", (Object)project);
        GenericValue schemeForProject = this.getSchemeForProject(project);
        if (schemeForProject != null) {
            return this.toWorkflowScheme(schemeForProject);
        }
        return this.defaultScheme;
    }

    @Nonnull
    public List<Project> getProjectsUsing(@Nonnull AssignableWorkflowScheme workflowScheme) {
        Assertions.notNull((String)"workflowScheme", (Object)workflowScheme);
        ImmutableList.Builder projects = new ImmutableList.Builder();
        for (Project project : this.projectManager.getProjectObjects()) {
            GenericValue schemeForProject = this.getSchemeForProject(project);
            if (schemeForProject == null) {
                if (!workflowScheme.isDefault()) continue;
                projects.add((Object)project);
                continue;
            }
            Long id = schemeForProject.getLong("id");
            if (id == null || !id.equals(workflowScheme.getId())) continue;
            projects.add((Object)project);
        }
        return projects.build();
    }

    public AssignableWorkflowScheme cleanUpSchemeDraft(Project project, User user) {
        AssignableWorkflowScheme workflowScheme = this.getWorkflowSchemeObj(project);
        if (workflowScheme.isDefault()) {
            return null;
        }
        List<Project> projectsUsing = this.getProjectsUsing(workflowScheme);
        if (projectsUsing.size() > 1) {
            return null;
        }
        DraftWorkflowScheme draft = this.getDraftForParent(workflowScheme);
        if (draft == null) {
            return null;
        }
        AssignableWorkflowScheme.Builder copyOfDraftBuilder = (AssignableWorkflowScheme.Builder)new AssignableWorkflowSchemeBuilder().setName(this.getNameForCopy((WorkflowScheme)draft)).setDescription(this.getDescriptionForCopy(user, workflowScheme)).setMappings(draft.getMappings());
        AssignableWorkflowScheme scheme = this.createScheme(copyOfDraftBuilder.build());
        this.deleteWorkflowScheme((WorkflowScheme)draft);
        return scheme;
    }

    public AssignableWorkflowScheme copyDraft(DraftWorkflowScheme draft, User user, String newDescription) {
        AssignableWorkflowScheme.Builder copyOfDraftBuilder = (AssignableWorkflowScheme.Builder)new AssignableWorkflowSchemeBuilder().setName(this.getNameForCopy((WorkflowScheme)draft)).setDescription(newDescription).setMappings(draft.getMappings());
        return this.createScheme(copyOfDraftBuilder.build());
    }

    private String getNameForCopy(WorkflowScheme scheme) {
        return this.getNameForCopy(scheme.getName(), 255);
    }

    public void replaceSchemeWithDraft(DraftWorkflowScheme draft) {
        AssignableWorkflowScheme parentScheme = ((AssignableWorkflowScheme.Builder)this.getParentForDraft(draft.getId()).builder().setMappings(draft.getMappings())).build();
        this.updateWorkflowScheme(parentScheme);
        this.deleteWorkflowScheme((WorkflowScheme)draft);
    }

    public AssignableWorkflowScheme.Builder assignableBuilder() {
        return new AssignableWorkflowSchemeBuilder();
    }

    public DraftWorkflowScheme.Builder draftBuilder(AssignableWorkflowScheme parent) {
        Assertions.notNull((String)"parent", (Object)parent);
        Assertions.notNull((String)"parent.id", (Object)parent.getId());
        return new DraftWorkflowSchemeBuilder(parent);
    }

    String getDescriptionForCopy(User user, AssignableWorkflowScheme workflowScheme) {
        StringBuilder sb = new StringBuilder();
        if (StringUtils.isNotBlank((String)workflowScheme.getDescription())) {
            sb.append(workflowScheme.getDescription()).append(" ");
        }
        sb.append(this.i18nFactory.getInstance(user).getText("admin.workflowschemes.manager.draft.auto.generated", workflowScheme.getName()));
        return sb.toString();
    }

    private AssignableWorkflowScheme toWorkflowScheme(GenericValue genericValue) {
        if (genericValue == null) {
            return null;
        }
        String name = genericValue.getString("name");
        String description = genericValue.getString("description");
        Long id = genericValue.getLong("id");
        Map<String, String> map = this.getWorkflowMap(genericValue);
        return new WorkflowSchemeImpl(id, name, description, map);
    }

    private DraftWorkflowScheme toWorkflowScheme(DraftWorkflowSchemeStore.DraftState state) {
        if (state == null) {
            return null;
        }
        ApplicationUser userByKey = this.userManager.getUserByKey(state.getLastModifiedUser());
        return new DraftWorkflowSchemeImpl(state, userByKey, this.getWorkflowSchemeObj(state.getParentSchemeId()));
    }

    private static AssignableWorkflowScheme toWorkflowScheme(AssignableWorkflowSchemeStore.AssignableState state) {
        if (state == null) {
            return null;
        }
        return new WorkflowSchemeImpl(state);
    }

    class ActiveWorkflowCache {
        private final ReadWriteLock lock = new ReentrantReadWriteLock();
        @GuardedBy(value="lock")
        private Set<String> cache = null;

        ActiveWorkflowCache() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        Set<String> get() throws GenericEntityException, WorkflowException {
            this.lock.readLock().lock();
            try {
                this.load();
                Set<String> set = this.cache;
                return set;
            }
            finally {
                this.lock.readLock().unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void clear() {
            this.lock.writeLock().lock();
            try {
                this.cache = null;
            }
            finally {
                this.lock.writeLock().unlock();
            }
        }

        @GuardedBy(value="lock")
        private void load() throws GenericEntityException, WorkflowException {
            if (this.cache != null) {
                return;
            }
            HashSet<String> set = new HashSet<String>();
            List<GenericValue> schemes = DefaultWorkflowSchemeManager.this.getSchemes();
            for (GenericValue scheme : schemes) {
                if (DefaultWorkflowSchemeManager.this.getProjects(scheme).isEmpty()) continue;
                List<GenericValue> entities = DefaultWorkflowSchemeManager.this.getEntities(scheme);
                for (GenericValue schemeEntity : entities) {
                    set.add((String)schemeEntity.get(DefaultWorkflowSchemeManager.COLUMN_WORKFLOW));
                }
            }
            Collection projects = DefaultWorkflowSchemeManager.this.projectManager.getProjects();
            boolean checkComplete = false;
            for (GenericValue project : projects) {
                GenericValue workflowScheme = DefaultWorkflowSchemeManager.this.getWorkflowScheme(project);
                if (workflowScheme == null) {
                    set.add("jira");
                    checkComplete = true;
                } else {
                    List<GenericValue> issueTypes = DefaultWorkflowSchemeManager.this.getAllIssueTypes();
                    for (GenericValue issueType : issueTypes) {
                        String issueTypeId = issueType.getString("id");
                        JiraWorkflow workflow = DefaultWorkflowSchemeManager.this.getWorkflowFromScheme(workflowScheme, issueTypeId);
                        if (workflow.getName().equals("jira")) {
                            set.add("jira");
                            checkComplete = true;
                        }
                        if (!checkComplete) continue;
                        break;
                    }
                }
                if (!checkComplete) continue;
                break;
            }
            this.cache = Collections.unmodifiableSet(set);
        }
    }
}

