/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.filters.accesslog;

import com.atlassian.jira.instrumentation.Instrumentation;
import com.atlassian.jira.instrumentation.InstrumentationName;
import com.atlassian.jira.util.http.request.CapturingRequestWrapper;
import com.atlassian.jira.util.http.response.CapturingResponseWrapper;
import com.atlassian.jira.util.http.response.ObservantResponseWrapper;
import com.atlassian.jira.util.log.Log4jKit;
import com.atlassian.jira.web.filters.accesslog.AccessLogBuilder;
import com.atlassian.jira.web.filters.accesslog.AccessLogDumpUtil;
import com.atlassian.jira.web.filters.accesslog.AccessLogRequestInfo;
import com.atlassian.jira.web.session.currentusers.JiraUserSessionTracker;
import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;

public class AccessLogFilter
implements Filter {
    private static final Logger basicLog = Logger.getLogger(AccessLogFilter.class);
    private static final Logger dumpLog = Logger.getLogger((String)(basicLog.getName() + "Dump"));
    private static final Logger includeImagesLog = Logger.getLogger((String)(basicLog.getName() + "IncludeImages"));
    private static final String ALREADY_FILTERED = AccessLogFilter.class.getName() + "_already_filtered";
    private static final int MAX_CAPTURE_LEN = 20480;
    private static final String ANONYMOUS = "anonymous";

    public void init(FilterConfig filterConfig) throws ServletException {
        basicLog.info((Object)"AccessLogFilter initialized. Look in atlassian-jira-http-access.log for HTTP access log entries");
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        if (servletRequest.getAttribute(ALREADY_FILTERED) != null) {
            filterChain.doFilter(servletRequest, servletResponse);
            return;
        }
        servletRequest.setAttribute(ALREADY_FILTERED, (Object)Boolean.TRUE);
        HttpServletRequest httpServletRequest = (HttpServletRequest)servletRequest;
        HttpServletResponse httpServletResponse = (HttpServletResponse)servletResponse;
        this.executeRequest(httpServletRequest, httpServletResponse, filterChain);
    }

    private void executeRequest(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, FilterChain filterChain) throws IOException, ServletException {
        FilterCallState filterCallState = this.preFilterCallStep(new FilterCallState(httpServletRequest, httpServletResponse));
        try {
            filterChain.doFilter((ServletRequest)filterCallState.httpServletRequest, (ServletResponse)filterCallState.httpServletResponse);
        }
        catch (IOException ioe) {
            filterCallState.requestException = ioe;
            throw ioe;
        }
        catch (ServletException se) {
            filterCallState.requestException = (Exception)((Object)se);
            throw se;
        }
        catch (RuntimeException rte) {
            filterCallState.requestException = rte;
            throw rte;
        }
        finally {
            this.postFilterCallStep(filterCallState);
        }
    }

    private FilterCallState preFilterCallStep(FilterCallState filterCallState) {
        filterCallState.userName = filterCallState.httpServletRequest.getRemoteUser();
        filterCallState.requestUrl = filterCallState.httpServletRequest.getRequestURL().toString();
        filterCallState.userName = filterCallState.httpServletRequest.getRemoteUser();
        if (basicLog.isInfoEnabled() && this.isInterestingUrl(filterCallState.requestUrl)) {
            filterCallState.observantResponseWrapper = new ObservantResponseWrapper(filterCallState.httpServletResponse);
            filterCallState.httpServletResponse = (HttpServletResponse)filterCallState.observantResponseWrapper;
            filterCallState.interestedInUrl = true;
        }
        if (filterCallState.interestedInUrl) {
            String requestId = "i" + filterCallState.requestId;
            String msg = new AccessLogBuilder(filterCallState.httpServletRequest).setDateOfEvent((ReadableInstant)new DateTime(filterCallState.startTimeMS)).setRequestId(requestId).setUrl(filterCallState.requestUrl).setUserName(filterCallState.userName).setSessionId(filterCallState.atlassianSessionId).toApacheCombinedLogFormat();
            basicLog.info((Object)msg);
            if (dumpLog.isInfoEnabled()) {
                filterCallState.capturingRequestWrapper = new CapturingRequestWrapper(filterCallState.httpServletRequest, 20480);
                filterCallState.httpServletRequest = (HttpServletRequest)filterCallState.capturingRequestWrapper;
                filterCallState.capturingResponseWrapper = new CapturingResponseWrapper(filterCallState.httpServletResponse, 20480);
                filterCallState.httpServletResponse = (HttpServletResponse)filterCallState.capturingResponseWrapper;
                filterCallState.performFullHttpDump = true;
                dumpLog.info((Object)msg);
            }
        }
        this.recordUserInformation(filterCallState);
        return filterCallState;
    }

    private void recordUserInformation(FilterCallState filterCallState) {
        String userName = filterCallState.userName;
        Log4jKit.putUserToMDC(userName);
        if (!filterCallState.httpServletResponse.isCommitted()) {
            filterCallState.httpServletResponse.setHeader("X-AUSERNAME", userName == null ? ANONYMOUS : userName);
        }
    }

    private void postFilterCallStep(FilterCallState filterCallState) {
        if (filterCallState.requestException != null) {
            Instrumentation.pullCounter(InstrumentationName.FIVE_HUNDREDS).incrementAndGet();
        }
        long now = System.currentTimeMillis();
        long responseTimeMS = now - filterCallState.startTimeMS;
        filterCallState.userName = this.adjustUserName(filterCallState.httpServletRequest, filterCallState.userName);
        filterCallState.httpServletRequest.setAttribute("jira.request.username", (Object)filterCallState.userName);
        if (filterCallState.interestedInUrl) {
            String sessionId;
            int statusCode = filterCallState.observantResponseWrapper.getStatus();
            long responseContentLen = filterCallState.observantResponseWrapper.getContentLen();
            filterCallState.requestUrl = this.ajustUrl(filterCallState.httpServletRequest, filterCallState.requestUrl);
            if (filterCallState.requestException != null && !filterCallState.httpServletResponse.isCommitted()) {
                statusCode = 500;
            }
            if ((sessionId = filterCallState.atlassianSessionId) == null) {
                sessionId = (String)filterCallState.httpServletRequest.getAttribute("jira.rpc.soap.soap.sessionid");
            }
            String msg = new AccessLogBuilder(filterCallState.httpServletRequest).setDateOfEvent((ReadableInstant)new DateTime()).setRequestId("o" + filterCallState.requestId).setUrl(filterCallState.requestUrl).setUserName(filterCallState.userName).setSessionId(sessionId).setResponseTimeMS(responseTimeMS).setHttpStatusCode(statusCode).setResponseContentLength(responseContentLen).toApacheCombinedLogFormat();
            basicLog.info((Object)msg);
            if (filterCallState.performFullHttpDump) {
                String dumpMsg = AccessLogDumpUtil.dumpRequestResponse(filterCallState.capturingRequestWrapper, filterCallState.capturingResponseWrapper, msg, responseContentLen, filterCallState.requestException);
                dumpLog.info((Object)dumpMsg);
            }
        }
        filterCallState.httpServletRequest.setAttribute("jira.request.time.micros", (Object)String.valueOf(responseTimeMS / 1000L));
        JiraUserSessionTracker.recordInteraction(filterCallState.httpServletRequest);
    }

    private String ajustUrl(HttpServletRequest httpServletRequest, String url) {
        Object soapUrlSuffix = httpServletRequest.getAttribute("jira.rpc.soap.urlsuffix");
        if (soapUrlSuffix != null) {
            StringBuilder newUrl = new StringBuilder(url).append("/").append(soapUrlSuffix);
            return newUrl.toString();
        }
        return url;
    }

    private String adjustUserName(HttpServletRequest httpServletRequest, String userName) {
        Object soapUserName = httpServletRequest.getAttribute("jira.rpc.soap.username");
        if (userName == null && soapUserName != null) {
            return String.valueOf(soapUserName);
        }
        return userName;
    }

    private boolean isInterestingUrl(String requestURL) {
        if (requestURL != null && (requestURL.endsWith(".gif") || requestURL.endsWith(".png") || requestURL.endsWith(".jpg") || requestURL.endsWith(".ico"))) {
            return includeImagesLog.isInfoEnabled();
        }
        return true;
    }

    public void destroy() {
    }

    private class FilterCallState {
        private HttpServletResponse httpServletResponse;
        private HttpServletRequest httpServletRequest;
        private CapturingRequestWrapper capturingRequestWrapper = null;
        private ObservantResponseWrapper observantResponseWrapper = null;
        private CapturingResponseWrapper capturingResponseWrapper = null;
        private final String requestId;
        private final String atlassianSessionId;
        private String requestUrl = null;
        private String userName = null;
        private boolean interestedInUrl = false;
        private boolean performFullHttpDump = false;
        private final long startTimeMS;
        private Exception requestException = null;

        private FilterCallState(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
            new AccessLogRequestInfo().enterRequest(httpServletRequest, httpServletResponse);
            this.httpServletResponse = httpServletResponse;
            this.httpServletRequest = httpServletRequest;
            this.requestId = (String)httpServletRequest.getAttribute("jira.request.id");
            this.atlassianSessionId = (String)httpServletRequest.getAttribute("jira.request.assession.id");
            this.startTimeMS = (Long)httpServletRequest.getAttribute("jira.request.start.millis");
        }

        public String toString() {
            return this.requestUrl;
        }
    }
}

