/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.component;

import com.atlassian.jira.util.VelocityParamFactory;
import com.atlassian.jira.web.util.HelpUtil;
import com.atlassian.jira.workflow.JiraWorkflow;
import com.atlassian.jira.workflow.ProjectWorkflowSchemeHelper;
import com.atlassian.plugin.web.WebInterfaceManager;
import com.atlassian.plugin.web.model.WebPanel;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;

public class WorkflowHeaderWebComponent {
    private final WebInterfaceManager webInterfaceManager;
    private final ProjectWorkflowSchemeHelper helper;
    private final VelocityParamFactory velocityParamFactory;

    public WorkflowHeaderWebComponent(WebInterfaceManager webInterfaceManager, ProjectWorkflowSchemeHelper helper, VelocityParamFactory velocityParamFactory) {
        this.webInterfaceManager = webInterfaceManager;
        this.helper = helper;
        this.velocityParamFactory = velocityParamFactory;
    }

    public String getHtml(JiraWorkflow jiraWorkflow, String helpPath, Long projectId) {
        WebPanel first = (WebPanel)Iterables.getFirst((Iterable)this.webInterfaceManager.getWebPanels("workflow.header"), null);
        if (first != null) {
            HashMap context = Maps.newHashMap();
            context.put("jiraWorkflow", jiraWorkflow);
            context.put("active", true);
            context.put("helpUtil", HelpUtil.getInstance());
            context.put("sharedProjects", this.helper.getProjectsForWorkflow(jiraWorkflow.getName()));
            context.put("projectId", projectId);
            context.put("helpPath", HelpUtil.getInstance().getHelpPath(helpPath));
            return first.getHtml(this.velocityParamFactory.getDefaultVelocityParams((Map)context));
        }
        return "";
    }

    public String getHtml(JiraWorkflow jiraWorkflow, String helpPath) {
        return this.getHtml(jiraWorkflow, helpPath, null);
    }
}

