/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.user;

import com.atlassian.crowd.embedded.api.CrowdService;
import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.ComponentManager;
import com.atlassian.jira.avatar.AvatarService;
import com.atlassian.jira.plugin.profile.OptionalUserProfilePanel;
import com.atlassian.jira.plugin.profile.ViewProfilePanel;
import com.atlassian.jira.plugin.profile.ViewProfilePanelModuleDescriptor;
import com.atlassian.jira.plugin.util.ModuleDescriptorComparator;
import com.atlassian.jira.plugin.webfragment.SimpleLinkManager;
import com.atlassian.jira.plugin.webfragment.model.JiraHelper;
import com.atlassian.jira.plugin.webfragment.model.SimpleLink;
import com.atlassian.jira.plugin.webfragment.model.SimpleLinkSection;
import com.atlassian.jira.plugin.webfragment.model.SimpleLinkSectionImpl;
import com.atlassian.jira.plugin.webresource.SuperBatchFilteringWriter;
import com.atlassian.jira.user.UserHistoryItem;
import com.atlassian.jira.user.UserHistoryManager;
import com.atlassian.jira.user.UserPropertyManager;
import com.atlassian.jira.util.collect.MapBuilder;
import com.atlassian.jira.web.action.IssueActionSupport;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.webresource.UrlMode;
import com.atlassian.plugin.webresource.WebResourceManager;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import webwork.action.ActionContext;
import webwork.action.ServletActionContext;

public class ViewProfile
extends IssueActionSupport {
    private static final String CONTENTONLY = "contentonly";
    private String name;
    private User profileUser;
    private String selectedTab;
    private static final String USER_NOT_FOUND_VIEW = "usernotfound";
    private final SimpleLinkManager simpleLinkManager;
    private final WebResourceManager webResourceManager;
    private final PluginAccessor pluginAccessor;
    private final UserPropertyManager userPropertyManager;
    protected final CrowdService crowdService;
    private final AvatarService avatarService;
    private final UserHistoryManager userHistoryManager;
    private boolean contentOnly = false;
    private boolean noTitle = false;
    private List<ViewProfilePanelModuleDescriptor> moduleDescriptors;
    private ViewProfilePanelModuleDescriptor selectedDescriptor = null;

    public ViewProfile(UserPropertyManager userPropertyManager) {
        this(ComponentManager.getComponentInstanceOfType(SimpleLinkManager.class), ComponentManager.getComponentInstanceOfType(WebResourceManager.class), ComponentManager.getComponentInstanceOfType(PluginAccessor.class), ComponentManager.getComponentInstanceOfType(CrowdService.class), userPropertyManager, ComponentManager.getComponentInstanceOfType(AvatarService.class), ComponentManager.getComponentInstanceOfType(UserHistoryManager.class));
    }

    public ViewProfile(SimpleLinkManager SimpleLinkManager2, WebResourceManager webResourceManager, PluginAccessor pluginAccessor, CrowdService crowdService, UserPropertyManager userPropertyManager, AvatarService avatarService, UserHistoryManager userHistoryManager) {
        this.simpleLinkManager = SimpleLinkManager2;
        this.webResourceManager = webResourceManager;
        this.pluginAccessor = pluginAccessor;
        this.crowdService = crowdService;
        this.userPropertyManager = userPropertyManager;
        this.avatarService = avatarService;
        this.userHistoryManager = userHistoryManager;
        webResourceManager.requireResourcesForContext("atl.userprofile");
        webResourceManager.requireResourcesForContext("jira.userprofile");
    }

    protected String doExecute() throws Exception {
        if (this.getLoggedInUser() == null) {
            if (this.contentOnly) {
                ServletActionContext.getResponse().setStatus(401);
                return "none";
            }
            return "securitybreach";
        }
        if (this.getUser() == null) {
            if (this.contentOnly) {
                ServletActionContext.getResponse().setStatus(401);
                return "none";
            }
            return USER_NOT_FOUND_VIEW;
        }
        if (this.getUser() != null) {
            this.userHistoryManager.addUserToHistory(UserHistoryItem.ASSIGNEE, this.getLoggedInUser(), this.getUser());
        }
        if (this.contentOnly) {
            String specifiedTab = this.selectedTab;
            if (StringUtils.isBlank((String)specifiedTab)) {
                specifiedTab = (String)this.getSession().get("jira.view.profile.tab");
            }
            if (this.canSeeTab(specifiedTab)) {
                return CONTENTONLY;
            }
            ServletActionContext.getResponse().setStatus(401);
            return "none";
        }
        this.webResourceManager.requireResource("jira.webresources:userprofile");
        return super.doExecute();
    }

    public final String getName() {
        return this.name;
    }

    public final void setName(String name) {
        this.name = name;
    }

    public boolean isContentOnly() {
        return this.contentOnly;
    }

    public void setContentOnly(boolean contentOnly) {
        this.contentOnly = contentOnly;
    }

    public boolean isNoTitle() {
        String NO_TITLE = "noTitle";
        boolean descriptorNoTitle = this.getSelectedProfilePanelDescriptor().getParams().containsKey("noTitle") && "true".equalsIgnoreCase((String)this.getSelectedProfilePanelDescriptor().getParams().get("noTitle"));
        return this.noTitle || descriptorNoTitle;
    }

    public void setNoTitle(boolean noTitle) {
        this.noTitle = noTitle;
    }

    public String getAvatarUrl(User user) {
        if (user != null) {
            return this.avatarService.getAvatarURL(this.getLoggedInUser(), user.getName()).toString();
        }
        return null;
    }

    public User getUser() {
        if (this.profileUser == null) {
            this.profileUser = this.name == null ? this.getLoggedInUser() : this.crowdService.getUser(this.name);
        }
        return this.profileUser;
    }

    public ViewProfilePanelModuleDescriptor getSelectedProfilePanelDescriptor() {
        if (this.selectedDescriptor == null) {
            String selected = this.getSelectedTab();
            for (ViewProfilePanelModuleDescriptor descriptor : this.getTabDescriptors()) {
                if (!descriptor.getCompleteKey().equals(selected)) continue;
                this.selectedDescriptor = descriptor;
                return this.selectedDescriptor;
            }
        }
        return this.selectedDescriptor;
    }

    public String getLabelForSelectedTab() {
        ViewProfilePanelModuleDescriptor moduleDescriptor = this.getSelectedProfilePanelDescriptor();
        return moduleDescriptor.getName();
    }

    public String getHtmlForSelectedTab() {
        ViewProfilePanelModuleDescriptor moduleDescriptor = this.getSelectedProfilePanelDescriptor();
        String tabHtml = ((ViewProfilePanel)moduleDescriptor.getModule()).getHtml(this.profileUser);
        StringBuilder strBuilder = new StringBuilder();
        if (this.contentOnly) {
            if (!this.isNoTitle()) {
                strBuilder.append("<h2 id=\"up-tab-title\">");
                strBuilder.append(this.getLabelForSelectedTab());
                strBuilder.append("</h2>\n");
            }
            strBuilder.append(tabHtml);
            SuperBatchFilteringWriter writer = new SuperBatchFilteringWriter();
            this.webResourceManager.includeResources((Writer)writer, UrlMode.AUTO);
            strBuilder.append(writer.toString());
        } else {
            strBuilder.append(tabHtml);
        }
        return strBuilder.toString();
    }

    public boolean isHasMoreThanOneProfileTabs() {
        return this.getTabDescriptors().size() > 1;
    }

    public String getSelectedTab() {
        block0: {
            block1: {
                if (this.selectedTab != null) break block0;
                String sessionSelectedTab = (String)this.getSession().get("jira.view.profile.tab");
                if (sessionSelectedTab == null || !this.canSeeTab(sessionSelectedTab)) break block1;
                this.selectedTab = sessionSelectedTab;
                break block0;
            }
            Iterator<ViewProfilePanelModuleDescriptor> i$ = this.getTabDescriptors().iterator();
            if (!i$.hasNext()) break block0;
            ViewProfilePanelModuleDescriptor descriptor = i$.next();
            this.selectedTab = descriptor.getCompleteKey();
        }
        return this.selectedTab;
    }

    public void setSelectedTab(String selectedTab) {
        this.getSession().put("jira.view.profile.tab", selectedTab);
    }

    private boolean canSeeTab(String key) {
        for (ViewProfilePanelModuleDescriptor descriptor : this.getTabDescriptors()) {
            if (!descriptor.getCompleteKey().equals(key)) continue;
            return true;
        }
        return false;
    }

    public List<ViewProfilePanelModuleDescriptor> getTabDescriptors() {
        if (this.moduleDescriptors == null) {
            List allDescriptors = this.pluginAccessor.getEnabledModuleDescriptorsByClass(ViewProfilePanelModuleDescriptor.class);
            this.moduleDescriptors = new ArrayList<ViewProfilePanelModuleDescriptor>();
            for (ViewProfilePanelModuleDescriptor descriptor : allDescriptors) {
                ViewProfilePanel profilePanel = (ViewProfilePanel)descriptor.getModule();
                if (profilePanel instanceof OptionalUserProfilePanel) {
                    OptionalUserProfilePanel optionalPanel = (OptionalUserProfilePanel)profilePanel;
                    if (!optionalPanel.showPanel(this.getUser(), this.getLoggedInUser())) continue;
                    this.moduleDescriptors.add(descriptor);
                    continue;
                }
                this.moduleDescriptors.add(descriptor);
            }
            Collections.sort(this.moduleDescriptors, ModuleDescriptorComparator.COMPARATOR);
        }
        return this.moduleDescriptors;
    }

    public List<SimpleLinkSection> getSectionsForMenu() {
        ArrayList<SimpleLinkSection> sections = new ArrayList<SimpleLinkSection>();
        sections.add((SimpleLinkSection)new SimpleLinkSectionImpl("operations", this.getText("common.concepts.tools"), null, null, "icon-tools", null));
        return sections;
    }

    public List<SimpleLink> getSectionLinks(String key) {
        User remoteUser = this.getLoggedInUser();
        HttpServletRequest servletRequest = ServletActionContext.getRequest();
        servletRequest.setAttribute("profileUser", (Object)this.getUser());
        Map params = MapBuilder.build((Object)"profileUser", (Object)this.getUser());
        JiraHelper helper = new JiraHelper(servletRequest, null, params);
        return this.simpleLinkManager.getLinksForSection("system.user.profile.links/" + key, remoteUser, helper);
    }

    private Map getSession() {
        return ActionContext.getSession();
    }
}

