/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.issue;

import com.atlassian.core.util.map.EasyMap;
import com.atlassian.crowd.embedded.api.User;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.ManagerFactory;
import com.atlassian.jira.avatar.Avatar;
import com.atlassian.jira.avatar.AvatarService;
import com.atlassian.jira.bc.issue.comment.CommentService;
import com.atlassian.jira.bc.user.search.UserPickerSearchService;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.FeatureManager;
import com.atlassian.jira.config.SubTaskManager;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.event.issue.IssueViewEvent;
import com.atlassian.jira.exception.IssueNotFoundException;
import com.atlassian.jira.exception.IssuePermissionException;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.MutableIssue;
import com.atlassian.jira.issue.RendererManager;
import com.atlassian.jira.issue.comments.CommentManager;
import com.atlassian.jira.issue.customfields.OperationContext;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.fields.FieldManager;
import com.atlassian.jira.issue.fields.layout.field.FieldLayoutItem;
import com.atlassian.jira.issue.fields.layout.field.FieldLayoutManager;
import com.atlassian.jira.issue.fields.screen.FieldScreenRendererFactory;
import com.atlassian.jira.issue.pager.NextPreviousPager;
import com.atlassian.jira.issue.pager.PagerManager;
import com.atlassian.jira.issue.util.IssueOperationsBarUtil;
import com.atlassian.jira.issue.util.IssueWebPanelRenderUtil;
import com.atlassian.jira.plugin.issueview.IssueViewModuleDescriptor;
import com.atlassian.jira.plugin.util.ModuleDescriptorComparator;
import com.atlassian.jira.plugin.webfragment.SimpleLinkManager;
import com.atlassian.jira.plugin.webfragment.model.JiraHelper;
import com.atlassian.jira.plugin.webfragment.model.SimpleLink;
import com.atlassian.jira.plugin.webresource.JiraWebResourceManager;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.security.roles.ProjectRoleManager;
import com.atlassian.jira.user.util.UserUtil;
import com.atlassian.jira.util.JiraVelocityHelper;
import com.atlassian.jira.web.action.AjaxHeaders;
import com.atlassian.jira.web.action.issue.AddComment;
import com.atlassian.jira.web.action.issue.IssueNavigator;
import com.atlassian.jira.web.action.issue.util.ConditionalDescriptorPredicate;
import com.atlassian.jira.web.component.ModuleWebComponent;
import com.atlassian.jira.web.component.issuesummary.IssueSummaryLayoutBean;
import com.atlassian.jira.workflow.JiraWorkflow;
import com.atlassian.jira.workflow.WorkflowException;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.web.WebInterfaceManager;
import com.atlassian.plugin.web.descriptors.WebPanelModuleDescriptor;
import com.atlassian.plugin.web.model.WebPanel;
import com.atlassian.plugin.webresource.WebResourceManager;
import com.atlassian.query.order.SearchSort;
import com.atlassian.util.profiling.UtilTimerStack;
import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Ordering;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.ofbiz.core.entity.GenericEntityException;
import org.ofbiz.core.entity.GenericValue;
import webwork.action.Action;
import webwork.action.ActionContext;
import webwork.action.ServletActionContext;

public class ViewIssue
extends AddComment
implements OperationContext {
    private static final String DEFAULT_ISSUE_ATTACHMENTS_ORDER = "asc";
    private static final String DEFAULT_ISSUE_ATTACHMENTS_SORTBY = "fileName";
    private final PagerManager pagerManager;
    private final PluginAccessor pluginAccessor;
    private final CommentManager commentManager;
    private final FieldLayoutManager fieldLayoutManager;
    private final RendererManager rendererManager;
    private final WebResourceManager webResourceManager;
    private final SimpleLinkManager simpleLinkManager;
    private final WebInterfaceManager webInterfaceManager;
    private String issuetype;
    String attachmentOrder = null;
    String attachmentSortBy = null;
    private SearchSort sorter;
    private Long currentSubTaskSequence;
    private Long subTaskSequence;
    private Boolean isEditable;
    private IssueOperationsBarUtil issueOperationsBarUtil;
    private Map<String, Object> webPanelParams;
    private final ModuleWebComponent moduleWebComponent;
    private final FeatureManager featureManager;
    private final AvatarService avatarService;
    private final EventPublisher eventPublisher;
    private final ApplicationProperties applicationProperties;
    private final UserPickerSearchService userPickerSearchService;
    private IssueWebPanelRenderUtil issueWebPanelRenderUtil;

    public ViewIssue(SubTaskManager subTaskManager, PluginAccessor pluginAccessor, FieldManager fieldManager, FieldScreenRendererFactory fieldScreenRendererFactory, FieldLayoutManager fieldLayoutManager, RendererManager rendererManager, CommentManager commentManager, ProjectRoleManager projectRoleManager, CommentService commentService, PagerManager pagerManager, WebResourceManager webResourceManager, SimpleLinkManager simpleLinkManager, WebInterfaceManager webInterfaceManager, PermissionManager permissionManager, ModuleWebComponent moduleWebComponent, UserUtil userUtil, FeatureManager featureManager, AvatarService avatarService, EventPublisher eventPublisher, ApplicationProperties applicationProperties, UserPickerSearchService userPickerSearchService) {
        super(subTaskManager, fieldManager, fieldScreenRendererFactory, projectRoleManager, commentService, permissionManager, userUtil);
        this.pluginAccessor = pluginAccessor;
        this.commentManager = commentManager;
        this.pagerManager = pagerManager;
        this.fieldLayoutManager = fieldLayoutManager;
        this.rendererManager = rendererManager;
        this.webResourceManager = webResourceManager;
        this.simpleLinkManager = simpleLinkManager;
        this.webInterfaceManager = webInterfaceManager;
        this.moduleWebComponent = moduleWebComponent;
        this.featureManager = featureManager;
        this.avatarService = avatarService;
        this.eventPublisher = eventPublisher;
        this.applicationProperties = applicationProperties;
        this.userPickerSearchService = userPickerSearchService;
    }

    @Override
    protected void doValidation() {
    }

    @Override
    protected String doExecute() throws Exception {
        try {
            GenericValue issue = this.getIssue();
            if (issue != null) {
                if (this.getProject() != null) {
                    this.setSelectedProjectId(this.getProject().getLong("id"));
                }
                String issueKey = issue.getString("key");
                ((JiraWebResourceManager)this.webResourceManager).putMetadata("can-edit-watchers", Boolean.toString(this.isCanEditWatcherList()));
                ((JiraWebResourceManager)this.webResourceManager).putMetadata("can-search-users", Boolean.toString(this.userPickerSearchService.canPerformAjaxSearch(this.getLoggedInUser())));
                ((JiraWebResourceManager)this.webResourceManager).putMetadata("issue-key", issueKey);
                String defaultAvatarUrl = this.avatarService.getAvatarURL(this.getLoggedInUser(), null, Avatar.Size.SMALL).toString();
                ((JiraWebResourceManager)this.webResourceManager).putMetadata("default-avatar-url", defaultAvatarUrl);
                UtilTimerStack.push((String)("Updating Pager for viewing issue:" + issueKey));
                this.pagerManager.updatePager(this.getNextPreviousPager(), this.getSearchRequest(), this.getLoggedInUser(), issueKey);
                ((JiraWebResourceManager)this.webResourceManager).putMetadata("search-pos", "" + this.getNextPreviousPager().getCurrentPosition());
                UtilTimerStack.pop((String)("Updating Pager for viewing issue:" + issueKey));
            }
            if (AjaxHeaders.isPjaxRequest((HttpServletRequest)this.request)) {
                if (AjaxHeaders.requestUsernameMatches((HttpServletRequest)this.request, (User)this.getLoggedInUser())) {
                    return "issueTabOnly";
                }
                return this.forceRedirect(this.request.getRequestURI());
            }
            if (!this.useKickAss()) {
                this.webResourceManager.requireResource("jira.webresources:viewissue-no-inline-edit");
            }
            this.webResourceManager.requireResource("jira.webresources:jira-fields");
            if (this.useKickAss()) {
                this.webResourceManager.requireResource("com.atlassian.jira.jira-issue-nav-plugin:standalone-issue");
            }
            this.eventPublisher.publish((Object)new IssueViewEvent(this.getIssueObject().getId().longValue()));
            return "success";
        }
        catch (IssueNotFoundException ex) {
            this.addErrorMessage(this.getText("admin.errors.issues.issue.does.not.exist"));
            return "issuenotfound";
        }
        catch (IssuePermissionException ex) {
            this.addErrorMessage(this.getText("admin.errors.issues.no.browse.permission"));
            return "permissionviolation";
        }
    }

    public boolean useKickAss() {
        return this.pluginAccessor.isPluginEnabled("com.atlassian.jira.jira-issue-nav-plugin") && !this.applicationProperties.getOption("jira.issue.inline.edit.disabled");
    }

    public NextPreviousPager getNextPreviousPager() {
        return this.pagerManager.getPager();
    }

    public CommentManager getCommentManager() {
        return this.commentManager;
    }

    private boolean isCanEditWatcherList() throws GenericEntityException {
        return this.permissionManager.hasPermission(32, (Issue)this.getIssueObject(), this.getLoggedInUser());
    }

    public boolean isWorkable() {
        return this.isHasIssuePermission(20, this.getIssue());
    }

    public boolean isWorkflowAllowsEdit() {
        return this.isWorkflowAllowsEdit((Issue)this.getIssueObject());
    }

    public Boolean isViewIssue() {
        return Boolean.TRUE;
    }

    public IssueWebPanelRenderUtil getRenderUtil() {
        if (this.issueWebPanelRenderUtil == null) {
            this.issueWebPanelRenderUtil = new IssueWebPanelRenderUtil(this.getLoggedInUser(), (Issue)this.getIssueObject(), (Action)this, this.webInterfaceManager, this.moduleWebComponent);
        }
        return this.issueWebPanelRenderUtil;
    }

    public String renderActivityModule() {
        List webPanels = ((PluginAccessor)ComponentAccessor.getComponentOfType(PluginAccessor.class)).getEnabledModuleDescriptorsByClass(WebPanelModuleDescriptor.class);
        for (WebPanelModuleDescriptor webPanel : webPanels) {
            if (!"com.atlassian.jira.jira-view-issue-plugin:activitymodule".equals(webPanel.getCompleteKey())) continue;
            return ((WebPanel)webPanel.getModule()).getHtml(this.getRenderUtil().getWebPanelContext());
        }
        return "";
    }

    public SearchSort getSorter() {
        if (this.sorter == null) {
            this.sorter = new SearchSort("DESC", "issuekey");
        }
        return this.sorter;
    }

    public String doMoveIssueLink() throws Exception {
        Long id = this.getId();
        if (!this.isAllowedReorderSubTasks()) {
            this.addErrorMessage(this.getText("admin.errors.cannot.reorder.subtasks"));
        }
        if (id == null) {
            this.log.error((Object)"Cannot move sub-task when no parent issue exists.");
            this.addErrorMessage(this.getText("admin.errors.viewissue.no.parent.exists"));
            return "error";
        }
        if (this.getCurrentSubTaskSequence() == null) {
            this.log.error((Object)"Cannot move sub-task when current sequence is unset.");
            this.addErrorMessage(this.getText("admin.errors.viewissue.no.sequence.unset"));
            return "error";
        }
        if (this.getSubTaskSequence() == null) {
            this.log.error((Object)"Cannot move sub-task when sequence is unset.");
            this.addErrorMessage(this.getText("admin.errors.viewissue.no.sequence.unset"));
            return "error";
        }
        this.getSubTaskManager().moveSubTask(this.getIssue(), this.getCurrentSubTaskSequence(), this.getSubTaskSequence());
        return this.getRedirect("/browse/" + this.getIssue().getString("key"));
    }

    public boolean isAllowedReorderSubTasks() {
        return this.isHasIssuePermission(12, this.getIssue());
    }

    public void setSubTaskView(String subTaskView) {
        if (!StringUtils.isBlank((String)subTaskView)) {
            ActionContext.getSession().put("jira.user.subtaskview", subTaskView);
        }
    }

    public Long getCurrentSubTaskSequence() {
        return this.currentSubTaskSequence;
    }

    public void setCurrentSubTaskSequence(Long currentSubTaskSequence) {
        this.currentSubTaskSequence = currentSubTaskSequence;
    }

    public Long getSubTaskSequence() {
        return this.subTaskSequence;
    }

    public void setSubTaskSequence(Long subTaskSequence) {
        this.subTaskSequence = subTaskSequence;
    }

    public GenericValue getAssignIn() {
        return this.getProject();
    }

    public JiraWorkflow getJiraWorkflow() throws WorkflowException {
        return ManagerFactory.getWorkflowManager().getWorkflow(this.getIssue());
    }

    public void setIssuetype(String issuetypeId) {
        this.issuetype = issuetypeId;
    }

    public String getIssuetype() {
        return this.issuetype;
    }

    @Override
    public boolean isSubTask() {
        return this.getSubTaskManager().isSubTask(this.getIssue());
    }

    public String getAttachmentSortBy() {
        if (this.attachmentSortBy == null) {
            this.attachmentSortBy = (String)ActionContext.getSession().get("jira.issue.attachment.sortby");
        }
        if (this.attachmentSortBy == null) {
            this.attachmentSortBy = DEFAULT_ISSUE_ATTACHMENTS_SORTBY;
        }
        return this.attachmentSortBy;
    }

    public void setAttachmentSortBy(String attachmentSortBy) {
        if (!StringUtils.isBlank((String)attachmentSortBy) && !attachmentSortBy.equals(DEFAULT_ISSUE_ATTACHMENTS_SORTBY)) {
            this.attachmentSortBy = attachmentSortBy;
            ActionContext.getSession().put("jira.issue.attachment.sortby", this.attachmentSortBy);
        } else {
            ActionContext.getSession().put("jira.issue.attachment.sortby", null);
        }
    }

    public String getAttachmentOrder() {
        if (this.attachmentOrder == null) {
            this.attachmentOrder = (String)ActionContext.getSession().get("jira.issue.attachment.order");
        }
        if (this.attachmentOrder == null) {
            this.attachmentOrder = DEFAULT_ISSUE_ATTACHMENTS_ORDER;
        }
        return this.attachmentOrder;
    }

    public void setAttachmentOrder(String attachmentOrder) {
        if (!StringUtils.isBlank((String)attachmentOrder) && !attachmentOrder.equals(DEFAULT_ISSUE_ATTACHMENTS_ORDER)) {
            this.attachmentOrder = attachmentOrder;
            ActionContext.getSession().put("jira.issue.attachment.order", this.attachmentOrder);
        } else {
            ActionContext.getSession().put("jira.issue.attachment.order", null);
        }
    }

    public String getCustomFieldHtml(FieldLayoutItem fieldLayoutItem, CustomField field, Issue issue) {
        return field.getViewHtml(fieldLayoutItem, (Action)this, issue, EasyMap.build((Object)"view_issue", (Object)Boolean.TRUE));
    }

    public String getRenderedContent(String fieldName, String value, Issue issue) {
        FieldLayoutItem fieldLayoutItem = this.fieldLayoutManager.getFieldLayout(issue.getProjectObject(), issue.getIssueTypeObject().getId()).getFieldLayoutItem(fieldName);
        if (fieldLayoutItem != null) {
            return this.rendererManager.getRenderedContent(fieldLayoutItem.getRendererType(), value, issue.getIssueRenderContext());
        }
        return value;
    }

    public String getRenderedContentNoBreaks(String fieldName, String value, Issue issue) {
        return new JiraVelocityHelper(null).removeHtmlBreaks(this.getRenderedContent(fieldName, value, issue));
    }

    @Override
    public IssueSummaryLayoutBean getLayoutBean() {
        return new IssueSummaryLayoutBean(true);
    }

    public boolean enableStalkerBar() {
        boolean disabled = this.getApplicationProperties().getOption("jira.disable.operations.bar");
        return !disabled;
    }

    public boolean showOpsBar() {
        return true;
    }

    public SimpleLink getEditOrLoginLink() {
        return this.getOpsBarUtil().getEditOrLoginLink((Issue)this.getIssueObject());
    }

    public IssueOperationsBarUtil getOpsBarUtil() {
        if (this.issueOperationsBarUtil == null) {
            JiraHelper helper = this.getJiraHelper();
            this.issueOperationsBarUtil = new IssueOperationsBarUtil(helper, this.getLoggedInUser(), this.simpleLinkManager, this.getApplicationProperties(), this.getIssueManager(), this.getI18nHelper());
        }
        return this.issueOperationsBarUtil;
    }

    private JiraHelper getJiraHelper() {
        MutableIssue issue = this.getIssueObject();
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("issue", issue);
        params.put("issueId", issue.getId());
        return new JiraHelper(ServletActionContext.getRequest(), issue.getProjectObject(), params);
    }

    public List<IssueViewModuleDescriptor> getIssueViews() {
        return Ordering.from((Comparator)ModuleDescriptorComparator.COMPARATOR).compound((Comparator)Ordering.natural().onResultOf((Function)new Function<IssueViewModuleDescriptor, Comparable>(){

            public Comparable apply(@Nullable IssueViewModuleDescriptor input) {
                return input == null ? null : input.getName();
            }
        })).sortedCopy(Iterables.filter((Iterable)this.pluginAccessor.getEnabledModuleDescriptorsByClass(IssueViewModuleDescriptor.class), (Predicate)new ConditionalDescriptorPredicate(IssueNavigator.makeContext(this.getLoggedInUser(), this.getJiraHelper()))));
    }

    public List<SimpleLink> getToolLinks() {
        List linksForSection = this.simpleLinkManager.getLinksForSection("jira.issue.tools", this.getLoggedInUser(), this.getJiraHelper());
        return linksForSection.size() > 0 ? linksForSection : null;
    }

    public String getUrlForIssueView(IssueViewModuleDescriptor descriptor) {
        return descriptor.getURLWithoutContextPath(this.getIssueObject().getKey());
    }
}

