/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.greenhopper;

import com.atlassian.jira.ComponentManager;
import com.atlassian.jira.bc.license.JiraLicenseService;
import com.atlassian.jira.util.http.JiraUrl;
import com.atlassian.jira.web.action.JiraWebActionSupport;
import com.atlassian.jira.web.util.ExternalLinkUtil;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.PluginController;
import com.atlassian.sal.api.websudo.WebSudoRequired;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import javax.servlet.http.HttpServletRequest;

@WebSudoRequired
public class SetupGreenHopper
extends JiraWebActionSupport {
    private static final String COM_PYXIS_GREENHOPPER_JIRA = "com.pyxis.greenhopper.jira";
    private static final String GREENHOPPER_LICENSE_MANAGER = "greenhopper-license-manager";
    private final ExternalLinkUtil externalLinkUtil;
    private final PluginAccessor pluginAccessor;
    private final PluginController pluginController;
    private final JiraLicenseService licenseService;
    private String license;

    public SetupGreenHopper(ExternalLinkUtil externalLinkUtil, PluginAccessor pluginAccessor, JiraLicenseService licenseService, PluginController pluginController) {
        this.externalLinkUtil = externalLinkUtil;
        this.pluginAccessor = pluginAccessor;
        this.licenseService = licenseService;
        this.pluginController = pluginController;
    }

    public String doFetchLicense() throws Exception {
        return "input";
    }

    public String doReturnFromMAC() throws Exception {
        return "input";
    }

    public String doDefault() throws Exception {
        this.doValidation();
        return super.doDefault();
    }

    protected void doValidation() {
        boolean isGreenHopperInstalled;
        super.doValidation();
        boolean bl = isGreenHopperInstalled = this.pluginAccessor.getPlugin(COM_PYXIS_GREENHOPPER_JIRA) != null;
        if (!isGreenHopperInstalled) {
            this.addErrorMessage(this.getText("setup.greenhopper.no.plugin"));
        }
    }

    private JiraLicenseService getLicenseService() {
        return ComponentManager.getComponent(JiraLicenseService.class);
    }

    protected String doExecute() throws Exception {
        StringBuilder url = new StringBuilder();
        url.append(JiraUrl.constructBaseUrl((HttpServletRequest)this.request));
        url.append("/plugins/servlet/upm#manage/com.pyxis.greenhopper.jira");
        return this.getRedirect(url.toString());
    }

    public String getLicense() {
        return this.license;
    }

    public void setLicense(String license) {
        this.license = license;
    }

    public String getRequestEvaluatorLicenseURL() throws UnsupportedEncodingException {
        return this.externalLinkUtil.getProperty("external.link.greenhopper.license.evaluator", Arrays.asList(COM_PYXIS_GREENHOPPER_JIRA));
    }

    public String getOrganisation() {
        return this.licenseService.getLicense().getOrganisation();
    }

    public String getCallbackUrl() throws UnsupportedEncodingException {
        StringBuilder url = new StringBuilder();
        url.append(JiraUrl.constructBaseUrl((HttpServletRequest)this.request));
        url.append("/plugins/servlet/upm/license/com.pyxis.greenhopper.jira");
        return url.toString();
    }

    public boolean isPluginInstalled() {
        return this.pluginAccessor.getPlugin(COM_PYXIS_GREENHOPPER_JIRA) != null;
    }
}

