/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.admin.workflow.scheme;

import com.atlassian.jira.ManagerFactory;
import com.atlassian.jira.exception.DataAccessException;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectFactory;
import com.atlassian.jira.scheme.AbstractSelectProjectScheme;
import com.atlassian.jira.scheme.SchemeManager;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.task.TaskDescriptor;
import com.atlassian.jira.task.TaskManager;
import com.atlassian.jira.web.bean.TaskDescriptorBean;
import com.atlassian.jira.web.util.OutlookDateManager;
import com.atlassian.jira.workflow.AssignableWorkflowScheme;
import com.atlassian.jira.workflow.WorkflowSchemeManager;
import com.atlassian.jira.workflow.migration.WorkflowSchemeMigrationTaskAccessor;
import com.atlassian.sal.api.websudo.WebSudoRequired;
import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.ofbiz.core.entity.GenericEntityException;

@WebSudoRequired
public class SelectProjectWorkflowScheme
extends AbstractSelectProjectScheme {
    private final WorkflowSchemeMigrationTaskAccessor taskAccessor;
    private final TaskManager taskManager;
    private TaskDescriptorBean currentActivateTask;
    private final JiraAuthenticationContext authenticationContext;
    protected final WorkflowSchemeManager workflowSchemeManager;
    protected final ProjectFactory projectFactory;
    private final OutlookDateManager outlookDateManager;
    private boolean draftMigration;
    private List<Project> projects;

    public SelectProjectWorkflowScheme(WorkflowSchemeMigrationTaskAccessor taskAccessor, TaskManager taskManager, JiraAuthenticationContext authenticationContext, WorkflowSchemeManager workflowSchemeManager, ProjectFactory projectFactory, OutlookDateManager outlookDateManager) {
        this.workflowSchemeManager = workflowSchemeManager;
        this.projectFactory = projectFactory;
        this.outlookDateManager = outlookDateManager;
        this.authenticationContext = authenticationContext;
        this.taskAccessor = taskAccessor;
        this.taskManager = taskManager;
    }

    @Override
    public SchemeManager getSchemeManager() {
        return ManagerFactory.getWorkflowSchemeManager();
    }

    public String getFinishedUrl() {
        try {
            String url = "/plugins/servlet/project-config/" + this.getProject().getString("key") + "/workflows";
            if (this.isDraftMigration()) {
                url = url + "?draftMigrationSuccess=true";
            }
            return url;
        }
        catch (GenericEntityException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public String getRedirectURL() {
        return null;
    }

    protected TaskManager getTaskManager() {
        return this.taskManager;
    }

    public boolean isAnyLiveTasks() {
        return !this.taskManager.getLiveTasks().isEmpty();
    }

    protected void initTaskDescriptorBean(TaskDescriptor taskDescriptor) {
        this.currentActivateTask = new TaskDescriptorBean(taskDescriptor, this.authenticationContext.getI18nHelper(), this.outlookDateManager, this.authenticationContext.getLoggedInUser());
    }

    protected TaskDescriptorBean getCurrentTask(boolean searchForTask) {
        TaskDescriptor taskDescriptor;
        if (this.currentActivateTask == null && searchForTask && (taskDescriptor = this.taskAccessor.getActive(this.getProjectObj())) != null) {
            this.initTaskDescriptorBean(taskDescriptor);
        }
        return this.currentActivateTask;
    }

    public TaskDescriptorBean getCurrentTask() {
        return this.getCurrentTask(true);
    }

    public boolean isDraftMigration() {
        return this.draftMigration;
    }

    public void setDraftMigration(boolean draftMigration) {
        this.draftMigration = draftMigration;
    }

    protected AssignableWorkflowScheme getExistingScheme() {
        try {
            Project project = this.projectFactory.getProject(this.getProject());
            return this.workflowSchemeManager.getWorkflowSchemeObj(project);
        }
        catch (GenericEntityException e) {
            throw new DataAccessException((Throwable)e);
        }
    }

    public List<Project> getProjects() {
        return this.projects != null ? this.projects : Collections.emptyList();
    }

    public void setProjects(List<Project> projects) {
        this.projects = projects;
    }

    public boolean isMultipleProjectMigration() {
        return false;
    }

    public String getProjectNames() {
        ArrayList projectNames = new ArrayList(Collections2.transform(this.getProjects(), (Function)new Function<Project, String>(){

            public String apply(Project project) {
                return project.getName();
            }
        }));
        Collections.sort(projectNames);
        return StringUtils.join(projectNames, (String)", ");
    }

    public String getProjectIdsParameter() {
        return SelectProjectWorkflowScheme.getProjectIdsParameter(this.getProjects());
    }

    List<String> getProjectIds() {
        return SelectProjectWorkflowScheme.getProjectIds(this.getProjects());
    }

    public static List<String> getProjectIds(List<Project> projects) {
        return Lists.transform(projects, (Function)new Function<Project, String>(){

            public String apply(Project project) {
                return String.valueOf(project.getId());
            }
        });
    }

    public static String getProjectIdsParameter(List<Project> projects) {
        List<String> projectIds = SelectProjectWorkflowScheme.getProjectIds(projects);
        return StringUtils.join(projectIds, (String)",");
    }

    public void setProjectIdsParameter(String projectIdsStr) {
        List<String> projectIds = Arrays.asList(projectIdsStr.split(","));
        List projects = Lists.transform(projectIds, (Function)new Function<String, Project>(){

            public Project apply(String projectId) {
                return SelectProjectWorkflowScheme.this.getProjectManager().getProjectObj(Long.valueOf(projectId));
            }
        });
        this.setProjects(projects);
    }

    protected Project getProjectObj() {
        return this.getProjectManager().getProjectObj(this.getProjectId());
    }
}

