/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.admin.workflow;

import com.atlassian.jira.bc.workflow.WorkflowService;
import com.atlassian.jira.security.xsrf.RequiresXsrfCheck;
import com.atlassian.jira.web.action.admin.workflow.AbstractWorkflowTransitionAction;
import com.atlassian.jira.workflow.JiraWorkflow;
import com.atlassian.jira.workflow.WorkflowException;
import com.atlassian.plugin.PluginAccessor;
import com.opensymphony.workflow.loader.ActionDescriptor;
import com.opensymphony.workflow.loader.StepDescriptor;
import java.util.List;

public abstract class AbstractDeleteWorkflowTransitionDescriptor
extends AbstractWorkflowTransitionAction {
    int count = Integer.MAX_VALUE;

    protected AbstractDeleteWorkflowTransitionDescriptor(JiraWorkflow workflow, StepDescriptor step, ActionDescriptor transition, PluginAccessor pluginAccessor, WorkflowService workflowService) {
        super(workflow, step, transition, pluginAccessor, workflowService);
    }

    protected AbstractDeleteWorkflowTransitionDescriptor(JiraWorkflow workflow, ActionDescriptor transition, PluginAccessor pluginAccessor, WorkflowService workflowService) {
        this(workflow, null, transition, pluginAccessor, workflowService);
    }

    protected void doValidation() {
        if (this.count < 1) {
            this.addErrorMessage(this.getText("admin.errors.workflows.invalid.count", "" + this.count));
        }
        this.checkDescriptor();
        if (!this.invalidInput()) {
            List descriptors = this.getDescriptorCollection();
            if (descriptors == null || descriptors.isEmpty()) {
                this.addErrorMessage(this.getText("admin.errors.workflows.no.descriptors.to.delete"));
            } else if (descriptors.size() < this.count) {
                this.addErrorMessage(this.getText("admin.errors.workflows.count.too.large", "" + this.count, "" + descriptors.size()));
            }
        }
    }

    protected abstract void checkDescriptor();

    protected abstract List getDescriptorCollection();

    public abstract String getWorkflowDescriptorName();

    @RequiresXsrfCheck
    protected String doExecute() throws Exception {
        this.deleteWorkflowDescriptor();
        this.workflowService.updateWorkflow(this.getJiraServiceContext(), this.getWorkflow());
        if (this.getStep() == null) {
            return this.getRedirect("ViewWorkflowTransition.jspa" + this.getBasicWorkflowParameters() + "&workflowTransition=" + this.getTransition().getId());
        }
        return this.getRedirect("ViewWorkflowTransition.jspa" + this.getBasicWorkflowParameters() + "&workflowStep=" + this.getStep().getId() + "&workflowTransition=" + this.getTransition().getId());
    }

    protected abstract void deleteWorkflowDescriptor() throws WorkflowException;

    public int getCount() {
        return this.count;
    }

    public void setCount(int count) {
        this.count = count;
    }
}

