/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.admin.plugins;

import com.atlassian.jira.plugin.customfield.CustomFieldSearcherModuleDescriptor;
import com.atlassian.jira.plugin.customfield.CustomFieldTypeModuleDescriptor;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.jira.web.action.admin.plugins.PluginReindexHelper;
import com.atlassian.plugin.ModuleDescriptor;
import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginAccessor;
import java.util.Collection;
import org.apache.log4j.Logger;

public class PluginReindexHelperImpl
implements PluginReindexHelper {
    private static final Logger log = Logger.getLogger(PluginReindexHelperImpl.class);
    private final PluginAccessor pluginAccessor;

    public PluginReindexHelperImpl(PluginAccessor pluginAccessor) {
        this.pluginAccessor = (PluginAccessor)Assertions.notNull((String)"pluginAccessor", (Object)pluginAccessor);
    }

    @Override
    public boolean doesEnablingPluginModuleRequireMessage(String moduleKey) {
        ModuleDescriptor moduleDescriptor = this.pluginAccessor.getEnabledPluginModule(moduleKey);
        if (moduleDescriptor != null) {
            return this.isDescriptorCustomFieldRelated(moduleDescriptor);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Got a null module descriptor when asking for module '" + moduleKey + "'"));
        }
        return false;
    }

    @Override
    public boolean doesEnablingPluginRequireMessage(String pluginKey) {
        Plugin plugin = this.pluginAccessor.getEnabledPlugin(pluginKey);
        if (plugin != null) {
            Collection moduleDescriptors = plugin.getModuleDescriptors();
            for (ModuleDescriptor moduleDescriptor : moduleDescriptors) {
                if (!this.isDescriptorCustomFieldRelated(moduleDescriptor)) continue;
                return true;
            }
        } else if (log.isDebugEnabled()) {
            log.debug((Object)("Got a null plugin when asking for key '" + pluginKey + "'"));
        }
        return false;
    }

    private boolean isDescriptorCustomFieldRelated(ModuleDescriptor<?> moduleDescriptor) {
        return moduleDescriptor instanceof CustomFieldTypeModuleDescriptor || moduleDescriptor instanceof CustomFieldSearcherModuleDescriptor;
    }
}

