/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.admin.constants;

import com.atlassian.jira.security.xsrf.RequiresXsrfCheck;
import com.atlassian.jira.web.action.admin.constants.AbstractConstantAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.ofbiz.core.entity.GenericEntityException;
import org.ofbiz.core.entity.GenericValue;

public abstract class AbstractDeleteConstant
extends AbstractConstantAction {
    public String id;
    protected String newId;
    protected boolean confirm;
    private GenericValue constant;
    private List matchingIssues;

    protected void doValidation() {
        try {
            if (this.getConstant() == null) {
                this.addErrorMessage(this.getText("admin.errors.no.constant.found", this.getNiceConstantName(), this.id));
            }
            if (this.newId == null || this.getConstant(this.newId) == null) {
                this.addError("newId", this.getText("admin.errors.specify.valid.constant.name", this.getNiceConstantName()));
            }
        }
        catch (GenericEntityException e) {
            this.log.error((Object)("Error occurred: " + (Object)((Object)e)), (Throwable)e);
            this.addErrorMessage(this.getText("admin.errors.general.error.occurred", (Object)e));
        }
    }

    @RequiresXsrfCheck
    protected abstract String doExecute() throws Exception;

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getNewId() {
        return this.newId;
    }

    public void setNewId(String newId) {
        this.newId = newId;
    }

    public GenericValue getConstant() throws GenericEntityException {
        if (this.constant == null) {
            this.constant = this.getConstant(this.id);
        }
        return this.constant;
    }

    public List getMatchingIssues() throws GenericEntityException {
        if (this.matchingIssues == null) {
            this.matchingIssues = this.getConstant().getRelated("ChildIssue");
            if (this.matchingIssues == null) {
                this.matchingIssues = Collections.EMPTY_LIST;
            }
        }
        return this.matchingIssues;
    }

    public Collection getNewConstants() {
        ArrayList<GenericValue> newConstants = new ArrayList<GenericValue>();
        for (GenericValue constant : this.getConstants()) {
            if (this.id.equals(constant.getString("id"))) continue;
            newConstants.add(constant);
        }
        return newConstants;
    }

    public boolean isConfirm() {
        return this.confirm;
    }

    public void setConfirm(boolean confirm) {
        this.confirm = confirm;
    }
}

