/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.util;

import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.JiraContactHelper;
import javax.annotation.Nullable;

public class JiraContactHelperImpl
implements JiraContactHelper {
    static final String CONTACT_ADMINISTRATOR_KEY = "common.concepts.contact.administrator";
    static final String ADMINISTRATORS_LINK = "secure/ContactAdministrators!default.jspa";
    private final ApplicationProperties applicationProperties;

    public JiraContactHelperImpl(ApplicationProperties applicationProperties) {
        this.applicationProperties = applicationProperties;
    }

    public String getAdministratorContactLinkHtml(@Nullable String baseUrl, I18nHelper i18nHelper) {
        if (baseUrl == null || this.isContactFormTurnedOff()) {
            return this.getAdministratorContactMessage(i18nHelper);
        }
        String url = baseUrl.endsWith("/") ? baseUrl + ADMINISTRATORS_LINK : baseUrl + "/" + ADMINISTRATORS_LINK;
        String link = "<a href=\"" + url + "\">";
        String closeLink = "</a>";
        return i18nHelper.getText(CONTACT_ADMINISTRATOR_KEY, link, closeLink);
    }

    private boolean isContactFormTurnedOff() {
        return !this.applicationProperties.getOption("jira.show.contact.administrators.form");
    }

    public String getAdministratorContactMessage(I18nHelper i18nHelper) {
        return i18nHelper.getText(CONTACT_ADMINISTRATOR_KEY, "", "");
    }
}

