/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.user;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.event.api.EventListener;
import com.atlassian.jira.EventComponent;
import com.atlassian.jira.event.ClearCacheEvent;
import com.atlassian.jira.user.SecureUserTokenManager;
import com.atlassian.security.random.DefaultSecureTokenGenerator;
import com.google.common.collect.MapMaker;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;

@EventComponent
public class DefaultSecureUserTokenManager
implements SecureUserTokenManager {
    final ConcurrentMap<TokenKey, User> tokenCache = new MapMaker().expiration(30L, TimeUnit.MINUTES).makeMap();

    @Override
    public String generateToken(User user, SecureUserTokenManager.TokenType tokenType) {
        if (user == null) {
            return null;
        }
        String token = DefaultSecureTokenGenerator.getInstance().generateToken();
        this.tokenCache.put(new TokenKey(token, tokenType), user);
        return token;
    }

    @Override
    public User useToken(String token, SecureUserTokenManager.TokenType tokenType) {
        return (User)this.tokenCache.remove(new TokenKey(token, tokenType));
    }

    @EventListener
    public void onClearCache(ClearCacheEvent event) {
        this.tokenCache.clear();
    }

    private static class TokenKey {
        private final String token;
        private final SecureUserTokenManager.TokenType tokenType;

        private TokenKey(String token, SecureUserTokenManager.TokenType tokenType) {
            this.token = token;
            this.tokenType = tokenType;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TokenKey tokenKey = (TokenKey)o;
            if (this.token != null ? !this.token.equals(tokenKey.token) : tokenKey.token != null) {
                return false;
            }
            return this.tokenType == tokenKey.tokenType;
        }

        public int hashCode() {
            int result = this.token != null ? this.token.hashCode() : 0;
            result = 31 * result + this.tokenType.hashCode();
            return result;
        }

        public String toString() {
            return this.token + "," + (Object)((Object)this.tokenType);
        }
    }
}

