/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.upgrade.tasks;

import com.atlassian.core.util.map.EasyMap;
import com.atlassian.jira.config.ConstantsManager;
import com.atlassian.jira.issue.CustomFieldManager;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.fields.FieldManager;
import com.atlassian.jira.issue.fields.layout.field.FieldLayout;
import com.atlassian.jira.issue.fields.layout.field.FieldLayoutManager;
import com.atlassian.jira.issue.fields.screen.FieldScreen;
import com.atlassian.jira.issue.fields.screen.FieldScreenImpl;
import com.atlassian.jira.issue.fields.screen.FieldScreenManager;
import com.atlassian.jira.issue.fields.screen.FieldScreenScheme;
import com.atlassian.jira.issue.fields.screen.FieldScreenSchemeImpl;
import com.atlassian.jira.issue.fields.screen.FieldScreenSchemeItemImpl;
import com.atlassian.jira.issue.fields.screen.FieldScreenSchemeManager;
import com.atlassian.jira.issue.fields.screen.FieldScreenTab;
import com.atlassian.jira.issue.fields.screen.issuetype.IssueTypeScreenScheme;
import com.atlassian.jira.issue.fields.screen.issuetype.IssueTypeScreenSchemeEntityImpl;
import com.atlassian.jira.issue.fields.screen.issuetype.IssueTypeScreenSchemeImpl;
import com.atlassian.jira.issue.fields.screen.issuetype.IssueTypeScreenSchemeManager;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.upgrade.tasks.AbstractFieldScreenUpgradeTask;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.web.bean.I18nBean;
import com.atlassian.jira.workflow.WorkflowTransitionUtil;
import java.util.List;
import org.ofbiz.core.entity.EntityUtil;
import org.ofbiz.core.entity.GenericEntityException;
import org.ofbiz.core.entity.GenericValue;

public class UpgradeTask_Build83
extends AbstractFieldScreenUpgradeTask {
    private static final String DEFAULT_TAB_NAME = "Field Tab";
    private final FieldManager fieldManager;
    private final FieldScreenManager fieldScreenManager;
    private final FieldScreenSchemeManager fieldScreenSchemeManager;
    private final IssueTypeScreenSchemeManager issueTypeScreenSchemeManager;
    private final ProjectManager projectManager;
    private final ConstantsManager constantsManager;
    private final FieldLayoutManager fieldLayoutManager;
    private final CustomFieldManager customFieldManager;

    public UpgradeTask_Build83(FieldManager fieldManager, FieldScreenManager fieldScreenManager, FieldScreenSchemeManager fieldScreenSchemeManager, IssueTypeScreenSchemeManager issueTypeScreenSchemeManager, ProjectManager projectManager, ConstantsManager constantsManager, FieldLayoutManager fieldLayoutManager, CustomFieldManager customFieldManager) {
        super(false);
        this.fieldManager = fieldManager;
        this.customFieldManager = customFieldManager;
        this.fieldScreenManager = fieldScreenManager;
        this.fieldScreenSchemeManager = fieldScreenSchemeManager;
        this.issueTypeScreenSchemeManager = issueTypeScreenSchemeManager;
        this.projectManager = projectManager;
        this.constantsManager = constantsManager;
        this.fieldLayoutManager = fieldLayoutManager;
    }

    @Override
    public String getBuildNumber() {
        return "83";
    }

    @Override
    public String getShortDescription() {
        return "Create default screens.";
    }

    @Override
    public void doUpgrade(boolean setupMode) throws Exception {
        FieldScreenImpl defaultFieldScreen = new FieldScreenImpl(this.fieldScreenManager);
        this.setupDefaultFieldScreen(defaultFieldScreen);
        FieldScreenTab fieldScreenTab = defaultFieldScreen.addTab(DEFAULT_TAB_NAME);
        FieldLayout defaultFieldLayout = this.fieldLayoutManager.getFieldLayout();
        if (defaultFieldLayout.getGenericValue() != null) {
            this.populateFieldScreenTab(this.fieldManager, defaultFieldLayout, fieldScreenTab);
        } else {
            this.createDefaultFieldScreen(fieldScreenTab);
        }
        FieldScreenSchemeImpl fieldScreenScheme = new FieldScreenSchemeImpl(this.fieldScreenSchemeManager);
        this.setupDefaultFieldScreenScheme(fieldScreenScheme);
        FieldScreenSchemeItemImpl fieldScreenSchemeItem = new FieldScreenSchemeItemImpl(this.fieldScreenSchemeManager, this.fieldScreenManager);
        fieldScreenSchemeItem.setIssueOperation(null);
        fieldScreenSchemeItem.setFieldScreen(defaultFieldScreen);
        fieldScreenScheme.addFieldScreenSchemeItem(fieldScreenSchemeItem);
        FieldScreenImpl assignIssueScreen = new FieldScreenImpl(this.fieldScreenManager);
        this.setupAssignIssueScreen(assignIssueScreen);
        fieldScreenTab = assignIssueScreen.addTab(DEFAULT_TAB_NAME);
        fieldScreenTab.addFieldScreenLayoutItem("assignee");
        fieldScreenTab.store();
        FieldScreenImpl resolveIssueScreen = new FieldScreenImpl(this.fieldScreenManager);
        this.setupResolveIssueScreen(resolveIssueScreen);
        fieldScreenTab = resolveIssueScreen.addTab(DEFAULT_TAB_NAME);
        fieldScreenTab.addFieldScreenLayoutItem("resolution");
        fieldScreenTab.addFieldScreenLayoutItem("fixVersions");
        fieldScreenTab.addFieldScreenLayoutItem("assignee");
        fieldScreenTab.addFieldScreenLayoutItem("worklog");
        fieldScreenTab.store();
        IssueTypeScreenSchemeImpl issueTypeScreenScheme = new IssueTypeScreenSchemeImpl(this.issueTypeScreenSchemeManager, null);
        this.setupIssueTypeScreenScheme(issueTypeScreenScheme);
        IssueTypeScreenSchemeEntityImpl issueTypeScreenSchemeEntity = new IssueTypeScreenSchemeEntityImpl(this.issueTypeScreenSchemeManager, (GenericValue)null, this.fieldScreenSchemeManager, this.constantsManager);
        issueTypeScreenSchemeEntity.setIssueTypeId(null);
        issueTypeScreenSchemeEntity.setFieldScreenScheme(fieldScreenScheme);
        issueTypeScreenScheme.addEntity(issueTypeScreenSchemeEntity);
        for (GenericValue projectGV : this.projectManager.getProjects()) {
            this.issueTypeScreenSchemeManager.addSchemeAssociation(projectGV, (IssueTypeScreenScheme)issueTypeScreenScheme);
        }
        this.setNextId("FieldScreen", new Long(10000L));
        this.setNextId("FieldScreenScheme", new Long(10000L));
    }

    void setupIssueTypeScreenScheme(IssueTypeScreenScheme issueTypeScreenScheme) {
        issueTypeScreenScheme.setId(IssueTypeScreenScheme.DEFAULT_SCHEME_ID);
        issueTypeScreenScheme.setName(this.getI18nTextWithDefault("admin.field.screens.default.issue.type.screen.scheme.name", "Default Issue Type Screen Scheme"));
        issueTypeScreenScheme.setDescription(this.getI18nTextWithDefault("admin.field.screens.default.issue.type.screen.scheme.description", "The default issue type screen scheme"));
        issueTypeScreenScheme.store();
    }

    void setupResolveIssueScreen(FieldScreen resolveIssueScreen) {
        resolveIssueScreen.setId(WorkflowTransitionUtil.VIEW_RESOLVE_ID);
        resolveIssueScreen.setName(this.getI18nTextWithDefault("admin.field.screens.resolve.issue.name", "Resolve Issue Screen"));
        resolveIssueScreen.setDescription(this.getI18nTextWithDefault("admin.field.screens.resolve.issue.description", "Allows to set resolution, change fix versions and assign an issue."));
        resolveIssueScreen.store();
    }

    void setupAssignIssueScreen(FieldScreen assignIssueScreen) {
        assignIssueScreen.setId(WorkflowTransitionUtil.VIEW_COMMENTASSIGN_ID);
        assignIssueScreen.setName(this.getI18nTextWithDefault("admin.field.screens.assign.issue.name", "Assign Issue Screen"));
        assignIssueScreen.setDescription(this.getI18nTextWithDefault("admin.field.screens.assign.issue.description", "Allows to assign an issue."));
        assignIssueScreen.store();
    }

    void setupDefaultFieldScreenScheme(FieldScreenScheme fieldScreenScheme) {
        fieldScreenScheme.setId(FieldScreenSchemeManager.DEFAULT_FIELD_SCREEN_SCHEME_ID);
        fieldScreenScheme.setName(this.getI18nTextWithDefault("admin.field.screens.default.screen.scheme.name", "Default Screen Scheme"));
        fieldScreenScheme.setDescription(this.getI18nTextWithDefault("admin.field.screens.default.screen.scheme.description", "Default Screen Scheme"));
        fieldScreenScheme.store();
    }

    void setupDefaultFieldScreen(FieldScreen defaultFieldScreen) {
        defaultFieldScreen.setId(FieldScreen.DEFAULT_SCREEN_ID);
        defaultFieldScreen.setName(this.getI18nTextWithDefault("admin.field.screens.default.name", "Default Screen"));
        defaultFieldScreen.setDescription(this.getI18nTextWithDefault("admin.field.screens.default.description", "Allows to update all system fields."));
        defaultFieldScreen.store();
    }

    private void createDefaultFieldScreen(FieldScreenTab fieldScreenTab) {
        fieldScreenTab.addFieldScreenLayoutItem("summary");
        fieldScreenTab.addFieldScreenLayoutItem("issuetype");
        fieldScreenTab.addFieldScreenLayoutItem("security");
        fieldScreenTab.addFieldScreenLayoutItem("priority");
        fieldScreenTab.addFieldScreenLayoutItem("duedate");
        fieldScreenTab.addFieldScreenLayoutItem("components");
        fieldScreenTab.addFieldScreenLayoutItem("versions");
        fieldScreenTab.addFieldScreenLayoutItem("fixVersions");
        fieldScreenTab.addFieldScreenLayoutItem("assignee");
        fieldScreenTab.addFieldScreenLayoutItem("reporter");
        fieldScreenTab.addFieldScreenLayoutItem("environment");
        fieldScreenTab.addFieldScreenLayoutItem("description");
        fieldScreenTab.addFieldScreenLayoutItem("timetracking");
        fieldScreenTab.addFieldScreenLayoutItem("attachment");
        List customFieldObjects = this.customFieldManager.getCustomFieldObjects();
        for (int i = 0; i < customFieldObjects.size(); ++i) {
            CustomField customField = (CustomField)customFieldObjects.get(i);
            fieldScreenTab.addFieldScreenLayoutItem(customField.getId());
        }
    }

    private void setNextId(String entityName, Long nextId) throws GenericEntityException {
        this.getDelegator().getNextSeqId(entityName);
        GenericValue sequeneceItem = EntityUtil.getOnly((List)this.getDelegator().findByAnd("SequenceValueItem", EasyMap.build((Object)"seqName", (Object)entityName)));
        if (sequeneceItem != null) {
            sequeneceItem.set("seqId", (Object)nextId);
            sequeneceItem.store();
            this.getDelegator().refreshSequencer();
        }
    }

    private String getI18nTextWithDefault(String key, String defaultResult) {
        String result = this.getApplicationI18n().getText(key);
        if (result.equals(key)) {
            return defaultResult;
        }
        return result;
    }

    I18nHelper getApplicationI18n() {
        return new I18nBean();
    }
}

