/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.upgrade;

import com.atlassian.core.util.ClassLoaderUtils;
import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.bc.license.JiraLicenseService;
import com.atlassian.jira.bean.export.AutoExport;
import com.atlassian.jira.bean.export.AutoExportImpl;
import com.atlassian.jira.bean.export.IllegalXMLCharactersException;
import com.atlassian.jira.config.CoreFeatures;
import com.atlassian.jira.config.FeatureManager;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.config.properties.JiraSystemProperties;
import com.atlassian.jira.event.ClearCacheEvent;
import com.atlassian.jira.event.JiraUpgradedEvent;
import com.atlassian.jira.exception.DataAccessException;
import com.atlassian.jira.extension.Startable;
import com.atlassian.jira.license.LicenseDetails;
import com.atlassian.jira.ofbiz.OfBizDelegator;
import com.atlassian.jira.upgrade.BuildNumComparator;
import com.atlassian.jira.upgrade.BuildVersionRegistry;
import com.atlassian.jira.upgrade.UpgradeHistoryItem;
import com.atlassian.jira.upgrade.UpgradeHistoryItemImpl;
import com.atlassian.jira.upgrade.UpgradeManager;
import com.atlassian.jira.upgrade.UpgradeTask;
import com.atlassian.jira.util.BuildUtilsInfo;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.JiraUtils;
import com.atlassian.jira.util.collect.CollectionBuilder;
import com.atlassian.jira.util.collect.MapBuilder;
import com.atlassian.jira.util.collect.Sized;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.jira.util.index.Contexts;
import com.atlassian.jira.util.index.IndexLifecycleManager;
import com.atlassian.jira.web.util.ExternalLinkUtilImpl;
import com.atlassian.jira.web.util.OutlookDateManager;
import com.google.common.annotations.VisibleForTesting;
import electric.xml.Document;
import electric.xml.Element;
import electric.xml.Elements;
import electric.xml.ParseException;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.apache.log4j.Logger;
import org.ofbiz.core.entity.EntityCondition;
import org.ofbiz.core.entity.EntityExpr;
import org.ofbiz.core.entity.EntityOperator;
import org.ofbiz.core.entity.GenericEntityException;
import org.ofbiz.core.entity.GenericValue;

public class UpgradeManagerImpl
implements UpgradeManager,
Startable {
    private static final Logger log = Logger.getLogger(UpgradeManagerImpl.class);
    private static final String UPGRADES_XML = "upgrades.xml";
    private static final Comparator<String> BUILD_NUMBER_COMPARATOR = new BuildNumComparator();
    private static final Pattern BUILD_NUMBER_PATTERN = Pattern.compile("\\d+$");
    private static final String ENTITY_UPGRADE_VERSION_HISTORY = "UpgradeVersionHistory";
    private static final String ENTITY_UPGRADE_HISTORY = "UpgradeHistory";
    private static final String FIELD_TARGETBUILD = "targetbuild";
    private static final String FIELD_TIMEPERFORMED = "timeperformed";
    private static final String FIELD_TARGETVERSION = "targetversion";
    private static final String FIELD_UPGRADECLASS = "upgradeclass";
    private final ApplicationProperties applicationProperties;
    private final JiraLicenseService jiraLicenseService;
    private final BuildUtilsInfo buildUtilsInfo;
    private final I18nHelper.BeanFactory i18HelperFactory;
    private final BuildVersionRegistry buildVersionRegistry;
    private final EventPublisher eventPublisher;
    private final FeatureManager featureManager;
    private final IndexLifecycleManager indexManager;
    private final OfBizDelegator ofBizDelegator;
    private final OutlookDateManager outlookDateManager;
    private SortedMap<String, UpgradeTask> allUpgrades;
    private SortedMap<String, UpgradeTask> setupUpgrades;
    private final String upgradeTaskFileName;
    private volatile Map<String, GenericValue> upgradeHistoryMap;
    private volatile String exportFilePath;

    public UpgradeManagerImpl(JiraLicenseService jiraLicenseService, BuildUtilsInfo buildUtilsInfo, I18nHelper.BeanFactory i18HelperFactory, ApplicationProperties applicationProperties, BuildVersionRegistry buildVersionRegistry, EventPublisher eventPublisher, OfBizDelegator ofBizDelegator, IndexLifecycleManager indexManager, OutlookDateManager outlookDateManager, FeatureManager featureManager) {
        this(jiraLicenseService, buildUtilsInfo, i18HelperFactory, applicationProperties, buildVersionRegistry, eventPublisher, ofBizDelegator, indexManager, outlookDateManager, UPGRADES_XML, featureManager);
    }

    UpgradeManagerImpl(JiraLicenseService jiraLicenseService, BuildUtilsInfo buildUtilsInfo, I18nHelper.BeanFactory i18HelperFactory, ApplicationProperties applicationProperties, BuildVersionRegistry buildVersionRegistry, EventPublisher eventPublisher, OfBizDelegator ofBizDelegator, IndexLifecycleManager indexManager, OutlookDateManager outlookDateManager, String upgradeTaskFileName, FeatureManager featureManager) {
        this.eventPublisher = eventPublisher;
        this.jiraLicenseService = (JiraLicenseService)Assertions.notNull((String)"jiraLicenseService", (Object)jiraLicenseService);
        this.buildUtilsInfo = (BuildUtilsInfo)Assertions.notNull((String)"buildUtilsInfo", (Object)buildUtilsInfo);
        this.i18HelperFactory = (I18nHelper.BeanFactory)Assertions.notNull((String)"i18HelperFactory", (Object)i18HelperFactory);
        this.applicationProperties = (ApplicationProperties)Assertions.notNull((String)"applicationProperties", (Object)applicationProperties);
        this.buildVersionRegistry = (BuildVersionRegistry)Assertions.notNull((String)"buildVersionRegistry", (Object)buildVersionRegistry);
        this.outlookDateManager = outlookDateManager;
        this.upgradeTaskFileName = upgradeTaskFileName;
        this.ofBizDelegator = ofBizDelegator;
        this.indexManager = indexManager;
        this.featureManager = featureManager;
    }

    @VisibleForTesting
    UpgradeManagerImpl(JiraLicenseService jiraLicenseService, BuildUtilsInfo buildUtilsInfo, I18nHelper.BeanFactory i18HelperFactory, ApplicationProperties applicationProperties, BuildVersionRegistry buildVersionRegistry, OfBizDelegator ofBizDelegator, EventPublisher eventPublisher, IndexLifecycleManager indexManager, OutlookDateManager outlookDateManager, FeatureManager featureManager, Iterable<? extends UpgradeTask> upgradeTasks, Iterable<? extends UpgradeTask> setupUpgradeTasks) {
        this.eventPublisher = eventPublisher;
        this.indexManager = indexManager;
        this.jiraLicenseService = (JiraLicenseService)Assertions.notNull((String)"jiraLicenseService", (Object)jiraLicenseService);
        this.buildUtilsInfo = (BuildUtilsInfo)Assertions.notNull((String)"buildUtilsInfo", (Object)buildUtilsInfo);
        this.i18HelperFactory = (I18nHelper.BeanFactory)Assertions.notNull((String)"i18HelperFactory", (Object)i18HelperFactory);
        this.applicationProperties = (ApplicationProperties)Assertions.notNull((String)"applicationProperties", (Object)applicationProperties);
        this.buildVersionRegistry = (BuildVersionRegistry)Assertions.notNull((String)"buildVersionRegistry", (Object)buildVersionRegistry);
        this.ofBizDelegator = ofBizDelegator;
        this.outlookDateManager = outlookDateManager;
        this.featureManager = featureManager;
        this.allUpgrades = new TreeMap<String, UpgradeTask>(BUILD_NUMBER_COMPARATOR);
        this.setupUpgrades = new TreeMap<String, UpgradeTask>(BUILD_NUMBER_COMPARATOR);
        for (UpgradeTask upgradeTask : (Iterable)Assertions.notNull((String)"upgradeTasks", upgradeTasks)) {
            this.allUpgrades.put(upgradeTask.getBuildNumber(), upgradeTask);
        }
        for (UpgradeTask upgradeTask : (Iterable)Assertions.notNull((String)"setupUpgradeTasks", setupUpgradeTasks)) {
            this.setupUpgrades.put(upgradeTask.getBuildNumber(), upgradeTask);
        }
        this.upgradeTaskFileName = null;
    }

    public void start() throws Exception {
        this.eventPublisher.register((Object)this);
    }

    @EventListener
    public void onClearCache(ClearCacheEvent event) {
        this.upgradeHistoryMap = null;
    }

    private SortedSet<String> getAllRelevantUpgradeBuildNumbers() {
        TreeSet<String> numbers = new TreeSet<String>(BUILD_NUMBER_COMPARATOR);
        SortedMap<String, UpgradeTask> standardupgrades = this.getRelevantUpgradesFromList(this.allUpgrades);
        this.addUpgradeNumbersFromMap(numbers, standardupgrades);
        return numbers;
    }

    private SortedSet<String> getSetupUpgradeBuildNumbers() {
        TreeSet<String> numbers = new TreeSet<String>(BUILD_NUMBER_COMPARATOR);
        this.addUpgradeNumbersFromMap(numbers, this.setupUpgrades);
        return numbers;
    }

    private void addUpgradeNumbersFromMap(SortedSet<String> numbers, Map<String, UpgradeTask> upgradeMap) {
        for (String buildNumber : upgradeMap.keySet()) {
            numbers.add(buildNumber);
        }
    }

    private void addAllUpgradesInResourceFile(Map<String, UpgradeTask> upgradeSet, Map<String, UpgradeTask> setupSet, String fileName) {
        InputStream is = ClassLoaderUtils.getResourceAsStream((String)fileName, this.getClass());
        try {
            Document doc = new Document(is);
            Element root = doc.getRoot();
            Elements actions = root.getElements("upgrade");
            while (actions.hasMoreElements()) {
                Element action = (Element)actions.nextElement();
                String className = action.getElement("class").getTextString();
                try {
                    UpgradeTask task = (UpgradeTask)JiraUtils.loadComponent(className, this.getClass());
                    if ("only".equals(action.getAttribute("setup"))) {
                        setupSet.put(action.getAttribute("build"), task);
                        continue;
                    }
                    upgradeSet.put(action.getAttribute("build"), task);
                    if (!"true".equals(action.getAttribute("setup"))) continue;
                    setupSet.put(action.getAttribute("build"), task);
                }
                catch (Exception e) {
                    log.error((Object)("Exception loading type: " + className), (Throwable)e);
                }
            }
        }
        catch (ParseException e) {
            log.error((Object)"Exception: ", (Throwable)e);
        }
        try {
            is.close();
        }
        catch (IOException e) {
            log.warn((Object)("Could not close " + fileName + " inputStream"));
        }
    }

    private boolean needUpgrade() {
        return this.buildUtilsInfo.getApplicationBuildNumber() > this.buildUtilsInfo.getDatabaseBuildNumber();
    }

    @Override
    public Collection<String> doUpgradeIfNeededAndAllowed(@Nullable String backupPath) throws IllegalXMLCharactersException {
        Collection<String> errors;
        LicenseDetails licenseDetails = this.jiraLicenseService.getLicense();
        if (licenseDetails.isLicenseSet()) {
            if (!licenseDetails.isMaintenanceValidForBuildDate(this.buildUtilsInfo.getCurrentBuildDate()) && !licenseDetails.hasLicenseTooOldForBuildConfirmationBeenDone()) {
                String logMsg1 = "The current license is too old to run this version of JIRA " + this.buildUtilsInfo.getVersion() + " - " + this.buildUtilsInfo.getCurrentBuildDate();
                String logMsg2 = "The maintenance period of your license expired on " + licenseDetails.getMaintenanceEndString(this.outlookDateManager.getOutlookDate(Locale.ENGLISH));
                log.info((Object)logMsg1);
                log.info((Object)logMsg2);
                log.info((Object)"Cannot proceed with the upgrade.");
                return CollectionBuilder.newBuilder((Object[])new String[]{logMsg1 + "\n" + logMsg2}).asList();
            }
            JiraLicenseService.ValidationResult validationResult = this.jiraLicenseService.validate(this.i18HelperFactory.getInstance(Locale.ENGLISH), licenseDetails.getLicenseString());
            if (validationResult.getErrorCollection().hasAnyErrors()) {
                log.info((Object)"The current license is not compatible with this installation of JIRA.");
                return this.createErrorMessages(validationResult);
            }
        }
        if ((errors = this.doUpgradeIfNeeded(backupPath)).isEmpty()) {
            this.eventPublisher.publish((Object)new JiraUpgradedEvent(false));
        }
        return errors;
    }

    private Collection<String> createErrorMessages(JiraLicenseService.ValidationResult validationResult) {
        ArrayList<String> licenseErrors = new ArrayList<String>();
        ErrorCollection errorCollection = validationResult.getErrorCollection();
        for (String err : errorCollection.getErrorMessages()) {
            licenseErrors.add(String.valueOf(err));
        }
        Map errorMap = errorCollection.getErrors();
        for (Map.Entry entry : errorMap.entrySet()) {
            licenseErrors.add(entry.getKey() + " : " + entry.getValue());
        }
        return licenseErrors;
    }

    private Collection<String> doUpgradeIfNeeded(String defaultBackupPath) throws IllegalXMLCharactersException {
        if (!"true".equals(this.applicationProperties.getString("jira.setup"))) {
            log.debug((Object)"JIRA not setup yet - not upgrading");
        } else {
            if (this.needUpgrade()) {
                ArrayList<String> errors = new ArrayList<String>();
                log.info((Object)("Detected that an upgrade is needed; existing data at build " + this.getJiraBuildNumber()));
                if (!this.autoExportDisabled() && defaultBackupPath != null) {
                    log.info((Object)"Exporting the existing data..");
                    AutoExport ae = this.getAutoExport(defaultBackupPath);
                    try {
                        String exportFilePath = ae.exportData();
                        log.info((Object)("Exported pre-upgrade data to: " + exportFilePath));
                        this.setExportFilePath(exportFilePath);
                    }
                    catch (IllegalXMLCharactersException e) {
                        throw e;
                    }
                    catch (Exception e) {
                        log.error((Object)("Error occurred during export before upgrade: " + e + ". If necessary, auto-export can be disabled; see " + ExternalLinkUtilImpl.getInstance().getProperty("external.link.jira.doc.disable.autoexport")), (Throwable)e);
                        errors.add("Error occurred during export before upgrade: " + e.getMessage() + "\n If necessary, auto-export can be disabled; see " + ExternalLinkUtilImpl.getInstance().getProperty("external.link.jira.doc.disable.autoexport") + "\n" + ExceptionUtils.getStackTrace((Throwable)e));
                        return errors;
                    }
                } else {
                    log.debug((Object)"Not doing an auto-export.");
                }
                return this.doUpgrade();
            }
            log.debug((Object)"Detected that no upgrade is neccessary");
            this.setJiraBuildNumber(this.buildUtilsInfo.getCurrentBuildNumber());
        }
        return new ArrayList<String>();
    }

    protected AutoExport getAutoExport(String defaultBackupPath) {
        return new AutoExportImpl(defaultBackupPath);
    }

    private boolean autoExportDisabled() {
        return this.isRunningOnDemand() || !this.applicationProperties.getOption("jira.autoexport") || JiraSystemProperties.isDevMode();
    }

    private boolean isRunningOnDemand() {
        return this.featureManager.isEnabled(CoreFeatures.ON_DEMAND);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Collection<String> doUpgrade() {
        log.info((Object)"___ Performing Upgrade ____________________");
        this.getUpgrades();
        Collection<Object> errors = new ArrayList();
        try {
            SortedSet<String> upgradeNumbers = this.getAllRelevantUpgradeBuildNumbers();
            SortedMap<String, UpgradeTask> standardUpgrades = this.getRelevantUpgradesFromList(this.allUpgrades);
            errors = this.runUpgradeTasks(upgradeNumbers, standardUpgrades, false);
            if (errors.isEmpty()) {
                this.logUpgradeSuccessfulMsg();
                this.setJiraBuildNumber(this.buildUtilsInfo.getCurrentBuildNumber());
            } else {
                log.error((Object)"Errors occurred during upgrade:");
                this.printErrors(errors);
            }
        }
        catch (Throwable e) {
            log.error((Object)("Exception thrown during upgrade: " + e.getMessage()), e);
            errors.add("Exception thrown during upgrade: " + e.getMessage() + "\n" + ExceptionUtils.getStackTrace((Throwable)e));
        }
        finally {
            this.releaseUpgrades();
            this.refreshSequencer();
        }
        return errors;
    }

    private void printErrors(Collection<String> errors) {
        for (String s : errors) {
            log.error((Object)("Upgrade Error: " + s));
        }
    }

    private Collection<String> runUpgradeTasks(Collection<String> upgradeNumbers, Map<String, UpgradeTask> upgradeTasks, boolean setupMode) throws Exception {
        boolean reindexRequired = false;
        ArrayList<String> errors = new ArrayList<String>();
        Map<String, GenericValue> upgradeHistoryMap = this.getPreviouslyRunUpgrades();
        boolean noErrors = true;
        for (String number : upgradeNumbers) {
            UpgradeTask standardUpgradeTask = upgradeTasks.get(number);
            if (!this.doUpgradeTaskSuccess(upgradeHistoryMap, standardUpgradeTask, errors, setupMode)) {
                noErrors = false;
                break;
            }
            if (BUILD_NUMBER_COMPARATOR.compare(number, this.getJiraBuildNumber()) > 0) {
                this.setJiraBuildNumber(number);
            }
            reindexRequired = reindexRequired || standardUpgradeTask.isReindexRequired();
        }
        if (noErrors && reindexRequired) {
            this.reindex(errors);
        }
        if (noErrors) {
            this.createUpgradeVersionHistory();
        }
        return errors;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<String> doSetupUpgrade() {
        this.getUpgrades();
        Collection<Object> errors = new ArrayList();
        try {
            SortedSet<String> upgradeNumbers = this.getSetupUpgradeBuildNumbers();
            log.info((Object)"___ Performing Setup Upgrade ____________________");
            errors = this.runUpgradeTasks(upgradeNumbers, this.setupUpgrades, true);
            if (errors.isEmpty()) {
                this.logUpgradeSuccessfulMsg();
                this.setJiraBuildNumber(this.buildUtilsInfo.getCurrentBuildNumber());
            } else {
                log.error((Object)"Errors occurred during upgrade:");
                this.printErrors(errors);
            }
        }
        catch (Throwable e) {
            log.error((Object)("Exception thrown during upgrade: " + e.getMessage()), e);
            errors.add("Exception thrown during upgrade: " + e.getMessage() + "\n" + ExceptionUtils.getStackTrace((Throwable)e));
        }
        finally {
            this.releaseUpgrades();
            this.refreshSequencer();
        }
        if (errors.isEmpty()) {
            this.eventPublisher.publish((Object)new JiraUpgradedEvent(true));
        }
        return errors;
    }

    private void refreshSequencer() {
        this.ofBizDelegator.refreshSequencer();
    }

    private void getUpgrades() {
        if (this.setupUpgrades == null || this.allUpgrades == null) {
            this.allUpgrades = new TreeMap<String, UpgradeTask>(BUILD_NUMBER_COMPARATOR);
            this.setupUpgrades = new TreeMap<String, UpgradeTask>(BUILD_NUMBER_COMPARATOR);
            this.addAllUpgradesInResourceFile(this.allUpgrades, this.setupUpgrades, this.upgradeTaskFileName);
        }
    }

    private void releaseUpgrades() {
        this.setupUpgrades = null;
        this.allUpgrades = null;
    }

    private void logUpgradeSuccessfulMsg() {
        String msg = "\n\n***************************************************************\nUpgrade Succeeded! JIRA has been upgraded to build number " + this.buildUtilsInfo.getCurrentBuildNumber() + "\n" + "***************************************************************\n";
        log.info((Object)msg);
    }

    private boolean doUpgradeTaskSuccess(Map<String, GenericValue> upgradeHistoryMap, UpgradeTask upgradeTask, Collection<String> errors, boolean setupMode) throws Exception {
        if (upgradeTask != null) {
            if (upgradeHistoryMap.get(upgradeTask.getClass().getName()) == null) {
                log.info((Object)("Performing Upgrade Task: " + upgradeTask.getShortDescription()));
                upgradeTask.doUpgrade(setupMode);
                if (!upgradeTask.getErrors().isEmpty()) {
                    log.error((Object)("Errors during Upgrade Task: " + upgradeTask.getShortDescription()));
                    errors.addAll(upgradeTask.getErrors());
                    return false;
                }
                try {
                    this.addToUpgradeHistory(upgradeTask.getClass());
                }
                catch (DataAccessException e) {
                    log.error((Object)("Problem adding upgrade task " + upgradeTask.getShortDescription() + " to the upgrade history"), (Throwable)e);
                    errors.add("There was a problem adding Upgrade Task " + upgradeTask.getShortDescription() + " to the Upgrade History");
                }
                log.info((Object)("Upgrade Task: '" + upgradeTask.getShortDescription() + "' succeeded"));
            } else {
                log.info((Object)("Not performing Upgrade Task: '" + upgradeTask.getShortDescription() + "' as it has already been run."));
            }
        }
        return true;
    }

    private Map<String, GenericValue> getPreviouslyRunUpgrades() {
        if (this.upgradeHistoryMap == null) {
            List upgradeHistoryList = this.ofBizDelegator.findAll(ENTITY_UPGRADE_HISTORY);
            this.upgradeHistoryMap = new HashMap<String, GenericValue>();
            Iterator i$ = upgradeHistoryList.iterator();
            while (i$.hasNext()) {
                GenericValue element;
                GenericValue upgradeHist = element = (GenericValue)i$.next();
                this.upgradeHistoryMap.put(upgradeHist.getString(FIELD_UPGRADECLASS), upgradeHist);
            }
        }
        return this.upgradeHistoryMap;
    }

    SortedMap<String, UpgradeTask> getRelevantUpgradesFromList(Map<String, UpgradeTask> upgradeMap) {
        try {
            TreeMap<String, UpgradeTask> unAppliedUpgrades = new TreeMap<String, UpgradeTask>(BUILD_NUMBER_COMPARATOR);
            for (Map.Entry<String, UpgradeTask> entry : upgradeMap.entrySet()) {
                if (!this.needUpgrade(entry.getKey())) continue;
                UpgradeTask upgradeTask = entry.getValue();
                unAppliedUpgrades.put(upgradeTask.getBuildNumber(), upgradeTask);
            }
            return unAppliedUpgrades;
        }
        catch (Throwable e) {
            log.error((Object)("Exception getting upgrades " + e.getMessage()), e);
            return new TreeMap<String, UpgradeTask>();
        }
    }

    private String getJiraBuildNumber() {
        if (this.applicationProperties.getString("jira.version.patched") == null) {
            this.setJiraBuildNumber("0");
        }
        return this.applicationProperties.getString("jira.version.patched");
    }

    private void setJiraBuildNumber(String version) {
        try {
            this.scrubUpgradeHistoryNewerThan(version);
        }
        catch (GenericEntityException e) {
            throw new RuntimeException("Error while scrubbing upgrade history", e);
        }
        log.info((Object)("Setting current build number to " + version));
        this.applicationProperties.setString("jira.version.patched", version);
    }

    private void scrubUpgradeHistoryNewerThan(String currentBuildNumber) throws GenericEntityException {
        EntityExpr newerThanCurrentBuild = new EntityExpr(FIELD_TARGETBUILD, EntityOperator.GREATER_THAN, (Object)currentBuildNumber);
        List previousUpgradeTasks = this.ofBizDelegator.findByCondition(ENTITY_UPGRADE_HISTORY, (EntityCondition)newerThanCurrentBuild, Collections.singleton(FIELD_UPGRADECLASS));
        for (GenericValue upgradeTask : previousUpgradeTasks) {
            log.info((Object)("Scrubbing upgrade history of task " + upgradeTask.getString(FIELD_UPGRADECLASS)));
            upgradeTask.remove();
        }
        List previousUpgradeVersions = this.ofBizDelegator.findByCondition(ENTITY_UPGRADE_VERSION_HISTORY, (EntityCondition)newerThanCurrentBuild, Collections.singleton(FIELD_TARGETBUILD));
        for (GenericValue upgradeVersion : previousUpgradeVersions) {
            log.info((Object)("Scrubbing upgrade history of build " + upgradeVersion.getString(FIELD_TARGETBUILD)));
            upgradeVersion.remove();
        }
    }

    private boolean needUpgrade(String buildNumber) {
        return this.patchBuildGreaterThanCurrent(this.getJiraBuildNumber(), buildNumber);
    }

    private boolean patchBuildGreaterThanCurrent(String currentBuild, String patchBuild) {
        return BUILD_NUMBER_COMPARATOR.compare(currentBuild, patchBuild) < 0;
    }

    private void addToUpgradeHistory(Class<? extends UpgradeTask> upgradeClass) {
        this.ofBizDelegator.createValue(ENTITY_UPGRADE_HISTORY, MapBuilder.build((Object)FIELD_UPGRADECLASS, (Object)upgradeClass.getName(), (Object)FIELD_TARGETBUILD, (Object)this.buildUtilsInfo.getCurrentBuildNumber()));
    }

    private void createUpgradeVersionHistory() throws GenericEntityException {
        Timestamp timePerformed = new Timestamp(System.currentTimeMillis());
        String currentBuildNumber = this.buildUtilsInfo.getCurrentBuildNumber();
        String version = this.buildUtilsInfo.getVersion();
        try {
            GenericValue record = this.ofBizDelegator.findByPrimaryKey(ENTITY_UPGRADE_VERSION_HISTORY, MapBuilder.build((Object)FIELD_TARGETBUILD, (Object)currentBuildNumber));
            if (record == null) {
                this.ofBizDelegator.createValue(ENTITY_UPGRADE_VERSION_HISTORY, MapBuilder.build((Object)FIELD_TIMEPERFORMED, (Object)timePerformed, (Object)FIELD_TARGETBUILD, (Object)currentBuildNumber, (Object)FIELD_TARGETVERSION, (Object)version));
            } else if (log.isDebugEnabled()) {
                log.debug((Object)("A record already exists for build number '" + currentBuildNumber + "' - skipping creation."));
            }
        }
        catch (DataAccessException e) {
            log.error((Object)("Unable to add upgrade version history record : " + version), (Throwable)e);
            throw e;
        }
    }

    SortedMap<String, UpgradeTask> getAllUpgrades() {
        return this.allUpgrades;
    }

    @Override
    public String getExportFilePath() {
        return this.exportFilePath;
    }

    @Override
    public List<UpgradeHistoryItem> getUpgradeHistory() {
        try {
            ArrayList<UpgradeHistoryItem> upgradeHistoryItems = new ArrayList<UpgradeHistoryItem>();
            UpgradeHistoryItem itemFromTasks = this.getUpgradeHistoryItemFromTasks();
            String previousVersion = null;
            String previousBuildNumber = null;
            if (itemFromTasks != null) {
                upgradeHistoryItems.add(itemFromTasks);
                previousVersion = itemFromTasks.getTargetVersion();
                previousBuildNumber = itemFromTasks.getTargetBuildNumber();
            }
            List upgradeTasksWithBuild = this.ofBizDelegator.findAll(ENTITY_UPGRADE_VERSION_HISTORY, CollectionBuilder.list((Object[])new String[]{"id"}));
            for (GenericValue genericValue : upgradeTasksWithBuild) {
                Timestamp timePerformed = genericValue.getTimestamp(FIELD_TIMEPERFORMED);
                String targetBuildNumber = genericValue.getString(FIELD_TARGETBUILD);
                String targetVersion = genericValue.getString(FIELD_TARGETVERSION);
                upgradeHistoryItems.add(new UpgradeHistoryItemImpl(timePerformed, targetBuildNumber, targetVersion, previousBuildNumber, previousVersion));
                previousVersion = targetVersion;
                previousBuildNumber = targetBuildNumber;
            }
            Collections.reverse(upgradeHistoryItems);
            return Collections.unmodifiableList(upgradeHistoryItems);
        }
        catch (GenericEntityException e) {
            log.error((Object)e);
            return Collections.emptyList();
        }
    }

    UpgradeHistoryItem getUpgradeHistoryItemFromTasks() throws GenericEntityException {
        GenericValue genericValue;
        String upgradeClassName;
        String buildNumber;
        List upgradeTasksWithoutBuild = this.ofBizDelegator.findByCondition("UpgradeHistoryLastClassForTargetBuild", (EntityCondition)new EntityExpr(FIELD_TARGETBUILD, EntityOperator.EQUALS, null), (Collection)CollectionBuilder.list((Object[])new String[]{FIELD_UPGRADECLASS}), Collections.emptyList());
        if (!upgradeTasksWithoutBuild.isEmpty() && !StringUtils.isBlank((String)(buildNumber = UpgradeManagerImpl.extractBuildNumberFromUpgradeClass(upgradeClassName = (genericValue = (GenericValue)upgradeTasksWithoutBuild.get(0)).getString(FIELD_UPGRADECLASS))))) {
            BuildVersionRegistry.BuildVersion targetVersion = this.buildVersionRegistry.getVersionForBuildNumber(buildNumber);
            return new UpgradeHistoryItemImpl(null, targetVersion.getBuildNumber(), targetVersion.getVersion(), buildNumber, null, true);
        }
        return null;
    }

    static String extractBuildNumberFromUpgradeClass(String upgradeClassName) {
        Pattern pattern = BUILD_NUMBER_PATTERN;
        Matcher matcher = pattern.matcher(upgradeClassName);
        if (matcher.find()) {
            return matcher.group(0);
        }
        return "";
    }

    private void setExportFilePath(String exportFilePath) {
        this.exportFilePath = exportFilePath;
    }

    public void reindex(Collection<String> errors) throws Exception {
        log.debug((Object)"Reindex all data if indexing is turned on.");
        boolean indexingOn = this.applicationProperties.getOption("jira.option.indexing");
        if (!indexingOn) {
            log.warn((Object)"Could not reindex data - indexing is turn off. Turn it on in the Administration section.");
        } else {
            this.indexManager.reIndexAll(Contexts.percentageLogger((Sized)this.indexManager, (Logger)log));
        }
    }
}

