/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.startup;

import com.atlassian.jira.ComponentManager;
import com.atlassian.jira.config.database.DatabaseConfigHandler;
import com.atlassian.jira.multitenant.JiraMultiTenantAuthorisationProvider;
import com.atlassian.jira.startup.DefaultJiraLauncher;
import com.atlassian.jira.startup.JiraLauncher;
import com.atlassian.jira.startup.JiraStartupChecklist;
import com.atlassian.jira.startup.StartupCheck;
import com.atlassian.jira.startup.SystemTenantProvider;
import com.atlassian.jira.studio.startup.StudioStartupHooks;
import com.atlassian.jira.studio.startup.StudioStartupHooksLocator;
import com.atlassian.johnson.JohnsonEventContainer;
import com.atlassian.johnson.event.Event;
import com.atlassian.johnson.event.EventLevel;
import com.atlassian.johnson.event.EventType;
import com.atlassian.multitenant.MultiTenantComponentMap;
import com.atlassian.multitenant.MultiTenantComponentMapBuilder;
import com.atlassian.multitenant.MultiTenantContext;
import com.atlassian.multitenant.MultiTenantCreator;
import com.atlassian.multitenant.MultiTenantDestroyer;
import com.atlassian.multitenant.Tenant;
import com.atlassian.multitenant.quartz.SystemThreadPoolController;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.Properties;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.apache.commons.io.IOUtils;
import org.apache.log4j.PropertyConfigurator;
import org.quartz.SchedulerConfigException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LauncherContextListener
implements ServletContextListener {
    private static final String STARTUP_UNEXPECTED = "startup-unexpected";
    private static final Logger log = LoggerFactory.getLogger(LauncherContextListener.class);
    private static final String LOG4J = "log4j.properties";
    private volatile MultiTenantComponentMap<JiraLauncher> launcherMap;

    public void contextInitialized(ServletContextEvent sce) {
        try {
            log.debug("Launching JIRA");
            StudioStartupHooks startupHooks = StudioStartupHooksLocator.getStudioStartupHooks();
            this.configureLog4j(startupHooks);
            startupHooks.beforeJiraStart();
            this.initMultiTenantSystem();
            if (MultiTenantContext.getSystemTenant().getConfig(StartupCheck.class) != null) {
                JiraStartupChecklist.setFailedStartupCheck((StartupCheck)MultiTenantContext.getSystemTenant().getConfig(StartupCheck.class));
            }
            MultiTenantComponentMapBuilder builder = MultiTenantContext.getFactory().createComponentMapBuilder((MultiTenantCreator)new MultiTenantCreator<JiraLauncher>(){

                public JiraLauncher create(Tenant tenant) {
                    DefaultJiraLauncher launcher = new DefaultJiraLauncher();
                    launcher.start();
                    return launcher;
                }
            });
            builder.setDestroyer((MultiTenantDestroyer)new MultiTenantDestroyer<JiraLauncher>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void destroy(Tenant tenant, JiraLauncher instance) {
                    try {
                        MultiTenantContext.getTenantReference().set(tenant, true);
                        instance.stop();
                        ComponentManager.stopTenant(tenant);
                    }
                    finally {
                        MultiTenantContext.getTenantReference().remove();
                    }
                }
            });
            builder.setLazyLoad(MultiTenantComponentMap.LazyLoadStrategy.EAGER_AFTER_STARTUP);
            this.launcherMap = builder.construct();
            log.debug("Starting all tenants");
            MultiTenantContext.getController().startAll();
            log.debug("Tenants started");
            startupHooks.afterJiraStart();
        }
        catch (Exception e) {
            log.error("Unable to start JIRA.", (Throwable)e);
            JohnsonEventContainer.get((ServletContext)sce.getServletContext()).addEvent(new Event(EventType.get((String)STARTUP_UNEXPECTED), "Unexpected exception during JIRA startup. This JIRA instance will not be able to recover. Please check the logs for details", EventLevel.get((String)"fatal")));
        }
        catch (Error e) {
            log.error("Unable to start JIRA due to Java Error.", (Throwable)e);
            throw e;
        }
    }

    private void initMultiTenantSystem() {
        log.debug("Initing multitenant system");
        Properties props = new Properties();
        props.setProperty("multitenant.system.tenant.provider", SystemTenantProvider.class.getName());
        props.setProperty("multitenant.enabled", Boolean.TRUE.toString());
        props.setProperty("multitenant.single.tenant.mode", Boolean.TRUE.toString());
        props.setProperty("multitenant.authorisation.provider.class", JiraMultiTenantAuthorisationProvider.class.getName());
        props.setProperty("multitenant.handler.database", DatabaseConfigHandler.class.getName());
        props.putAll((Map<?, ?>)MultiTenantContext.loadProperties());
        MultiTenantContext.defaultInit((Properties)props);
        try {
            SystemThreadPoolController.getInstance().initialise(2, 4);
        }
        catch (SchedulerConfigException e) {
            throw new RuntimeException(e);
        }
        log.debug("Multitenant system initialised");
    }

    public void contextDestroyed(ServletContextEvent sce) {
        this.launcherMap.destroy();
        MultiTenantContext.getController().stopAll();
        SystemThreadPoolController.getInstance().shutdown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void configureLog4j(StudioStartupHooks startupHooks) {
        Properties properties = new Properties();
        InputStream resource = this.getClass().getClassLoader().getResourceAsStream(LOG4J);
        if (resource != null) {
            try {
                properties.load(resource);
            }
            catch (IOException e) {
                log.warn("Unable read current log4j configuration. Assuming blank configuration.", (Throwable)e);
            }
            finally {
                IOUtils.closeQuietly((InputStream)resource);
            }
        } else {
            log.warn("Unable to find 'log4j.properties' on class path.");
        }
        Properties newConfig = startupHooks.getLog4jConfiguration(properties);
        if (newConfig != null) {
            PropertyConfigurator.configure((Properties)newConfig);
        }
    }
}

