/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.service.services.vcs;

import com.atlassian.configurable.ObjectConfiguration;
import com.atlassian.configurable.ObjectConfigurationException;
import com.atlassian.jira.ComponentManager;
import com.atlassian.jira.service.AbstractService;
import com.atlassian.jira.vcs.RepositoryManager;
import com.opensymphony.module.propertyset.PropertySet;
import org.apache.log4j.Logger;
import org.ofbiz.core.entity.GenericEntityException;

public class VcsService
extends AbstractService {
    private static final Logger log = Logger.getLogger(VcsService.class);
    private final RepositoryManager repositoryManager;

    public VcsService(RepositoryManager repositoryManager) {
        this.repositoryManager = repositoryManager;
    }

    public VcsService() {
        this(ComponentManager.getInstance().getRepositoryManager());
    }

    public ObjectConfiguration getObjectConfiguration() throws ObjectConfigurationException {
        return this.getObjectConfiguration("VCSService", "services/com/atlassian/jira/service/services/vcs/vcsservice.xml", null);
    }

    public void init(PropertySet props) throws ObjectConfigurationException {
        super.init(props);
    }

    public void run() {
        if (Boolean.getBoolean("jira.vcs.polldisabled")) {
            log.info((Object)"Version control polling (VcsService) disabled by 'jira.vcs.polldisabled' property.");
            return;
        }
        log.debug((Object)"VcsService service running...");
        try {
            this.repositoryManager.updateRepositories();
        }
        catch (GenericEntityException e) {
            log.error((Object)"Error occurred while running VcsService.", (Throwable)e);
        }
        catch (OutOfMemoryError e) {
            log.error((Object)"OutOfMemoryError while updating the repositories. Start the app server with more memory (see '-Xmx' parameter of the 'java' command.)", (Throwable)e);
        }
        log.debug((Object)"VcsService service finished.");
    }

    public boolean isUnique() {
        return true;
    }

    public boolean isInternal() {
        return true;
    }
}

