/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.security;

import com.atlassian.crowd.embedded.api.Group;
import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.exception.CreateException;
import com.atlassian.jira.exception.RemoveException;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.security.IssueSecuritySchemeManager;
import com.atlassian.jira.permission.PermissionSchemeManager;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectCategory;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.scheme.SchemeEntity;
import com.atlassian.jira.security.GlobalPermissionManager;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.security.Permissions;
import com.atlassian.jira.security.groups.GroupManager;
import com.atlassian.jira.user.UserUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.ofbiz.core.entity.GenericEntityException;
import org.ofbiz.core.entity.GenericValue;

public abstract class AbstractPermissionManager
implements PermissionManager {
    public void addPermission(int permissionsId, GenericValue scheme, String parameter, String securityType) throws CreateException {
        if (this.isGlobalPermission(permissionsId) && scheme != null) {
            throw new IllegalArgumentException("Can not create a global permissions in a scheme");
        }
        if (scheme == null) {
            ComponentAccessor.getGlobalPermissionManager().addPermission(permissionsId, parameter);
        } else {
            SchemeEntity schemeEntity = new SchemeEntity(securityType, parameter, (Object)permissionsId);
            try {
                this.getPermissionSchemeManager().createSchemeEntity(scheme, schemeEntity);
            }
            catch (GenericEntityException e) {
                throw new CreateException((Exception)((Object)e));
            }
        }
    }

    public boolean hasPermission(int permissionsId, User user) {
        if (!this.isGlobalPermission(permissionsId)) {
            throw new IllegalArgumentException("PermissionType passed to this function must be a global permission, " + permissionsId + " is not");
        }
        if (user == null) {
            return ComponentAccessor.getGlobalPermissionManager().hasPermission(permissionsId);
        }
        if (user.isActive()) {
            return ComponentAccessor.getGlobalPermissionManager().hasPermission(permissionsId, user);
        }
        return false;
    }

    public boolean hasPermission(int permissionsId, GenericValue projectOrIssue, User u) {
        return this.hasPermission(permissionsId, projectOrIssue, u, false);
    }

    private String createProfilerQuery(int permissionsId, User user) {
        return permissionsId + (user == null ? "-anonymous" : "-" + user.getName());
    }

    public boolean hasPermission(int permissionsId, Issue issue, User u) {
        if (issue.getGenericValue() != null) {
            return this.hasPermission(permissionsId, issue.getGenericValue(), u);
        }
        return this.hasPermission(permissionsId, issue.getProjectObject(), u, true);
    }

    public boolean hasPermission(int permissionsId, Project project, User user) {
        return this.hasPermission(permissionsId, project, user, false);
    }

    public boolean hasPermission(int permissionsId, Project project, User user, boolean issueCreation) {
        if (this.isGlobalPermission(permissionsId)) {
            throw new IllegalArgumentException("PermissionType passed to this function must NOT be a global permission, " + permissionsId + " is global");
        }
        if (project == null || project.getGenericValue() == null) {
            throw new IllegalArgumentException("The Project argument and its backing generic value must not be null");
        }
        return this.hasProjectPermission(Long.valueOf(permissionsId), project.getGenericValue(), user, issueCreation);
    }

    public boolean hasPermission(int permissionsId, GenericValue entity, User u, boolean issueCreation) {
        if (this.isGlobalPermission(permissionsId)) {
            throw new IllegalArgumentException("PermissionType passed to this function must NOT be a global permission, " + permissionsId + " is global");
        }
        if (entity == null) {
            throw new IllegalArgumentException("The entity passed must not be null");
        }
        Long permissionTypeLong = permissionsId;
        if ("Project".equals(entity.getEntityName())) {
            return this.hasProjectPermission(permissionTypeLong, entity, u, issueCreation);
        }
        if ("Issue".equals(entity.getEntityName())) {
            if (!this.hasPermission(permissionsId, this.getProjectManager().getProject(entity), u)) {
                return false;
            }
            if (!this.hasProjectPermission(permissionTypeLong, entity, u, issueCreation)) {
                return false;
            }
            IssueSecuritySchemeManager manager = (IssueSecuritySchemeManager)ComponentAccessor.getComponent(IssueSecuritySchemeManager.class);
            if (u == null) {
                return manager.hasSchemeAuthority(entity.getLong("security"), entity);
            }
            return manager.hasSchemeAuthority(entity.getLong("security"), entity, u, issueCreation);
        }
        throw new IllegalArgumentException("The entity passed must be a Project or an Issue not a " + entity.getEntityName());
    }

    protected boolean hasProjectPermission(Long permissionTypeLong, GenericValue entity, User user, boolean issueCreation) {
        if (user == null) {
            return this.getPermissionSchemeManager().hasSchemeAuthority(permissionTypeLong, entity);
        }
        if (user.isActive()) {
            return this.getPermissionSchemeManager().hasSchemeAuthority(permissionTypeLong, entity, user, issueCreation);
        }
        return false;
    }

    protected PermissionSchemeManager getPermissionSchemeManager() {
        return ComponentAccessor.getPermissionSchemeManager();
    }

    public void removeGroupPermissions(String group) throws RemoveException {
        if (group == null) {
            throw new IllegalArgumentException("Group passed must NOT be null");
        }
        GroupManager groupManager = ComponentAccessor.getGroupManager();
        if (groupManager.getGroup(group) == null) {
            throw new IllegalArgumentException("Group passed must exist");
        }
        ComponentAccessor.getGlobalPermissionManager().removePermissions(group);
        this.getPermissionSchemeManager().removeEntities("group", group);
        ((IssueSecuritySchemeManager)ComponentAccessor.getComponent(IssueSecuritySchemeManager.class)).removeEntities("group", group);
    }

    public void removeUserPermissions(String username) throws RemoveException {
        if (username == null) {
            throw new IllegalArgumentException("Username passed must NOT be null");
        }
        if (!UserUtils.userExists((String)username)) {
            throw new IllegalArgumentException("User with '" + username + "' username passed must exist");
        }
        this.getPermissionSchemeManager().removeEntities("user", username);
        ((IssueSecuritySchemeManager)ComponentAccessor.getComponent(IssueSecuritySchemeManager.class)).removeEntities("user", username);
    }

    public boolean hasProjects(int permissionId, User user) {
        if (this.isGlobalPermission(permissionId)) {
            throw new IllegalArgumentException("Permission type passed must NOT be a global permission " + permissionId + " is global");
        }
        for (GenericValue projectGV : this.getProjectManager().getProjects()) {
            if (!this.hasPermission(permissionId, projectGV, user)) continue;
            return true;
        }
        return false;
    }

    protected ProjectManager getProjectManager() {
        return ComponentAccessor.getProjectManager();
    }

    public Collection<Project> getProjectObjects(int permissionId, User user) {
        if (this.isGlobalPermission(permissionId)) {
            throw new IllegalArgumentException("Permission type passed must NOT be a global permission " + permissionId + " is global");
        }
        List projects = this.getProjectManager().getProjectObjects();
        return this.getProjectObjectsWithPermission(projects, permissionId, user);
    }

    public Collection<GenericValue> getProjects(int permissionId, User user, GenericValue category) {
        if (this.isGlobalPermission(permissionId)) {
            throw new IllegalArgumentException("Permission type passed must NOT be a global permission, " + permissionId + " is global");
        }
        Collection projects = category == null ? this.getProjectManager().getProjectsWithNoCategory() : this.getProjectManager().getProjectsFromProjectCategory(category);
        return this.getProjectsWithPermission(projects, permissionId, user);
    }

    public Collection<Project> getProjects(int permissionId, User user, ProjectCategory projectCategory) {
        if (this.isGlobalPermission(permissionId)) {
            throw new IllegalArgumentException("Permission type passed must NOT be a global permission, " + permissionId + " is global");
        }
        Collection projects = projectCategory == null ? this.getProjectManager().getProjectObjectsWithNoCategory() : this.getProjectManager().getProjectsFromProjectCategory(projectCategory);
        return this.getProjectObjectsWithPermission(projects, permissionId, user);
    }

    private Collection<GenericValue> getProjectsWithPermission(Collection<GenericValue> projects, int permissionId, User user) {
        ArrayList<GenericValue> permissibleProjects = new ArrayList<GenericValue>();
        for (GenericValue project : projects) {
            if (!this.hasPermission(permissionId, project, user)) continue;
            permissibleProjects.add(project);
        }
        return permissibleProjects;
    }

    private Collection<Project> getProjectObjectsWithPermission(Collection<Project> projects, int permissionId, User user) {
        ArrayList<Project> permissibleProjects = new ArrayList<Project>();
        for (Project project : projects) {
            if (!this.hasPermission(permissionId, project, user)) continue;
            permissibleProjects.add(project);
        }
        return permissibleProjects;
    }

    protected boolean isGlobalPermission(int permissionId) {
        return Permissions.isGlobalPermission((int)permissionId);
    }

    public Collection<Group> getAllGroups(int permissionId, Project project) {
        HashSet<Group> groups = new HashSet<Group>();
        groups.addAll(this.getPermissionSchemeManager().getGroups(Long.valueOf(permissionId), project.getGenericValue()));
        groups.addAll(((GlobalPermissionManager)ComponentAccessor.getComponent(GlobalPermissionManager.class)).getGroupsWithPermission(permissionId));
        return groups;
    }

    public Collection<GenericValue> getProjects(int permissionId, User user) {
        if (this.isGlobalPermission(permissionId)) {
            throw new IllegalArgumentException("Permission type passed must NOT be a global permission " + permissionId + " is global");
        }
        Collection projects = this.getProjectManager().getProjects();
        return this.getProjectsWithPermission(projects, permissionId, user);
    }
}

