/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.webwork;

import com.atlassian.jira.ComponentManager;
import com.atlassian.jira.action.ActionContextKit;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.template.TemplateSources;
import com.atlassian.jira.template.VelocityTemplatingEngine;
import com.atlassian.jira.util.JiraVelocityUtils;
import com.google.common.annotations.VisibleForTesting;
import com.opensymphony.util.TextUtils;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.exception.VelocityException;
import webwork.view.velocity.VelocityHelper;

public class JiraPluginWebworkVelocityServlet
extends HttpServlet {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void service(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        ActionContextKit.setContext(httpServletRequest, httpServletResponse, this.getServletContext());
        String servletPath = (String)httpServletRequest.getAttribute("javax.servlet.include.servlet_path");
        if (servletPath == null) {
            servletPath = httpServletRequest.getServletPath();
        }
        if (servletPath != null && servletPath.indexOf("/") == 0) {
            servletPath = servletPath.substring(1);
        }
        Map<String, Object> velocityParams = this.getDefaultVelocityParams();
        velocityParams.put("i18n", this.getAuthenticationContext().getI18nHelper());
        VelocityContext context = WebWorkVelocityContext.create(httpServletRequest, httpServletResponse, velocityParams);
        PrintWriter writer = httpServletResponse.getWriter();
        try {
            httpServletResponse.setContentType(this.getApplicationProperties().getContentType());
            String body = this.getTemplatingEngine().render(TemplateSources.file((String)servletPath)).applying(context).asHtml();
            writer.write(body);
        }
        catch (VelocityException e) {
            writer.write("Exception rendering velocity file " + TextUtils.htmlEncode((String)servletPath));
            writer.write("<br><pre>");
            StringWriter stringWriter = new StringWriter();
            e.printStackTrace(new PrintWriter(stringWriter));
            writer.write(TextUtils.htmlEncode((String)stringWriter.toString()));
            writer.write("</pre>");
        }
    }

    @VisibleForTesting
    Map<String, Object> getDefaultVelocityParams() {
        return JiraVelocityUtils.getDefaultVelocityParams(this.getAuthenticationContext());
    }

    @VisibleForTesting
    JiraAuthenticationContext getAuthenticationContext() {
        return ComponentAccessor.getJiraAuthenticationContext();
    }

    @VisibleForTesting
    ApplicationProperties getApplicationProperties() {
        return ComponentManager.getComponent(ApplicationProperties.class);
    }

    @VisibleForTesting
    VelocityTemplatingEngine getTemplatingEngine() {
        return (VelocityTemplatingEngine)ComponentAccessor.getComponent(VelocityTemplatingEngine.class);
    }

    private static class WebWorkVelocityContext {
        private WebWorkVelocityContext() {
        }

        private static VelocityContext create(HttpServletRequest request, HttpServletResponse response, Map<String, Object> parameters) {
            return (VelocityContext)VelocityHelper.getContextWithoutInit((ServletRequest)request, (ServletResponse)response, parameters);
        }
    }
}

