/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.webresource;

import com.atlassian.jira.config.FeatureManager;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.config.util.JiraHome;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.JiraAuthenticationContextImpl;
import com.atlassian.jira.util.BuildUtilsInfo;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.NotNull;
import com.atlassian.jira.util.velocity.VelocityRequestContextFactory;
import com.atlassian.jira.web.bean.I18nBean;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.util.Assertions;
import com.atlassian.plugin.webresource.UrlMode;
import com.atlassian.plugin.webresource.WebResourceIntegration;
import com.google.common.collect.ImmutableMap;
import java.io.File;
import java.util.Map;

public class JiraWebResourceIntegration
implements WebResourceIntegration {
    private final PluginAccessor pluginAccessor;
    private final ApplicationProperties applicationProperties;
    private final VelocityRequestContextFactory requestContextFactory;
    private final BuildUtilsInfo buildUtilsInfo;
    private final JiraAuthenticationContext jiraAuthenticationContext;
    private final I18nBean.CachingFactory i18nFactory;
    private final JiraHome jiraHome;
    private final FeatureManager featureManager;
    private static final Map<String, String> PDL_NEW = ImmutableMap.of((Object)"pdl.dir", (Object)"");
    private static final Map<String, String> PDL_OLD = ImmutableMap.of((Object)"pdl.dir", (Object)"old/");

    public JiraWebResourceIntegration(PluginAccessor pluginAccessor, ApplicationProperties applicationProperties, VelocityRequestContextFactory requestContextFactory, BuildUtilsInfo buildUtilsInfo, JiraAuthenticationContext jiraAuthenticationContext, I18nBean.CachingFactory i18nFactory, JiraHome jiraHome, FeatureManager featureManager) {
        this.i18nFactory = i18nFactory;
        this.featureManager = featureManager;
        this.pluginAccessor = (PluginAccessor)Assertions.notNull((String)"pluginAccessor", (Object)pluginAccessor);
        this.applicationProperties = (ApplicationProperties)Assertions.notNull((String)"applicationProperties", (Object)applicationProperties);
        this.requestContextFactory = (VelocityRequestContextFactory)Assertions.notNull((String)"requestContextFactory", (Object)requestContextFactory);
        this.buildUtilsInfo = (BuildUtilsInfo)Assertions.notNull((String)"buildUtilsInfo", (Object)buildUtilsInfo);
        this.jiraAuthenticationContext = (JiraAuthenticationContext)Assertions.notNull((String)"jiraAuthenticationContext", (Object)jiraAuthenticationContext);
        this.jiraHome = (JiraHome)Assertions.notNull((String)"jiraHome", (Object)jiraHome);
    }

    public PluginAccessor getPluginAccessor() {
        return this.pluginAccessor;
    }

    public Map<String, Object> getRequestCache() {
        return JiraAuthenticationContextImpl.getRequestCache();
    }

    public String getSystemCounter() {
        return this.applicationProperties.getDefaultBackedString("jira.webresource.flushcounter");
    }

    public String getSystemBuildNumber() {
        return this.buildUtilsInfo.getCurrentBuildNumber();
    }

    public String getBaseUrl() {
        return this.getBaseUrl(UrlMode.AUTO);
    }

    public String getBaseUrl(UrlMode urlMode) {
        switch (urlMode) {
            case RELATIVE: 
            case AUTO: {
                return this.requestContextFactory.getJiraVelocityRequestContext().getBaseUrl();
            }
            case ABSOLUTE: {
                return this.requestContextFactory.getJiraVelocityRequestContext().getCanonicalBaseUrl();
            }
        }
        throw new AssertionError((Object)("Unsupported URLMode: " + urlMode));
    }

    public String getSuperBatchVersion() {
        return this.applicationProperties.getDefaultBackedString("jira.webresource.superbatch.flushcounter");
    }

    public String getStaticResourceLocale() {
        I18nHelper i18n = this.jiraAuthenticationContext.getI18nHelper();
        return i18n.getLocale().toString() + this.i18nFactory.getStateHashCode();
    }

    @NotNull
    public File getTemporaryDirectory() {
        return new File(this.jiraHome.getHome(), "tmp" + File.separator + "webresources");
    }

    public Map<String, String> getResourceSubstitutionVariables() {
        boolean enabled = this.featureManager.isEnabled("com.atlassian.jira.config.PDL");
        return enabled ? PDL_NEW : PDL_OLD;
    }
}

