/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.searchrequestview.auth;

import com.atlassian.crowd.embedded.api.Group;
import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.issue.search.SearchRequest;
import com.atlassian.jira.plugin.searchrequestview.SearchRequestParams;
import com.atlassian.jira.plugin.searchrequestview.auth.Authorizer;
import com.atlassian.jira.security.groups.GroupManager;
import com.atlassian.jira.util.dbc.Null;

class UserAuthorizer
implements Authorizer {
    private final Group allowedGroup;
    private final Authorizer delegate;
    private GroupManager groupManager;

    public UserAuthorizer(Group allowedGroup, Authorizer delegate, GroupManager groupManager) {
        Null.not("allowedGroup", allowedGroup);
        Null.not("delegate", delegate);
        Null.not("groupManager", groupManager);
        this.allowedGroup = allowedGroup;
        this.delegate = delegate;
        this.groupManager = groupManager;
    }

    public Authorizer.Result isSearchRequestAuthorized(User user, SearchRequest searchRequest, SearchRequestParams params) {
        if (user != null && this.groupManager.isUserInGroup(user, this.allowedGroup)) {
            return Authorizer.Result.OK;
        }
        return this.delegate.isSearchRequestAuthorized(user, searchRequest, params);
    }

    Authorizer getDelegate() {
        return this.delegate;
    }

    Group getGroup() {
        return this.allowedGroup;
    }
}

