/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.projectpanel.fragment.impl;

import com.atlassian.jira.plugin.projectpanel.fragment.impl.AbstractFragment;
import com.atlassian.jira.plugin.report.ReportModuleDescriptor;
import com.atlassian.jira.project.browse.BrowseContext;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.template.VelocityTemplatingEngine;
import com.atlassian.plugin.PluginAccessor;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;

public class ProjectReportsFragment
extends AbstractFragment {
    private static final String TEMPLATE_DIRECTORY_PATH = "templates/plugins/jira/projectpanels/fragments/summary/";
    private static final int TRUNCATE_LIMIT = 100;
    private static final String FRAGMENT_ID = "projectreports";
    private final PluginAccessor pluginAccessor;

    public ProjectReportsFragment(VelocityTemplatingEngine templatingEngine, JiraAuthenticationContext authenticationContext, PluginAccessor pluginAccessor) {
        super(templatingEngine, authenticationContext);
        this.pluginAccessor = pluginAccessor;
    }

    @Override
    public String getId() {
        return FRAGMENT_ID;
    }

    @Override
    protected String getTemplateDirectoryPath() {
        return TEMPLATE_DIRECTORY_PATH;
    }

    @Override
    public boolean showFragment(BrowseContext ctx) {
        return !this.getReports().isEmpty();
    }

    @Override
    protected Map<String, Object> createVelocityParams(BrowseContext ctx) {
        Map<String, Object> velocityParams = super.createVelocityParams(ctx);
        velocityParams.put("reports", this.getReports());
        velocityParams.put("truncateLimit", 100);
        return velocityParams;
    }

    private Collection<ReportModuleDescriptor> getReports() {
        ArrayList reports = new ArrayList(this.pluginAccessor.getEnabledModuleDescriptorsByClass(ReportModuleDescriptor.class));
        Predicate<ReportModuleDescriptor> visibleReportFilter = new Predicate<ReportModuleDescriptor>(){

            public boolean apply(ReportModuleDescriptor input) {
                return input.getModule().showReport();
            }
        };
        return Lists.newArrayList((Iterable)Iterables.filter(reports, (Predicate)visibleReportFilter));
    }
}

