/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.notification.type;

import com.atlassian.core.util.collection.EasyList;
import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.event.issue.IssueEvent;
import com.atlassian.jira.notification.NotificationRecipient;
import com.atlassian.jira.notification.type.AbstractNotificationType;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.opensymphony.util.TextUtils;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class SingleUser
extends AbstractNotificationType {
    private static final Logger log = Logger.getLogger(SingleUser.class);
    public static final String DESC = "Single_User";
    private JiraAuthenticationContext jiraAuthenticationContext;

    public SingleUser(JiraAuthenticationContext jiraAuthenticationContext) {
        this.jiraAuthenticationContext = jiraAuthenticationContext;
    }

    public List getRecipients(IssueEvent event, String username) {
        User u = ComponentAccessor.getUserManager().getUser(username);
        if (u != null) {
            return EasyList.build((Object)new NotificationRecipient(u));
        }
        return Collections.EMPTY_LIST;
    }

    @Override
    public String getDisplayName() {
        return this.jiraAuthenticationContext.getI18nHelper().getText("admin.notification.types.single.user");
    }

    @Override
    public String getType() {
        return "user";
    }

    @Override
    public boolean doValidation(String key, Map parameters) {
        Object value = parameters.get(key);
        return value != null && TextUtils.stringSet((String)((String)value)) && ComponentAccessor.getUserManager().getUser((String)value) != null;
    }
}

