/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.mail;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.event.issue.IssueEvent;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.mail.Email;
import com.atlassian.jira.mail.JiraMailUtils;
import com.atlassian.jira.mail.MailService;
import com.atlassian.jira.mail.RenderingMailQueueItem;
import com.atlassian.jira.mail.TemplateContext;
import com.atlassian.jira.mail.TemplateContextFactory;
import com.atlassian.jira.notification.NotificationRecipient;
import com.atlassian.jira.web.bean.I18nBean;
import com.atlassian.mail.queue.MailQueue;
import com.atlassian.mail.queue.MailQueueItem;
import com.google.common.collect.Maps;
import java.util.Locale;
import java.util.Map;

public class MailServiceImpl
implements MailService {
    private final ApplicationProperties applicationProperties;
    private final MailQueue mailQueue;
    private final TemplateContextFactory templateContextFactory;

    public MailServiceImpl(ApplicationProperties applicationProperties, MailQueue mailQueue, TemplateContextFactory templateContextFactory) {
        this.applicationProperties = applicationProperties;
        this.mailQueue = mailQueue;
        this.templateContextFactory = templateContextFactory;
    }

    @Override
    public void sendRenderedMail(User replyTo, NotificationRecipient recipient, String subjectTemplatePath, String bodyTemplatePath, Map<String, Object> context) {
        TemplateContext templateContext;
        Locale locale = this.getLocale(recipient);
        String projectEmail = null;
        if (context.containsKey("issue")) {
            Issue issue = (Issue)context.get("issue");
            projectEmail = JiraMailUtils.getProjectEmailFromIssue(issue);
            IssueEvent issueEvent = new IssueEvent(issue, (Map)Maps.newHashMap(), replyTo, Long.valueOf(0L));
            templateContext = this.templateContextFactory.getTemplateContext(locale, issueEvent);
        } else {
            templateContext = this.templateContextFactory.getTemplateContext(locale);
        }
        Map<String, Object> templateParams = templateContext.getTemplateParams();
        templateParams.putAll(context);
        Email email = new Email(recipient.getEmail());
        String format = recipient.getFormat();
        email.setMimeType(MailServiceImpl.getMimeTypeForFormat(format));
        email.setFrom(projectEmail);
        email.setFromName(JiraMailUtils.getFromNameForUser(replyTo));
        email.setReplyTo(replyTo.getEmailAddress());
        RenderingMailQueueItem item = new RenderingMailQueueItem((com.atlassian.mail.Email)email, subjectTemplatePath, bodyTemplatePath, templateParams);
        this.mailQueue.addItem((MailQueueItem)item);
    }

    private Locale getLocale(NotificationRecipient recipient) {
        User toUser = recipient.getUserRecipient();
        if (toUser != null) {
            return I18nBean.getLocaleFromUser(toUser);
        }
        return this.applicationProperties.getDefaultLocale();
    }

    private static String getMimeTypeForFormat(String format) {
        if ("html".equals(format)) {
            return "text/html";
        }
        if ("text".equals(format)) {
            return "text/plain";
        }
        return format;
    }
}

