/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.jelly.tag.admin;

import com.atlassian.jira.ManagerFactory;
import com.atlassian.jira.jelly.PermissionSchemeAware;
import com.atlassian.jira.jelly.ProjectContextAccessor;
import com.atlassian.jira.jelly.ProjectContextAccessorImpl;
import com.atlassian.jira.jelly.tag.ProjectAwareActionTagSupport;
import java.util.Collection;
import java.util.List;
import org.apache.commons.jelly.JellyTagException;
import org.apache.commons.jelly.Tag;
import org.apache.commons.jelly.XMLOutput;
import org.apache.log4j.Logger;
import org.ofbiz.core.entity.GenericEntityException;
import org.ofbiz.core.entity.GenericValue;

public class SelectProjectScheme
extends ProjectAwareActionTagSupport
implements PermissionSchemeAware,
ProjectContextAccessor {
    private static final Logger log = Logger.getLogger(SelectProjectScheme.class);
    public static final String KEY_PROJECT_ID = "projectId";
    private static final String KEY_PROJECT_PERMISSION_SCHEME_IDS = "schemeIds";
    private String[] requiredContextVariables;
    private boolean hasPreviousPermissionSchemeId = false;
    private Long previousPermissionSchemeId = null;
    private final ProjectContextAccessor projectContextAccessor;

    public SelectProjectScheme() {
        this.ignoreErrors = false;
        this.projectContextAccessor = new ProjectContextAccessorImpl((Tag)this);
    }

    @Override
    protected void preContextValidation() {
        String projectKey = this.getProperty("projectKey");
        if (projectKey != null) {
            this.setProject(projectKey);
        }
        String permissionSchemeName = this.getProperty("permission-scheme");
        String issueSchemeName = this.getProperty("issue-scheme");
        if (issueSchemeName != null) {
            throw new RuntimeException("You can not set an issue scheme in the Professional Edition of JIRA. If you are using JIRA Enterprise, check that the namespace of this script is correct ('jelly:com.atlassian.jira.jelly.enterprise.JiraTagLib')");
        }
        if (permissionSchemeName != null) {
            try {
                List schemes = ManagerFactory.getPermissionSchemeManager().getSchemes();
                this.setPreviousPermissionSchemeId(this.getPreviousPermissionSchemeId());
                this.getContext().setVariable("jelly.permission.scheme.id", (Object)this.getSchemeId(schemes, permissionSchemeName));
            }
            catch (GenericEntityException e) {
                log.error((Object)"Could not retreive scheme");
            }
        }
        String requiredContextField = this.hasPermissionScheme() ? "jelly.permission.scheme.id" : "jelly.missing.one.variable.that.is.required";
        String[] temp = new String[super.getRequiredContextVariables().length + 1];
        System.arraycopy(super.getRequiredContextVariables(), 0, temp, 0, super.getRequiredContextVariables().length);
        temp[temp.length - 1] = requiredContextField;
        this.requiredContextVariables = temp;
    }

    @Override
    protected void prePropertyValidation(XMLOutput output) throws JellyTagException {
        this.setProperty(KEY_PROJECT_ID, this.getProjectId().toString());
        if (!this.hasPermissionScheme()) {
            throw new IllegalStateException("Validation should have caught no scheme before here.");
        }
        this.setActionName("SelectProjectPermissionScheme");
        this.setProperty(KEY_PROJECT_PERMISSION_SCHEME_IDS, this.getPermissionSchemeId().toString());
    }

    @Override
    protected void endTagExecution(XMLOutput output) {
        this.loadPreviousProject();
        if (this.hasPreviousPermissionSchemeId) {
            this.getContext().setVariable("jelly.permission.scheme.id", (Object)this.getPreviousPermissionSchemeId());
        }
    }

    @Override
    public String[] getRequiredContextVariables() {
        return this.requiredContextVariables;
    }

    @Override
    public String[] getRequiredProperties() {
        if (this.hasPermissionScheme()) {
            return new String[]{KEY_PROJECT_ID, KEY_PROJECT_PERMISSION_SCHEME_IDS};
        }
        return new String[]{KEY_PROJECT_ID, "You must specify a permission or issue scheme."};
    }

    @Override
    public String[] getRequiredContextVariablesAfter() {
        return new String[0];
    }

    @Override
    public boolean hasPermissionScheme() {
        return this.getContext().getVariables().containsKey("jelly.permission.scheme.id");
    }

    @Override
    public Long getPermissionSchemeId() {
        return (Long)this.getContext().getVariable("jelly.permission.scheme.id");
    }

    @Override
    public GenericValue getPermissionScheme() {
        throw new UnsupportedOperationException();
    }

    private Long getSchemeId(Collection schemes, String schemeName) {
        for (GenericValue scheme : schemes) {
            if (!schemeName.equals(scheme.getString("name"))) continue;
            return scheme.getLong("id");
        }
        return null;
    }

    private Long getPreviousPermissionSchemeId() {
        return this.previousPermissionSchemeId;
    }

    private void setPreviousPermissionSchemeId(Long previousPermissionSchemeId) {
        this.hasPreviousPermissionSchemeId = true;
        this.previousPermissionSchemeId = previousPermissionSchemeId;
    }

    @Override
    public void setProject(Long projectId) {
        this.projectContextAccessor.setProject(projectId);
    }

    @Override
    public void setProject(String projectKey) {
        this.projectContextAccessor.setProject(projectKey);
    }

    @Override
    public void setProject(GenericValue project) {
        this.projectContextAccessor.setProject(project);
    }

    @Override
    public void loadPreviousProject() {
        this.projectContextAccessor.loadPreviousProject();
    }
}

