/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.jelly.tag;

import com.atlassian.jira.ManagerFactory;
import com.atlassian.jira.jelly.JiraDynaBeanTagSupport;
import com.atlassian.jira.jelly.tag.LoadManager;
import java.util.Collection;
import org.apache.commons.jelly.JellyTagException;
import org.apache.commons.jelly.XMLOutput;
import org.apache.log4j.Logger;
import org.ofbiz.core.entity.GenericValue;

public class LoadProject
extends JiraDynaBeanTagSupport {
    private static final Logger log = Logger.getLogger(LoadManager.class);

    public void doTag(XMLOutput xmlOutput) throws JellyTagException {
        try {
            String variableName = (String)this.getProperties().get("var");
            String projectName = (String)this.getProperties().get("project-name");
            String projectKey = (String)this.getProperties().get("project-key");
            if (projectName == null && projectKey == null) {
                throw new JellyTagException("Please specify either project-name or project-key attribute for LoadProject tag");
            }
            Collection projects = ManagerFactory.getProjectManager().getProjects();
            for (GenericValue project : projects) {
                if (project.getString("name").equals(projectName)) {
                    this.getContext().setVariable(variableName, (Object)project);
                    return;
                }
                if (!project.getString("key").equals(projectKey)) continue;
                this.getContext().setVariable(variableName, (Object)project);
                return;
            }
        }
        catch (Exception e) {
            log.error((Object)e, (Throwable)e);
            throw new JellyTagException((Throwable)e);
        }
    }
}

