/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.search.searchers.util;

import com.atlassian.jira.issue.issuetype.IssueType;
import com.atlassian.jira.issue.search.SearchContext;
import com.atlassian.jira.project.Project;
import com.google.common.base.Function;
import com.google.common.collect.Lists;
import com.opensymphony.util.TextUtils;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;

public class SearchContextRenderHelper {
    public static void addSearchContextParams(SearchContext searchContext, Map<String, Object> velocityParams) {
        List projectNames = Lists.transform((List)searchContext.getProjects(), (Function)new Function<Project, String>(){

            public String apply(@Nullable Project project) {
                return TextUtils.htmlEncode((String)project.getName());
            }
        });
        velocityParams.put("contextProjectNames", StringUtils.join((Collection)projectNames, (String)", "));
        List issueTypeNames = Lists.transform((List)searchContext.getIssueTypes(), (Function)new Function<IssueType, String>(){

            public String apply(@Nullable IssueType issueType) {
                return TextUtils.htmlEncode((String)issueType.getName());
            }
        });
        velocityParams.put("contextIssueTypeNames", StringUtils.join((Collection)issueTypeNames, (String)", "));
    }
}

