/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.search.searchers.renderer;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.issue.fields.option.GroupTextOption;
import com.atlassian.jira.issue.fields.option.Option;
import com.atlassian.jira.issue.fields.option.TextOption;
import com.atlassian.jira.issue.fields.option.VersionOption;
import com.atlassian.jira.issue.search.SearchContext;
import com.atlassian.jira.issue.search.constants.SimpleFieldSearchConstantsWithEmpty;
import com.atlassian.jira.issue.search.searchers.renderer.AbstractProjectConstantsRenderer;
import com.atlassian.jira.issue.search.searchers.renderer.SearchRenderer;
import com.atlassian.jira.issue.transport.FieldValuesHolder;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.project.version.Version;
import com.atlassian.jira.project.version.VersionManager;
import com.atlassian.jira.template.VelocityTemplatingEngine;
import com.atlassian.jira.util.Function;
import com.atlassian.jira.util.collect.CollectionUtil;
import com.atlassian.jira.util.velocity.VelocityRequestContextFactory;
import com.atlassian.jira.web.FieldVisibilityManager;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.log4j.Logger;

public abstract class KickassAbstractVersionRenderer
extends AbstractProjectConstantsRenderer
implements SearchRenderer {
    private static final Logger log = Logger.getLogger(KickassAbstractVersionRenderer.class);
    private final ProjectManager projectManager;
    private final VersionManager versionManager;
    private final boolean unreleasedOptionsFirst;
    private final SimpleFieldSearchConstantsWithEmpty constants;

    KickassAbstractVersionRenderer(SimpleFieldSearchConstantsWithEmpty constants, String searcherNameKey, ProjectManager projectManager, VersionManager versionManager, VelocityRequestContextFactory velocityRequestContextFactory, ApplicationProperties applicationProperties, VelocityTemplatingEngine templatingEngine, FieldVisibilityManager fieldVisibilityManager, boolean unreleasedOptionsFirst) {
        super(velocityRequestContextFactory, applicationProperties, templatingEngine, fieldVisibilityManager, constants, searcherNameKey);
        this.constants = constants;
        this.projectManager = projectManager;
        this.versionManager = versionManager;
        this.unreleasedOptionsFirst = unreleasedOptionsFirst;
    }

    @Override
    List<Option> getSelectListOptions(User searcher, SearchContext searchContext) {
        if (!searchContext.isSingleProjectContext()) {
            return Collections.emptyList();
        }
        return this.getValidOptions(searcher, searchContext).all();
    }

    List<GroupTextOption> getOptions(User searcher, SearchContext searchContext, Collection<String> selectedValues) {
        if (!searchContext.isSingleProjectContext()) {
            return Collections.emptyList();
        }
        VersionsOptions options = this.getValidOptions(searcher, searchContext);
        ArrayList result = Lists.newArrayList();
        options.no(this.createBlankOption(searcher));
        if (this.unreleasedOptionsFirst) {
            this.addOption((List<GroupTextOption>)result, "", options.getNo(), options.getAllUnreleased(), options.getAllReleased());
            this.addOption((List<GroupTextOption>)result, "invalid", this.getInvalidOptions(searcher, selectedValues, options.all()));
            this.addOption(result, options.getUnreleased());
            this.addOption(result, options.getReleased());
        } else {
            this.addOption((List<GroupTextOption>)result, "", options.getNo(), options.getAllReleased(), options.getAllUnreleased());
            this.addOption((List<GroupTextOption>)result, "invalid", this.getInvalidOptions(searcher, selectedValues, options.all()));
            this.addOption(result, options.getReleased());
            this.addOption(result, options.getUnreleased());
        }
        return result;
    }

    private Option createBlankOption(User searcher) {
        return new TextOption("-1", this.getI18n(searcher).getText("common.filters.noversion"));
    }

    private void addOption(List<GroupTextOption> options, String groupId, Option ... addOptions) {
        this.addOption(options, groupId, Arrays.asList(addOptions));
    }

    private void addOption(List<GroupTextOption> options, String groupId, Collection<Option> addOptions) {
        ArrayList nonNullOptions = Lists.newArrayList();
        for (Option option : addOptions) {
            if (null == option) continue;
            nonNullOptions.add(option);
        }
        if (!nonNullOptions.isEmpty()) {
            options.add(new GroupTextOption(groupId, "", nonNullOptions));
        }
    }

    private void addOption(List<GroupTextOption> options, GroupTextOption option) {
        if (null != option) {
            options.add(option);
        }
    }

    private VersionsOptions getValidOptions(User searcher, SearchContext searchContext) {
        VersionsOptions options = new VersionsOptions();
        Long projectId = (Long)searchContext.getProjectIds().iterator().next();
        Project project = this.projectManager.getProjectObj(projectId);
        if (project != null) {
            ArrayList releasedVersions;
            Collection unreleasedVersions = this.versionManager.getVersionsUnreleased(project.getId(), false);
            if (!unreleasedVersions.isEmpty()) {
                options.unreleased(new GroupTextOption("-2", this.getI18n(searcher).getText("common.filters.unreleasedversions"), CollectionUtil.transform((Iterable)unreleasedVersions, VersionOption.FUNCTION)));
                options.allUnreleased((Option)new TextOption("-2", this.getI18n(searcher).getText("common.filters.unreleasedversions")));
            }
            if (!(releasedVersions = new ArrayList(this.versionManager.getVersionsReleasedDesc(project.getId(), false))).isEmpty()) {
                options.released(new GroupTextOption("-3", this.getI18n(searcher).getText("common.filters.releasedversions"), CollectionUtil.transform(releasedVersions, VersionOption.FUNCTION)));
                options.allReleased((Option)new TextOption("-3", this.getI18n(searcher).getText("common.filters.releasedversions")));
            }
        } else {
            log.warn((Object)("Project for search context " + searchContext + " is invalid"));
        }
        return options;
    }

    Set<Option> getInvalidOptions(User searcher, Collection<String> selectedKeys, Collection<Option> validOptions) {
        TreeSet<Option> invalidOptions = new TreeSet<Option>();
        if (selectedKeys != null) {
            for (String selectedKey : selectedKeys) {
                String versionName;
                if (this.isValidVersion(selectedKey, validOptions) || null == (versionName = this.versionName(searcher, selectedKey)) || this.isValidVersionName(versionName, validOptions) || this.containsVersionName(versionName, invalidOptions)) continue;
                invalidOptions.add((Option)new TextOption(selectedKey, versionName, "invalid_sel"));
            }
        }
        return invalidOptions;
    }

    public void addEditParameters(User searcher, SearchContext searchContext, FieldValuesHolder fieldValuesHolder, Map<String, Object> velocityParams, String urlParameter) {
        Collection selectedValues = (Collection)fieldValuesHolder.get((Object)urlParameter);
        velocityParams.put("selectedValues", selectedValues);
        velocityParams.put("optionGroups", this.getOptions(searcher, searchContext, selectedValues));
    }

    public void addViewParameters(User searcher, SearchContext searchContext, FieldValuesHolder fieldValuesHolder, Map<String, Object> velocityParams, String urlParameter) {
        Collection selectedValues = (Collection)fieldValuesHolder.get((Object)urlParameter);
        Collection<AbstractProjectConstantsRenderer.GenericProjectConstantsLabel> selectedObjects = this.getSelectedObjects(selectedValues, new VersionLabelFunction(searcher));
        List<Option> validOptions = this.getSelectListOptions(searcher, searchContext);
        ArrayList allValidOptions = Lists.newArrayList(validOptions);
        allValidOptions.add(this.createBlankOption(searcher));
        Collection<AbstractProjectConstantsRenderer.GenericProjectConstantsLabel> filteredLabels = this.filterDuplicateSelectedObjects(selectedObjects, allValidOptions);
        velocityParams.put("selectedObjects", filteredLabels);
    }

    private boolean isValidVersion(String key, Collection<Option> validOptions) {
        for (Option option : validOptions) {
            if (!option.getId().equals(key)) continue;
            return true;
        }
        return false;
    }

    private boolean isValidVersionName(String versionName, Collection<Option> validOptions) {
        for (Option option : validOptions) {
            if (!option.getName().equalsIgnoreCase(versionName)) continue;
            return true;
        }
        return false;
    }

    private boolean containsVersionName(String versionName, Set<Option> options) {
        for (Option option : options) {
            if (!versionName.equalsIgnoreCase(option.getName())) continue;
            return true;
        }
        return false;
    }

    private String versionName(User searcher, String id) {
        if ("-1".equals(id)) {
            return this.getI18n(searcher).getText("common.filters.noversion");
        }
        if ("-2".equals(id)) {
            return this.getI18n(searcher).getText("common.filters.unreleasedversions");
        }
        if ("-3".equals(id)) {
            return this.getI18n(searcher).getText("common.filters.releasedversions");
        }
        Version version = this.versionManager.getVersion(new Long(id));
        if (null != version) {
            return version.getName();
        }
        return null;
    }

    class VersionsOptions {
        private Option no;
        private Option allReleased;
        private Option allUnreleased;
        private GroupTextOption released;
        private GroupTextOption unreleased;

        public void no(Option option) {
            this.no = option;
        }

        public void allReleased(Option option) {
            this.allReleased = option;
        }

        public void allUnreleased(Option option) {
            this.allUnreleased = option;
        }

        public void released(GroupTextOption options) {
            this.released = options;
        }

        public void unreleased(GroupTextOption options) {
            this.unreleased = options;
        }

        public Option getNo() {
            return this.no;
        }

        public Option getAllReleased() {
            return this.allReleased;
        }

        public Option getAllUnreleased() {
            return this.allUnreleased;
        }

        public GroupTextOption getReleased() {
            return this.released;
        }

        public GroupTextOption getUnreleased() {
            return this.unreleased;
        }

        public List<Option> all() {
            ArrayList all = Lists.newArrayList();
            if (null != this.no) {
                all.add(this.no);
            }
            if (null != this.allUnreleased) {
                all.add(this.allUnreleased);
            }
            if (null != this.allReleased) {
                all.add(this.allReleased);
            }
            if (null != this.released) {
                all.addAll(this.released.getChildOptions());
            }
            if (null != this.unreleased) {
                all.addAll(this.unreleased.getChildOptions());
            }
            return all;
        }
    }

    class VersionLabelFunction
    implements Function<String, AbstractProjectConstantsRenderer.GenericProjectConstantsLabel> {
        private final User searcher;

        VersionLabelFunction(User searcher) {
            this.searcher = searcher;
        }

        public AbstractProjectConstantsRenderer.GenericProjectConstantsLabel get(String id) {
            if ("-1".equals(id)) {
                return new AbstractProjectConstantsRenderer.GenericProjectConstantsLabel(KickassAbstractVersionRenderer.this.getI18n(this.searcher).getText("common.filters.noversion"));
            }
            if ("-2".equals(id)) {
                return new AbstractProjectConstantsRenderer.GenericProjectConstantsLabel(KickassAbstractVersionRenderer.this.getI18n(this.searcher).getText("common.filters.unreleasedversions"));
            }
            if ("-3".equals(id)) {
                return new AbstractProjectConstantsRenderer.GenericProjectConstantsLabel(KickassAbstractVersionRenderer.this.getI18n(this.searcher).getText("common.filters.releasedversions"));
            }
            Version version = KickassAbstractVersionRenderer.this.versionManager.getVersion(new Long(id));
            if (version != null) {
                return new AbstractProjectConstantsRenderer.GenericProjectConstantsLabel(version.getName());
            }
            log.warn((Object)("Unknown " + KickassAbstractVersionRenderer.this.constants.getSearcherId() + " selected. Value: " + id));
            return null;
        }
    }
}

