/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.fields.screen;

import com.atlassian.jira.issue.fields.FieldManager;
import com.atlassian.jira.issue.fields.screen.FieldScreen;
import com.atlassian.jira.issue.fields.screen.FieldScreenImpl;
import com.atlassian.jira.issue.fields.screen.FieldScreenLayoutItem;
import com.atlassian.jira.issue.fields.screen.FieldScreenLayoutItemImpl;
import com.atlassian.jira.issue.fields.screen.FieldScreenManager;
import com.atlassian.jira.issue.fields.screen.FieldScreenStore;
import com.atlassian.jira.issue.fields.screen.FieldScreenTab;
import com.atlassian.jira.issue.fields.screen.FieldScreenTabImpl;
import com.atlassian.jira.ofbiz.OfBizDelegator;
import com.atlassian.jira.util.collect.MapBuilder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.ofbiz.core.entity.GenericValue;

public class DefaultFieldScreenStore
implements FieldScreenStore {
    private static final Logger log = Logger.getLogger(DefaultFieldScreenStore.class);
    private final OfBizDelegator ofBizDelegator;
    private final FieldManager fieldManager;
    private FieldScreenManager fieldScreenManager;

    public DefaultFieldScreenStore(OfBizDelegator ofBizDelegator, FieldManager fieldManager) {
        this.ofBizDelegator = ofBizDelegator;
        this.fieldManager = fieldManager;
    }

    @Override
    public void setFieldScreenManager(FieldScreenManager fieldScreenManager) {
        this.fieldScreenManager = fieldScreenManager;
    }

    @Override
    public FieldScreen getFieldScreen(Long id) {
        GenericValue fieldScreenGV = this.ofBizDelegator.findByPrimaryKey("FieldScreen", id);
        if (fieldScreenGV == null) {
            return null;
        }
        return this.buildFieldScreenObject(fieldScreenGV);
    }

    @Override
    public List<FieldScreen> getFieldScreens() {
        LinkedList<FieldScreen> fieldScreens = new LinkedList<FieldScreen>();
        List fieldScreenGVs = this.ofBizDelegator.findAll("FieldScreen", Collections.singletonList("name"));
        for (GenericValue fieldScreenGV : fieldScreenGVs) {
            fieldScreens.add(this.buildFieldScreenObject(fieldScreenGV));
        }
        return fieldScreens;
    }

    @Override
    public void createFieldScreen(FieldScreen fieldScreen) {
        Map params = MapBuilder.newBuilder().add((Object)"name", (Object)fieldScreen.getName()).add((Object)"description", (Object)fieldScreen.getDescription()).toMutableMap();
        if (fieldScreen.getId() != null) {
            params.put("id", fieldScreen.getId());
        }
        GenericValue fieldScreenGV = this.ofBizDelegator.createValue("FieldScreen", params);
        fieldScreen.setGenericValue(fieldScreenGV);
    }

    @Override
    public void removeFieldScreen(Long id) {
        this.ofBizDelegator.removeByAnd("FieldScreen", MapBuilder.build((Object)"id", (Object)id));
    }

    @Override
    public void updateFieldScreen(FieldScreen fieldScreen) {
        this.ofBizDelegator.store(fieldScreen.getGenericValue());
    }

    @Override
    public void createFieldScreenTab(FieldScreenTab fieldScreenTab) {
        GenericValue fieldScreenGV = this.ofBizDelegator.createValue("FieldScreenTab", MapBuilder.newBuilder().add((Object)"name", (Object)fieldScreenTab.getName()).add((Object)"sequence", (Object)fieldScreenTab.getPosition()).add((Object)"fieldscreen", (Object)fieldScreenTab.getFieldScreen().getId()).toMap());
        fieldScreenTab.setGenericValue(fieldScreenGV);
    }

    @Override
    public void updateFieldScreenTab(FieldScreenTab fieldScreenTab) {
        this.ofBizDelegator.store(fieldScreenTab.getGenericValue());
    }

    @Override
    public List<FieldScreenTab> getFieldScreenTabs(FieldScreen fieldScreen) {
        ArrayList<FieldScreenTab> fieldScreenTabs = new ArrayList<FieldScreenTab>();
        List fieldScreenTabGVs = this.ofBizDelegator.findByAnd("FieldScreenTab", MapBuilder.build((Object)"fieldscreen", (Object)fieldScreen.getId()), Collections.singletonList("sequence"));
        for (GenericValue fieldScreenTabGV : fieldScreenTabGVs) {
            FieldScreenTabImpl fieldScreenTab = new FieldScreenTabImpl(this.fieldScreenManager, fieldScreenTabGV);
            fieldScreenTab.setFieldScreen(fieldScreen);
            fieldScreenTabs.add(fieldScreenTab);
        }
        return fieldScreenTabs;
    }

    @Override
    public void updateFieldScreenLayoutItem(FieldScreenLayoutItem fieldScreenLayoutItem) {
        this.ofBizDelegator.store(fieldScreenLayoutItem.getGenericValue());
    }

    @Override
    public void removeFieldScreenLayoutItem(FieldScreenLayoutItem fieldScreenLayoutItem) {
        this.ofBizDelegator.removeByAnd("FieldScreenLayoutItem", MapBuilder.build((Object)"id", (Object)fieldScreenLayoutItem.getId()));
    }

    @Override
    public void removeFieldScreenLayoutItems(FieldScreenTab fieldScreenTab) {
        this.ofBizDelegator.removeByAnd("FieldScreenLayoutItem", MapBuilder.build((Object)"fieldscreentab", (Object)fieldScreenTab.getId()));
    }

    @Override
    public List<FieldScreenLayoutItem> getFieldScreenLayoutItems(FieldScreenTab fieldScreenTab) {
        ArrayList<FieldScreenLayoutItem> fieldScreenLayoutItems = new ArrayList<FieldScreenLayoutItem>();
        List fieldScreenLayoutItemGVs = this.ofBizDelegator.findByAnd("FieldScreenLayoutItem", MapBuilder.build((Object)"fieldscreentab", (Object)fieldScreenTab.getId()), Collections.singletonList("sequence"));
        for (GenericValue fieldScreenLayoutItemGV : fieldScreenLayoutItemGVs) {
            FieldScreenLayoutItem fieldScreenLayoutItem = this.buildNewFieldScreenLayoutItem(fieldScreenLayoutItemGV);
            fieldScreenLayoutItem.setFieldScreenTab(fieldScreenTab);
            fieldScreenLayoutItems.add(fieldScreenLayoutItem);
        }
        return fieldScreenLayoutItems;
    }

    @Override
    public FieldScreenLayoutItem buildNewFieldScreenLayoutItem(GenericValue genericValue) {
        return new FieldScreenLayoutItemImpl(this.fieldScreenManager, this.fieldManager, genericValue);
    }

    @Override
    public void removeFieldScreenTabs(FieldScreen fieldScreen) {
        this.ofBizDelegator.removeByAnd("FieldScreenTab", MapBuilder.build((Object)"fieldscreen", (Object)fieldScreen.getId()));
    }

    @Override
    public void removeFieldScreenTab(Long id) {
        this.ofBizDelegator.removeByAnd("FieldScreenTab", MapBuilder.build((Object)"id", (Object)id));
    }

    @Override
    public FieldScreenTab getFieldScreenTab(Long fieldScreenTabId) {
        GenericValue fieldScreenTabGV = this.ofBizDelegator.findByPrimaryKey("FieldScreenTab", fieldScreenTabId);
        if (fieldScreenTabGV != null) {
            FieldScreenTabImpl fieldScreenTab = new FieldScreenTabImpl(this.fieldScreenManager, fieldScreenTabGV);
            FieldScreen fieldScreen = this.getFieldScreen(fieldScreenTabGV.getLong("fieldscreen"));
            fieldScreenTab.setFieldScreen(fieldScreen);
            return fieldScreenTab;
        }
        log.warn((Object)("No field screen tab found for id " + fieldScreenTabId));
        return null;
    }

    @Override
    public void refresh() {
    }

    @Override
    public void createFieldScreenLayoutItem(FieldScreenLayoutItem fieldScreenLayoutItem) {
        GenericValue genericValue = this.ofBizDelegator.createValue("FieldScreenLayoutItem", MapBuilder.newBuilder().add((Object)"fieldidentifier", (Object)fieldScreenLayoutItem.getFieldId()).add((Object)"sequence", (Object)fieldScreenLayoutItem.getPosition()).add((Object)"fieldscreentab", (Object)fieldScreenLayoutItem.getFieldScreenTab().getId()).toMap());
        fieldScreenLayoutItem.setGenericValue(genericValue);
    }

    private FieldScreen buildFieldScreenObject(GenericValue fieldScreenGV) {
        return new FieldScreenImpl(this.fieldScreenManager, fieldScreenGV);
    }
}

