/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.fields;

import com.atlassian.core.util.collection.EasyList;
import com.atlassian.crowd.embedded.api.User;
import com.atlassian.event.api.EventListener;
import com.atlassian.jira.ComponentManager;
import com.atlassian.jira.EventComponent;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.ConstantsManager;
import com.atlassian.jira.event.ClearCacheEvent;
import com.atlassian.jira.exception.DataAccessException;
import com.atlassian.jira.issue.CustomFieldManager;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.fields.AffectedVersionsSystemField;
import com.atlassian.jira.issue.fields.AggregateEstimateSystemField;
import com.atlassian.jira.issue.fields.AggregateOriginalEstimateSystemField;
import com.atlassian.jira.issue.fields.AggregateProgressBarSystemField;
import com.atlassian.jira.issue.fields.AggregateTimeSpentSystemField;
import com.atlassian.jira.issue.fields.AssigneeSystemField;
import com.atlassian.jira.issue.fields.AttachmentSystemField;
import com.atlassian.jira.issue.fields.CommentSystemField;
import com.atlassian.jira.issue.fields.ComponentsSystemField;
import com.atlassian.jira.issue.fields.ConfigurableField;
import com.atlassian.jira.issue.fields.CreatedSystemField;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.fields.DescriptionSystemField;
import com.atlassian.jira.issue.fields.DueDateSystemField;
import com.atlassian.jira.issue.fields.EnvironmentSystemField;
import com.atlassian.jira.issue.fields.Field;
import com.atlassian.jira.issue.fields.FieldException;
import com.atlassian.jira.issue.fields.FieldManager;
import com.atlassian.jira.issue.fields.FixVersionsSystemField;
import com.atlassian.jira.issue.fields.HideableField;
import com.atlassian.jira.issue.fields.IssueLinksSystemField;
import com.atlassian.jira.issue.fields.IssueTypeField;
import com.atlassian.jira.issue.fields.IssueTypeSystemField;
import com.atlassian.jira.issue.fields.KeySystemField;
import com.atlassian.jira.issue.fields.LabelsSystemField;
import com.atlassian.jira.issue.fields.LastViewedSystemField;
import com.atlassian.jira.issue.fields.MandatoryField;
import com.atlassian.jira.issue.fields.NavigableField;
import com.atlassian.jira.issue.fields.OrderableField;
import com.atlassian.jira.issue.fields.OriginalEstimateSystemField;
import com.atlassian.jira.issue.fields.PrioritySystemField;
import com.atlassian.jira.issue.fields.ProgressBarSystemField;
import com.atlassian.jira.issue.fields.ProjectField;
import com.atlassian.jira.issue.fields.ProjectSystemField;
import com.atlassian.jira.issue.fields.ReporterSystemField;
import com.atlassian.jira.issue.fields.RequirableField;
import com.atlassian.jira.issue.fields.ResolutionDateSystemField;
import com.atlassian.jira.issue.fields.ResolutionSystemField;
import com.atlassian.jira.issue.fields.SearchableField;
import com.atlassian.jira.issue.fields.SecurityLevelSystemField;
import com.atlassian.jira.issue.fields.StatusSystemField;
import com.atlassian.jira.issue.fields.SubTaskSystemField;
import com.atlassian.jira.issue.fields.SummarySystemField;
import com.atlassian.jira.issue.fields.ThumbnailSystemField;
import com.atlassian.jira.issue.fields.TimeEstimateSystemField;
import com.atlassian.jira.issue.fields.TimeSpentSystemField;
import com.atlassian.jira.issue.fields.TimeTrackingSystemField;
import com.atlassian.jira.issue.fields.UnscreenableField;
import com.atlassian.jira.issue.fields.UpdatedSystemField;
import com.atlassian.jira.issue.fields.VotesSystemField;
import com.atlassian.jira.issue.fields.WatchesSystemField;
import com.atlassian.jira.issue.fields.WorkRatioSystemField;
import com.atlassian.jira.issue.fields.WorklogSystemField;
import com.atlassian.jira.issue.fields.config.manager.FieldConfigSchemeManager;
import com.atlassian.jira.issue.fields.layout.column.ColumnLayoutManager;
import com.atlassian.jira.issue.fields.layout.field.FieldLayout;
import com.atlassian.jira.issue.fields.layout.field.FieldLayoutItem;
import com.atlassian.jira.issue.fields.layout.field.FieldLayoutManager;
import com.atlassian.jira.issue.fields.renderer.RenderableField;
import com.atlassian.jira.issue.index.managers.FieldIndexerManager;
import com.atlassian.jira.issue.search.managers.IssueSearcherManager;
import com.atlassian.jira.jql.context.QueryContext;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.util.JiraUtils;
import com.atlassian.jira.util.collect.CollectionBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Predicate;
import org.apache.commons.collections.functors.InstanceofPredicate;
import org.apache.log4j.Logger;
import org.ofbiz.core.entity.GenericValue;

@EventComponent
public class DefaultFieldManager
implements FieldManager {
    private static final Logger log = Logger.getLogger(DefaultFieldManager.class);
    private FieldLayoutManager fieldLayoutManager;
    private Map<String, Field> fields;
    private List<OrderableField> orderableFields;
    private List<NavigableField> navigableFields;
    private ProjectSystemField projectSystemField;
    private final FieldConfigSchemeManager fieldConfigSchemeManager;

    public DefaultFieldManager(FieldConfigSchemeManager fieldConfigSchemeManager) {
        this.fieldConfigSchemeManager = fieldConfigSchemeManager;
        this.init();
    }

    @EventListener
    public void onClearCache(ClearCacheEvent event) {
        this.init();
    }

    private void init() {
        this.fields = new HashMap<String, Field>();
        this.orderableFields = new ArrayList<OrderableField>();
        this.navigableFields = new ArrayList<NavigableField>();
        this.projectSystemField = this.createAndRegister(ProjectSystemField.class);
        this.navigableFields.add(this.projectSystemField);
        this.navigableFields.add(this.createAndRegister(KeySystemField.class));
        SummarySystemField summarySystemField = this.createAndRegister(SummarySystemField.class);
        this.orderableFields.add(summarySystemField);
        this.navigableFields.add(summarySystemField);
        IssueTypeSystemField issueTypeSystemField = this.createAndRegister(IssueTypeSystemField.class);
        this.orderableFields.add(issueTypeSystemField);
        this.navigableFields.add(issueTypeSystemField);
        this.navigableFields.add(this.createAndRegister(StatusSystemField.class));
        PrioritySystemField prioritySystemField = this.createAndRegister(PrioritySystemField.class);
        this.orderableFields.add(prioritySystemField);
        this.navigableFields.add(prioritySystemField);
        ResolutionSystemField resolutionSystemField = this.createAndRegister(ResolutionSystemField.class);
        this.orderableFields.add(resolutionSystemField);
        this.navigableFields.add(resolutionSystemField);
        AssigneeSystemField assigneeSystemField = this.createAndRegister(AssigneeSystemField.class);
        this.orderableFields.add(assigneeSystemField);
        this.navigableFields.add(assigneeSystemField);
        ReporterSystemField reporterSystemField = this.createAndRegister(ReporterSystemField.class);
        this.orderableFields.add(reporterSystemField);
        this.navigableFields.add(reporterSystemField);
        this.navigableFields.add(this.createAndRegister(CreatedSystemField.class));
        this.navigableFields.add(this.createAndRegister(LastViewedSystemField.class));
        this.navigableFields.add(this.createAndRegister(UpdatedSystemField.class));
        this.navigableFields.add(this.createAndRegister(ResolutionDateSystemField.class));
        AffectedVersionsSystemField affectedVersionsSystemField = this.createAndRegister(AffectedVersionsSystemField.class);
        this.orderableFields.add(affectedVersionsSystemField);
        this.navigableFields.add(affectedVersionsSystemField);
        FixVersionsSystemField fixVersionsSystemField = this.createAndRegister(FixVersionsSystemField.class);
        this.orderableFields.add(fixVersionsSystemField);
        this.navigableFields.add(fixVersionsSystemField);
        ComponentsSystemField componentsSystemField = this.createAndRegister(ComponentsSystemField.class);
        this.orderableFields.add(componentsSystemField);
        this.navigableFields.add(componentsSystemField);
        DueDateSystemField dueDateSystemField = this.createAndRegister(DueDateSystemField.class);
        this.orderableFields.add(dueDateSystemField);
        this.navigableFields.add(dueDateSystemField);
        this.navigableFields.add(this.createAndRegister(VotesSystemField.class));
        this.navigableFields.add(this.createAndRegister(WatchesSystemField.class));
        this.navigableFields.add(this.createAndRegister(ThumbnailSystemField.class));
        this.navigableFields.add(this.createAndRegister(OriginalEstimateSystemField.class));
        this.navigableFields.add(this.createAndRegister(TimeEstimateSystemField.class));
        this.navigableFields.add(this.createAndRegister(TimeSpentSystemField.class));
        this.navigableFields.add(this.createAndRegister(WorkRatioSystemField.class));
        this.navigableFields.add(this.createAndRegister(SubTaskSystemField.class));
        IssueLinksSystemField issueLinksSystemField = this.createAndRegister(IssueLinksSystemField.class);
        this.orderableFields.add(issueLinksSystemField);
        this.navigableFields.add(issueLinksSystemField);
        this.orderableFields.add(this.createAndRegister(AttachmentSystemField.class));
        EnvironmentSystemField environmentSystemField = this.createAndRegister(EnvironmentSystemField.class);
        this.orderableFields.add(environmentSystemField);
        this.navigableFields.add(environmentSystemField);
        DescriptionSystemField descriptionSystemField = this.createAndRegister(DescriptionSystemField.class);
        this.orderableFields.add(descriptionSystemField);
        this.navigableFields.add(descriptionSystemField);
        this.orderableFields.add(this.createAndRegister(TimeTrackingSystemField.class));
        SecurityLevelSystemField securityLevelSystemField = this.createAndRegister(SecurityLevelSystemField.class);
        this.orderableFields.add(securityLevelSystemField);
        this.navigableFields.add(securityLevelSystemField);
        this.orderableFields.add(this.createAndRegister(CommentSystemField.class));
        this.navigableFields.add(this.createAndRegister(ProgressBarSystemField.class));
        this.navigableFields.add(this.createAndRegister(AggregateProgressBarSystemField.class));
        this.navigableFields.add(this.createAndRegister(AggregateTimeSpentSystemField.class));
        this.navigableFields.add(this.createAndRegister(AggregateEstimateSystemField.class));
        this.navigableFields.add(this.createAndRegister(AggregateOriginalEstimateSystemField.class));
        LabelsSystemField labelsSystemField = this.createAndRegister(LabelsSystemField.class);
        this.orderableFields.add(labelsSystemField);
        this.navigableFields.add(labelsSystemField);
        this.orderableFields.add(this.createAndRegister(WorklogSystemField.class));
    }

    private <T extends Field> T createAndRegister(Class<T> clazz) {
        Field field = (Field)JiraUtils.loadComponent(clazz);
        this.fields.put(field.getId(), field);
        return (T)field;
    }

    public Field getField(String id) {
        if (this.isCustomField(id)) {
            return this.getCustomField(id);
        }
        return this.fields.get(id);
    }

    public Set<NavigableField> getAllAvailableNavigableFields() throws FieldException {
        try {
            Set<NavigableField> allAvailableFields = this.getAvailableNavigableFields();
            Set<FieldLayout> uniqueSchemes = this.getAllFieldLayouts();
            return this.getAvailableFields(allAvailableFields, uniqueSchemes);
        }
        catch (DataAccessException e) {
            String message = "Error retrieving field layout.";
            log.error((Object)message, (Throwable)e);
            throw new FieldException(message, (Throwable)e);
        }
    }

    public Set<NavigableField> getAvailableNavigableFields(User remoteUser) throws FieldException {
        HashSet<NavigableField> availableFields = new HashSet<NavigableField>();
        try {
            Set<FieldLayout> uniqueSchemes = this.getUniqueSchemes(Collections.<Long>emptyList(), Collections.<String>emptyList(), remoteUser);
            HashSet<String> browsableProjects = this.getBrowsableProjectKeys(remoteUser);
            Set<NavigableField> allAvailableFields = this.getAvailableNavigableFields();
            for (NavigableField field : allAvailableFields) {
                if (this.isFieldHidden(uniqueSchemes, (Field)field)) continue;
                if (this.isCustomField((Field)field)) {
                    CustomField customField = this.getCustomField(field.getId());
                    if (!this.userHasPermissionToCustomFieldProjects(customField, browsableProjects)) continue;
                    availableFields.add(field);
                    continue;
                }
                availableFields.add(field);
            }
            return availableFields;
        }
        catch (DataAccessException e) {
            String message = "Error retrieving field layout.";
            log.error((Object)message, (Throwable)e);
            throw new FieldException(message, (Throwable)e);
        }
    }

    private boolean userHasPermissionToCustomFieldProjects(CustomField customField, HashSet<String> browsableProjects) {
        if (customField.isAllProjects()) {
            return true;
        }
        List projects = customField.getAssociatedProjects();
        if (projects == null) {
            return false;
        }
        for (GenericValue project : projects) {
            if (!browsableProjects.contains(project.getString("key"))) continue;
            return true;
        }
        return false;
    }

    private HashSet<String> getBrowsableProjectKeys(User remoteUser) {
        Collection<Project> browsableProjectObjects = this.getBrowsableProjectObjects(remoteUser);
        HashSet<String> browsableProjectKeys = new HashSet<String>(browsableProjectObjects.size());
        for (Project project : browsableProjectObjects) {
            browsableProjectKeys.add(project.getKey());
        }
        return browsableProjectKeys;
    }

    public Set<SearchableField> getAllSearchableFields() {
        LinkedHashSet<SearchableField> allFields = new LinkedHashSet<SearchableField>();
        this.addAllSystemSearchableFields(allFields);
        allFields.addAll(this.getCustomFieldManager().getCustomFieldObjects());
        return allFields;
    }

    public Set<SearchableField> getSystemSearchableFields() {
        LinkedHashSet<SearchableField> allFields = new LinkedHashSet<SearchableField>();
        this.addAllSystemSearchableFields(allFields);
        return allFields;
    }

    public IssueTypeField getIssueTypeField() {
        return (IssueTypeField)this.getField("issuetype");
    }

    public ProjectField getProjectField() {
        return (ProjectField)this.getField("project");
    }

    public Set<NavigableField> getAvailableNavigableFieldsWithScope(User user) throws FieldException {
        return this.getAvailableNavigableFieldsWithScope(user, Collections.<Long>emptyList(), Collections.<String>emptyList());
    }

    public Set<NavigableField> getAvailableNavigableFieldsWithScope(User remoteUser, QueryContext queryContext) throws FieldException {
        LinkedHashSet<NavigableField> allFields = new LinkedHashSet<NavigableField>();
        for (QueryContext.ProjectIssueTypeContexts context : queryContext.getProjectIssueTypeContexts()) {
            Set<NavigableField> availableFields = this.getAvailableNavigableFieldsWithScope(remoteUser, context.getProjectIdInList(), context.getIssueTypeIds());
            allFields.addAll(availableFields);
        }
        return allFields;
    }

    private Set<NavigableField> getAvailableNavigableFieldsWithScope(User remoteUser, List<Long> projectIds, List<String> issueTypes) throws FieldException {
        LinkedHashSet<NavigableField> availableFields = new LinkedHashSet<NavigableField>();
        try {
            Set<FieldLayout> schemes = this.getUniqueSchemes(projectIds, issueTypes, remoteUser);
            LinkedHashSet<NavigableField> allAvailableFields = new LinkedHashSet<NavigableField>();
            allAvailableFields.addAll(this.navigableFields);
            allAvailableFields.removeAll(this.getUnavailableFields());
            availableFields.addAll(this.getAvailableFields(allAvailableFields, schemes));
            availableFields.addAll(this.getAvailableCustomFieldsWithScope(remoteUser, projectIds, issueTypes));
            return availableFields;
        }
        catch (DataAccessException e) {
            String message = "Error retrieving field layout.";
            log.error((Object)message, (Throwable)e);
            throw new FieldException(message, (Throwable)e);
        }
    }

    private <F extends Field> Set<F> getAvailableFields(Collection<F> fieldsToCheck, Set<FieldLayout> schemes) {
        LinkedHashSet<Field> availableFields = new LinkedHashSet<Field>();
        for (Field field : fieldsToCheck) {
            if (this.isFieldHidden(schemes, field)) continue;
            availableFields.add(field);
        }
        return availableFields;
    }

    public Set<CustomField> getAvailableCustomFields(User remoteUser, Issue issue) throws FieldException {
        Project project = issue.getProjectObject();
        List projectList = project == null ? Collections.emptyList() : CollectionBuilder.list((Object[])new Long[]{project.getId()});
        return this.getAvailableCustomFieldsWithScope(remoteUser, projectList, CollectionBuilder.list((Object[])new String[]{issue.getIssueTypeObject().getId()}));
    }

    private Set<CustomField> getAvailableCustomFieldsWithScope(User remoteUser, List<Long> projectIds, List<String> issueTypes) throws FieldException {
        try {
            Set<FieldLayout> schemes = this.getUniqueSchemes(projectIds, issueTypes, remoteUser);
            Collection existingCustomFields = new HashSet();
            for (Long projectId : projectIds) {
                List existingCustomFieldsForProject = this.getCustomFieldManager().getCustomFieldObjects(projectId, issueTypes);
                if (existingCustomFieldsForProject == null) continue;
                existingCustomFields.addAll(existingCustomFieldsForProject);
            }
            if (projectIds.isEmpty()) {
                existingCustomFields = this.getCustomFieldManager().getCustomFieldObjects(null, issueTypes);
            }
            return this.getAvailableFields(existingCustomFields, schemes);
        }
        catch (DataAccessException e) {
            String message = "Error retrieving field layout for " + (projectIds != null && !projectIds.isEmpty() ? "projects '" + projectIds + "'." : "null project.");
            log.error((Object)message, (Throwable)e);
            throw new FieldException(message, (Throwable)e);
        }
    }

    private Set<FieldLayout> getUniqueSchemes(List<Long> projectIds, List<String> issueTypes, User remoteUser) {
        if (projectIds.isEmpty() && issueTypes.isEmpty()) {
            Collection<Project> projects = this.getBrowsableProjectObjects(remoteUser);
            HashSet<FieldLayout> fieldLayoutSet = new HashSet<FieldLayout>();
            for (Project project : projects) {
                fieldLayoutSet.addAll(this.getFieldLayoutManager().getUniqueFieldLayouts(project));
            }
            return fieldLayoutSet;
        }
        if (projectIds.isEmpty() && !issueTypes.isEmpty()) {
            return this.findVisibleFieldLayouts(this.getBrowsableProjectObjects(remoteUser), issueTypes);
        }
        if (!projectIds.isEmpty() && issueTypes.isEmpty()) {
            return this.getVisibleFieldLayouts(ComponentAccessor.getProjectManager().convertToProjects(projectIds), this.getAllIssueTypes());
        }
        return this.getVisibleFieldLayouts(ComponentAccessor.getProjectManager().convertToProjects(projectIds), issueTypes);
    }

    public boolean isFieldHidden(User remoteUser, String fieldId) {
        return this.isFieldHidden(remoteUser, this.getField(fieldId));
    }

    public boolean isFieldHidden(User remoteUser, Field field) {
        Set<FieldLayout> visibleFieldLayouts = this.getVisibleFieldLayouts(remoteUser);
        return this.isFieldHidden(visibleFieldLayouts, field);
    }

    public Set<FieldLayout> getVisibleFieldLayouts(User user) {
        return this.getUniqueSchemes(Collections.<Long>emptyList(), Collections.<String>emptyList(), user);
    }

    public boolean isFieldHidden(Set<FieldLayout> fieldLayouts, Field field) {
        if (!this.isOrderableField(field)) {
            return false;
        }
        OrderableField orderableField = this.getOrderableField(field.getId());
        for (FieldLayout fieldLayout : fieldLayouts) {
            FieldLayoutItem fieldLayoutItem = fieldLayout.getFieldLayoutItem(orderableField);
            if (fieldLayoutItem.isHidden()) continue;
            return fieldLayoutItem.isHidden();
        }
        return true;
    }

    private Set<FieldLayout> getAllFieldLayouts() {
        return this.getVisibleFieldLayouts(ComponentAccessor.getProjectManager().getProjects(), this.getAllIssueTypes());
    }

    private List<String> getAllIssueTypes() {
        ConstantsManager constantsManager = ComponentAccessor.getConstantsManager();
        return constantsManager.expandIssueTypeIds((Collection)EasyList.build((Object)"-4"));
    }

    private Collection<Project> getBrowsableProjectObjects(User remoteUser) {
        return ComponentAccessor.getPermissionManager().getProjectObjects(10, remoteUser);
    }

    private Set<FieldLayout> findVisibleFieldLayouts(Collection<Project> projects, List<String> issueTypes) {
        HashSet<FieldLayout> uniqueSchemes = new HashSet<FieldLayout>();
        for (Project project : projects) {
            for (String issueTypeId : issueTypes) {
                FieldLayout fieldLayout = this.getFieldLayoutManager().getFieldLayout(project, issueTypeId);
                uniqueSchemes.add(fieldLayout);
            }
        }
        return uniqueSchemes;
    }

    private Set<FieldLayout> getVisibleFieldLayouts(Collection<GenericValue> projects, List<String> issueTypes) {
        HashSet<FieldLayout> uniqueSchemes = new HashSet<FieldLayout>();
        for (GenericValue project : projects) {
            for (String issueTypeId : issueTypes) {
                FieldLayout fieldLayout = this.getFieldLayoutManager().getFieldLayout(project, issueTypeId);
                uniqueSchemes.add(fieldLayout);
            }
        }
        return uniqueSchemes;
    }

    public boolean isCustomField(String key) {
        CustomField customField = this.getCustomFieldManager().getCustomFieldObject(key);
        return customField != null;
    }

    public boolean isCustomField(Field field) {
        return field instanceof CustomField;
    }

    public CustomField getCustomField(String key) {
        CustomField customFieldObject = this.getCustomFieldManager().getCustomFieldObject(key);
        if (customFieldObject == null) {
            throw new IllegalArgumentException("Custom field with id '" + key + "' does not exist.");
        }
        return customFieldObject;
    }

    public boolean isHideableField(String id) {
        if (this.isCustomField(id)) {
            return true;
        }
        Field field = this.fields.get(id);
        return this.isHideableField(field);
    }

    public boolean isHideableField(Field field) {
        if (this.isCustomField(field)) {
            return true;
        }
        return field instanceof HideableField;
    }

    public HideableField getHideableField(String id) {
        if (this.isCustomField(id)) {
            return this.getCustomField(id);
        }
        if (this.isHideableField(id)) {
            return (HideableField)this.fields.get(id);
        }
        throw new IllegalArgumentException("The field with id '" + id + "' is not a HideableField.");
    }

    public boolean isOrderableField(String id) {
        if (this.isCustomField(id)) {
            return true;
        }
        Field field = this.fields.get(id);
        return this.isOrderableField(field);
    }

    public boolean isOrderableField(Field field) {
        if (this.isCustomField(field)) {
            return true;
        }
        return field instanceof OrderableField && this.orderableFields.contains(field);
    }

    public OrderableField getOrderableField(String id) {
        if (this.isCustomField(id)) {
            return this.getCustomField(id);
        }
        if (this.isOrderableField(id)) {
            return (OrderableField)this.fields.get(id);
        }
        return null;
    }

    public ConfigurableField getConfigurableField(String id) {
        OrderableField field = this.getOrderableField(id);
        if (field != null && field instanceof ConfigurableField) {
            return (ConfigurableField)field;
        }
        if (log.isInfoEnabled() && field != null) {
            log.info((Object)("Field found for " + id + " but was not a ConfigurableField. Type is " + field.getClass().getName() + " : " + field));
        }
        return null;
    }

    public Set<OrderableField> getOrderableFields() {
        return Collections.unmodifiableSet(this.getAvailableOrderableFields());
    }

    public Set<NavigableField> getNavigableFields() {
        return Collections.unmodifiableSet(this.getAvailableNavigableFields());
    }

    public boolean isNavigableField(String id) {
        if (this.isCustomField(id)) {
            return true;
        }
        Field field = this.fields.get(id);
        return this.isNavigableField(field);
    }

    public boolean isNavigableField(Field field) {
        if (this.isCustomField(field)) {
            return true;
        }
        return field instanceof NavigableField && this.navigableFields.contains(field);
    }

    public NavigableField getNavigableField(String id) {
        if (this.isCustomField(id)) {
            return this.getCustomField(id);
        }
        if (this.isNavigableField(id)) {
            return (NavigableField)this.fields.get(id);
        }
        throw new IllegalArgumentException("The field with id '" + id + "' is not a NavigableField.");
    }

    public boolean isRequirableField(String id) {
        if (this.isCustomField(id)) {
            return true;
        }
        return this.isRequirableField(this.fields.get(id));
    }

    public boolean isRequirableField(Field field) {
        if (this.isCustomField(field)) {
            return true;
        }
        return field instanceof RequirableField;
    }

    public boolean isMandatoryField(String id) {
        if (this.isCustomField(id)) {
            return false;
        }
        Field field = this.fields.get(id);
        return this.isMandatoryField(field);
    }

    public boolean isMandatoryField(Field field) {
        if (this.isCustomField(field)) {
            return false;
        }
        return field instanceof MandatoryField;
    }

    public boolean isRenderableField(String id) {
        if (this.isCustomField(id)) {
            CustomField field = this.getCustomField(id);
            return field.isRenderable();
        }
        Field field = this.fields.get(id);
        return this.isRenderableField(field);
    }

    public boolean isRenderableField(Field field) {
        if (this.isCustomField(field)) {
            return ((CustomField)field).isRenderable();
        }
        return field instanceof RenderableField;
    }

    public boolean isUnscreenableField(String id) {
        if (this.isCustomField(id)) {
            return false;
        }
        Field field = this.fields.get(id);
        return this.isUnscreenableField(field);
    }

    public boolean isUnscreenableField(Field field) {
        if (this.isCustomField(field)) {
            return false;
        }
        return field instanceof UnscreenableField;
    }

    public RequirableField getRequiredField(String id) {
        if (this.isCustomField(id)) {
            return this.getCustomField(id);
        }
        if (this.isRequirableField(id)) {
            return (RequirableField)this.fields.get(id);
        }
        throw new IllegalArgumentException("The field with id '" + id + "' is not a RequirableField.");
    }

    private CustomFieldManager getCustomFieldManager() {
        return ComponentAccessor.getCustomFieldManager();
    }

    @Deprecated
    public FieldLayoutManager getFieldLayoutManager() {
        if (this.fieldLayoutManager == null) {
            this.fieldLayoutManager = ComponentAccessor.getFieldLayoutManager();
        }
        return this.fieldLayoutManager;
    }

    @Deprecated
    public ColumnLayoutManager getColumnLayoutManager() {
        return ComponentAccessor.getColumnLayoutManager();
    }

    public void refresh() {
        this.refreshSearchersAndIndexers();
        this.getFieldLayoutManager().refresh();
        this.getColumnLayoutManager().refresh();
    }

    public boolean isTimeTrackingOn() {
        return ComponentAccessor.getApplicationProperties().getOption("jira.option.timetracking");
    }

    protected boolean isVotingOn() {
        return ComponentAccessor.getApplicationProperties().getOption("jira.option.voting");
    }

    protected boolean isWatchingOn() {
        return ComponentAccessor.getApplicationProperties().getOption("jira.option.watching");
    }

    protected boolean isSubTasksOn() {
        return ComponentManager.getInstance().getSubTaskManager().isSubTasksEnabled();
    }

    private Set<NavigableField> getAvailableNavigableFields() {
        return this.getAvailableFields(this.navigableFields);
    }

    private Set<OrderableField> getAvailableOrderableFields() {
        return this.getAvailableFields(this.orderableFields);
    }

    private Set getAvailableFields(List<? extends Field> allFields) {
        HashSet<? extends Field> availableFields = new HashSet<Field>(allFields);
        availableFields.addAll(this.getCustomFieldManager().getCustomFieldObjects());
        availableFields.removeAll(this.getUnavailableFields());
        return availableFields;
    }

    public Set<Field> getUnavailableFields() {
        HashSet<Field> unavailableFields = new HashSet<Field>();
        if (!this.isTimeTrackingOn()) {
            unavailableFields.add(this.fields.get("timetracking"));
            unavailableFields.add(this.fields.get("timeoriginalestimate"));
            unavailableFields.add(this.fields.get("timeestimate"));
            unavailableFields.add(this.fields.get("timespent"));
            unavailableFields.add(this.fields.get("progress"));
            unavailableFields.add(this.fields.get("worklog"));
        }
        if (!this.isSubTasksOn() || !this.isTimeTrackingOn()) {
            unavailableFields.add(this.fields.get("aggregatetimespent"));
            unavailableFields.add(this.fields.get("aggregatetimeoriginalestimate"));
            unavailableFields.add(this.fields.get("aggregatetimeestimate"));
            unavailableFields.add(this.fields.get("aggregateprogress"));
        }
        if (!this.isVotingOn()) {
            unavailableFields.add(this.fields.get("votes"));
        }
        if (!this.isWatchingOn()) {
            unavailableFields.add(this.fields.get("watches"));
        }
        if (!this.isSubTasksOn()) {
            unavailableFields.add(this.fields.get("subtasks"));
        }
        return unavailableFields;
    }

    private void addAllSystemSearchableFields(Set<SearchableField> searchableFields) {
        searchableFields.add((SearchableField)this.projectSystemField);
        CollectionUtils.select(this.orderableFields, (Predicate)InstanceofPredicate.getInstance(SearchableField.class), searchableFields);
        CollectionUtils.select(this.navigableFields, (Predicate)InstanceofPredicate.getInstance(SearchableField.class), searchableFields);
    }

    private synchronized void refreshSearchersAndIndexers() {
        this.fieldConfigSchemeManager.init();
        IssueSearcherManager issueSearcherManager = ComponentManager.getComponentInstanceOfType(IssueSearcherManager.class);
        issueSearcherManager.refresh();
        FieldIndexerManager fieldIndexerManager = ComponentManager.getComponentInstanceOfType(FieldIndexerManager.class);
        fieldIndexerManager.refresh();
    }
}

