/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.customfields.converters;

import com.atlassian.jira.issue.customfields.converters.ProjectConverter;
import com.atlassian.jira.issue.customfields.impl.FieldValidationException;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectManager;
import com.opensymphony.util.TextUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.ofbiz.core.entity.GenericValue;

public class ProjectConverterImpl
implements ProjectConverter {
    private final ProjectManager projectManager;
    private final Logger log = Logger.getLogger(ProjectConverter.class);

    public ProjectConverterImpl(ProjectManager projectManager) {
        this.projectManager = projectManager;
    }

    public String getString(Project project) {
        if (project == null) {
            return "-1";
        }
        return project.getId().toString();
    }

    public String getString(GenericValue project) {
        if (project == null) {
            return "-1";
        }
        return project.getLong("id").toString();
    }

    public Project getProjectObject(String stringValue) throws FieldValidationException {
        if (StringUtils.isBlank((String)stringValue) || "-1".equals(stringValue)) {
            return null;
        }
        try {
            Long id = Long.valueOf(stringValue);
            return this.getProjectObject(id);
        }
        catch (NumberFormatException e) {
            this.log.error((Object)e, (Throwable)e);
            throw new FieldValidationException("Project Id '" + stringValue + "' is not a number.");
        }
    }

    public Project getProjectObject(Long projectId) throws FieldValidationException {
        if (projectId == null) {
            return null;
        }
        try {
            return this.projectManager.getProjectObj(projectId);
        }
        catch (Exception e) {
            this.log.error((Object)e, (Throwable)e);
            throw new FieldValidationException("Invalid Project Id '" + projectId + "'");
        }
    }

    public GenericValue getProject(String stringValue) throws FieldValidationException {
        if (!TextUtils.stringSet((String)stringValue) || "-1".equals(stringValue)) {
            return null;
        }
        try {
            Long id = Long.valueOf(stringValue);
            return this.getProject(id);
        }
        catch (NumberFormatException e) {
            this.log.error((Object)e, (Throwable)e);
            throw new FieldValidationException("Project Id is not a number '" + stringValue + "'");
        }
    }

    public GenericValue getProject(Long projectId) throws FieldValidationException {
        try {
            return this.projectManager.getProject(projectId);
        }
        catch (Exception e) {
            this.log.error((Object)e, (Throwable)e);
            throw new FieldValidationException("Invalid Project Id '" + projectId + "'");
        }
    }
}

