/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.imports.project.handler;

import com.atlassian.jira.exception.ParseException;
import com.atlassian.jira.external.beans.ExternalChangeGroup;
import com.atlassian.jira.external.beans.ExternalChangeItem;
import com.atlassian.jira.external.beans.ExternalLink;
import com.atlassian.jira.external.beans.ExternalNodeAssociation;
import com.atlassian.jira.external.beans.ExternalVoter;
import com.atlassian.jira.external.beans.ExternalWatcher;
import com.atlassian.jira.imports.project.core.BackupProject;
import com.atlassian.jira.imports.project.handler.AbstractImportPartitionHandler;
import com.atlassian.jira.imports.project.parser.ChangeGroupParser;
import com.atlassian.jira.imports.project.parser.ChangeGroupParserImpl;
import com.atlassian.jira.imports.project.parser.ChangeItemParser;
import com.atlassian.jira.imports.project.parser.ChangeItemParserImpl;
import com.atlassian.jira.imports.project.parser.IssueLinkParser;
import com.atlassian.jira.imports.project.parser.IssueLinkParserImpl;
import com.atlassian.jira.imports.project.parser.NodeAssociationParser;
import com.atlassian.jira.imports.project.parser.NodeAssociationParserImpl;
import com.atlassian.jira.imports.project.parser.UserAssociationParser;
import com.atlassian.jira.imports.project.parser.UserAssociationParserImpl;
import java.io.PrintWriter;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.ofbiz.core.entity.GenericEntity;
import org.ofbiz.core.entity.model.ModelEntity;

public class IssueRelatedEntitiesPartionHandler
extends AbstractImportPartitionHandler {
    private final BackupProject backupProject;
    private final Map modelEntityMap;
    private final PrintWriter printWriter;
    private final PrintWriter changeItemXmlWriter;
    private final Set changeGroupIds;
    private ChangeGroupParser changeGroupParser;
    private ChangeItemParser changeItemParser;
    private UserAssociationParser userAssociationParser;
    private NodeAssociationParser nodeAssocationParser;
    private IssueLinkParser issueLinkParser;
    private int entityCount = 0;
    private int changeItemEntityCount = 0;

    public IssueRelatedEntitiesPartionHandler(BackupProject backupProject, PrintWriter printWriter, PrintWriter changeItemXmlWriter, List modelEntities, String encoding) {
        super(printWriter, encoding);
        this.backupProject = backupProject;
        this.printWriter = printWriter;
        this.changeItemXmlWriter = changeItemXmlWriter;
        this.modelEntityMap = new HashMap();
        this.changeGroupIds = new HashSet();
        this.buildModelEntityMap(modelEntities);
    }

    @Override
    public void handleEntity(String entityName, Map<String, String> attributes) throws ParseException {
        GenericEntity genericEntity;
        boolean saveEntity;
        ModelEntity modelEntity = (ModelEntity)this.modelEntityMap.get(entityName);
        if (modelEntity == null) {
            return;
        }
        if ("NodeAssociation".equals(entityName)) {
            saveEntity = this.handleNodeAssociation(attributes);
        } else if ("IssueLink".equals(entityName)) {
            saveEntity = this.handleIssueLink(attributes);
        } else if ("ChangeItem".equals(entityName)) {
            saveEntity = false;
            if (this.handleChangeItem(attributes)) {
                genericEntity = new GenericEntity(modelEntity, attributes);
                genericEntity.writeXmlText(this.changeItemXmlWriter, null);
                ++this.changeItemEntityCount;
            }
        } else if ("UserAssociation".equals(entityName)) {
            saveEntity = this.handleVotersAndWatchers(attributes);
        } else {
            String issueId = attributes.get("issue");
            saveEntity = this.backupProject.containsIssue(issueId);
        }
        if (saveEntity) {
            this.handleChangeGroup(entityName, attributes);
            genericEntity = new GenericEntity(modelEntity, attributes);
            genericEntity.writeXmlText(this.printWriter, null);
            ++this.entityCount;
        }
    }

    public int getEntityCount() {
        return this.entityCount;
    }

    public int getChangeItemEntityCount() {
        return this.changeItemEntityCount;
    }

    private boolean handleVotersAndWatchers(Map attributes) throws ParseException {
        ExternalVoter externalVoter = this.getUserAssociationParser().parseVoter(attributes);
        if (externalVoter != null) {
            return this.backupProject.containsIssue(externalVoter.getIssueId());
        }
        ExternalWatcher externalWatcher = this.getUserAssociationParser().parseWatcher(attributes);
        if (externalWatcher != null) {
            return this.backupProject.containsIssue(externalWatcher.getIssueId());
        }
        return false;
    }

    private boolean handleChangeItem(Map attributes) throws ParseException {
        ExternalChangeItem externalChangeItem = this.getChangeItemParser().parse(attributes);
        try {
            Long groupId = new Long(externalChangeItem.getChangeGroupId());
            return this.changeGroupIds.contains(groupId);
        }
        catch (NumberFormatException e) {
            throw new ParseException("Unable to parse the changeGroup id'" + externalChangeItem.getChangeGroupId() + "' for change item.");
        }
    }

    @Override
    public void startDocument() {
        super.startDocument();
        if (this.changeItemXmlWriter != null) {
            this.changeItemXmlWriter.println("<?xml version=\"1.0\" encoding=\"" + this.getEncoding() + "\"?>");
            this.changeItemXmlWriter.println("<entity-engine-xml>");
        }
    }

    @Override
    public void endDocument() {
        super.endDocument();
        if (this.changeItemXmlWriter != null) {
            this.changeItemXmlWriter.print("</entity-engine-xml>");
        }
    }

    public Map getRegisteredHandlers() {
        return Collections.unmodifiableMap(this.modelEntityMap);
    }

    private void handleChangeGroup(String entityName, Map attributes) throws ParseException {
        if ("ChangeGroup".equals(entityName)) {
            ExternalChangeGroup externalChangeGroup = this.getChangeGroupParser().parse(attributes);
            String idStr = externalChangeGroup.getId();
            if (idStr != null) {
                try {
                    Long id = new Long(idStr);
                    this.changeGroupIds.add(id);
                }
                catch (NumberFormatException e) {
                    throw new ParseException("Unable to parse the id for changeGroup '" + idStr + "'");
                }
            } else {
                throw new ParseException("Encountered a ChangeGroup entry without an id, this should not happen.");
            }
        }
    }

    private boolean handleIssueLink(Map attributes) throws ParseException {
        ExternalLink externalLink = this.getIssueLinkParser().parse(attributes);
        return this.backupProject.containsIssue(externalLink.getSourceId()) || this.backupProject.containsIssue(externalLink.getDestinationId());
    }

    private boolean handleNodeAssociation(Map attributes) throws ParseException {
        ExternalNodeAssociation externalNodeAssociation = this.getNodeAssociationParser().parse(attributes);
        if ("Issue".equals(externalNodeAssociation.getSourceNodeEntity()) && ("IssueVersion".equals(externalNodeAssociation.getAssociationType()) || "IssueFixVersion".equals(externalNodeAssociation.getAssociationType()) || "IssueComponent".equals(externalNodeAssociation.getAssociationType()))) {
            return this.backupProject.containsIssue(externalNodeAssociation.getSourceNodeId());
        }
        return false;
    }

    private void buildModelEntityMap(List modelEntities) {
        for (ModelEntity modelEntity : modelEntities) {
            this.modelEntityMap.put(modelEntity.getEntityName(), modelEntity);
        }
    }

    private NodeAssociationParser getNodeAssociationParser() {
        if (this.nodeAssocationParser == null) {
            this.nodeAssocationParser = new NodeAssociationParserImpl();
        }
        return this.nodeAssocationParser;
    }

    private IssueLinkParser getIssueLinkParser() {
        if (this.issueLinkParser == null) {
            this.issueLinkParser = new IssueLinkParserImpl();
        }
        return this.issueLinkParser;
    }

    private ChangeGroupParser getChangeGroupParser() {
        if (this.changeGroupParser == null) {
            this.changeGroupParser = new ChangeGroupParserImpl();
        }
        return this.changeGroupParser;
    }

    private ChangeItemParser getChangeItemParser() {
        if (this.changeItemParser == null) {
            this.changeItemParser = new ChangeItemParserImpl();
        }
        return this.changeItemParser;
    }

    UserAssociationParser getUserAssociationParser() {
        if (this.userAssociationParser == null) {
            this.userAssociationParser = new UserAssociationParserImpl();
        }
        return this.userAssociationParser;
    }
}

