/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.imports.project.handler;

import com.atlassian.jira.exception.ParseException;
import com.atlassian.jira.imports.project.core.BackupProject;
import com.atlassian.jira.imports.project.customfield.ExternalCustomFieldValue;
import com.atlassian.jira.imports.project.customfield.ProjectCustomFieldImporter;
import com.atlassian.jira.imports.project.customfield.ProjectImportableCustomField;
import com.atlassian.jira.imports.project.handler.ImportEntityHandler;
import com.atlassian.jira.imports.project.mapper.ProjectImportMapper;
import com.atlassian.jira.imports.project.parser.CustomFieldValueParser;
import com.atlassian.jira.issue.CustomFieldManager;
import com.atlassian.jira.issue.context.IssueContext;
import com.atlassian.jira.issue.context.IssueContextImpl;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.fields.config.FieldConfig;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.MessageSet;
import com.atlassian.jira.util.MessageSetImpl;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class CustomFieldValueValidatorHandler
implements ImportEntityHandler {
    private static final Logger log = Logger.getLogger(CustomFieldValueValidatorHandler.class);
    private final ProjectImportMapper projectImportMapper;
    private final CustomFieldManager customFieldManager;
    private final Map<String, CustomFieldValueParser> parsers;
    private final Long newProjectId;
    final Map customFieldConfigMap;
    final Map fieldMessages;

    public CustomFieldValueValidatorHandler(BackupProject backupProject, ProjectImportMapper projectImportMapper, CustomFieldManager customFieldManager, Map<String, CustomFieldValueParser> parsers) {
        this.projectImportMapper = projectImportMapper;
        this.customFieldManager = customFieldManager;
        this.parsers = parsers;
        this.fieldMessages = new HashMap();
        this.customFieldConfigMap = new HashMap();
        String newProjectIdStr = projectImportMapper.getProjectMapper().getMappedId(backupProject.getProject().getId());
        this.newProjectId = newProjectIdStr == null ? null : new Long(newProjectIdStr);
    }

    @Override
    public void handleEntity(String entityName, Map<String, String> attributes) throws ParseException {
        ExternalCustomFieldValue customFieldValue;
        if (this.parsers.containsKey(entityName) && (customFieldValue = this.parsers.get(entityName).parse(attributes)) != null) {
            if (this.projectImportMapper.getCustomFieldMapper().isIgnoredCustomField(customFieldValue.getCustomFieldId())) {
                return;
            }
            String mappedId = this.projectImportMapper.getCustomFieldMapper().getMappedId(customFieldValue.getCustomFieldId());
            CustomField customField = this.getCustomField(customFieldValue);
            if (customField == null) {
                log.warn((Object)("While validating custom field values we have run into a mapped custom field '" + mappedId + "' which is not in the system and is not marked as ignored."));
            } else if (!(customField.getCustomFieldType() instanceof ProjectImportableCustomField)) {
                log.warn((Object)("While validating custom field values we have run into a mapped custom field '" + mappedId + "' which is not ProjectImportable and is not marked as ignored."));
            } else {
                ProjectCustomFieldImporter projectCustomFieldImporter = ((ProjectImportableCustomField)customField.getCustomFieldType()).getProjectImporter();
                this.validateCustomFieldValueWithField(customField, projectCustomFieldImporter, customFieldValue);
            }
        }
    }

    public Map getValidationResults() {
        return this.fieldMessages;
    }

    void validateCustomFieldValueWithField(CustomField customField, ProjectCustomFieldImporter projectCustomFieldImporter, ExternalCustomFieldValue externalCustomFieldValue) {
        String oldIssueTypeId = this.projectImportMapper.getCustomFieldMapper().getIssueTypeForIssue(externalCustomFieldValue.getIssueId());
        String newIssueTypeId = this.projectImportMapper.getIssueTypeMapper().getMappedId(oldIssueTypeId);
        if (newIssueTypeId != null) {
            FieldConfig relevantConfig = this.getCustomFieldConfig(customField, newIssueTypeId);
            if (relevantConfig == null) {
                log.debug((Object)("Skipping validation on value for Custom Field '" + customField.getId() + "', unable to find a relevant configuration for issue type '" + newIssueTypeId + "'."));
                return;
            }
            I18nHelper i18nBean = this.getI18nFromCustomField(customField);
            MessageSet messageSet = projectCustomFieldImporter.canMapImportValue(this.projectImportMapper, externalCustomFieldValue, relevantConfig, i18nBean);
            String fieldId = externalCustomFieldValue.getCustomFieldId();
            MessageSet existingSet = (MessageSet)this.fieldMessages.get(fieldId);
            if (existingSet == null) {
                existingSet = new MessageSetImpl();
                this.fieldMessages.put(fieldId, existingSet);
            }
            existingSet.addMessageSet(messageSet);
        }
    }

    I18nHelper getI18nFromCustomField(CustomField customField) {
        return customField.getCustomFieldType().getDescriptor().getI18nBean();
    }

    CustomField getCustomField(ExternalCustomFieldValue externalCustomFieldValue) throws ParseException {
        Long customFieldId;
        String oldCustomFieldId = externalCustomFieldValue.getCustomFieldId();
        String mappedId = this.projectImportMapper.getCustomFieldMapper().getMappedId(oldCustomFieldId);
        if (mappedId == null) {
            log.error((Object)("During custom field value validation we have encountered a custom field with id '" + oldCustomFieldId + "' which the mapper does not know about."));
            throw new ParseException("During custom field value validation we have encountered a custom field with id '" + oldCustomFieldId + "' which the mapper does not know about.");
        }
        try {
            customFieldId = new Long(mappedId);
        }
        catch (NumberFormatException e) {
            log.error((Object)("Encountered a custom field value with a custom field id '" + mappedId + "' which is not a valid number."));
            throw new ParseException("Encountered a custom field value with a custom field id '" + mappedId + "' which is not a valid number.");
        }
        return this.customFieldManager.getCustomFieldObject(customFieldId);
    }

    FieldConfig getCustomFieldConfig(CustomField customField, String newIssueTypeId) {
        CustomFieldConfigMapKey key = new CustomFieldConfigMapKey(customField.getId(), newIssueTypeId);
        FieldConfig fieldConfig = (FieldConfig)this.customFieldConfigMap.get(key);
        if (fieldConfig == null) {
            fieldConfig = customField.getRelevantConfig((IssueContext)new IssueContextImpl(this.newProjectId, newIssueTypeId));
            this.customFieldConfigMap.put(key, fieldConfig);
        }
        return fieldConfig;
    }

    @Override
    public void startDocument() {
    }

    @Override
    public void endDocument() {
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CustomFieldValueValidatorHandler that = (CustomFieldValueValidatorHandler)o;
        if (this.customFieldConfigMap != null ? !((Object)this.customFieldConfigMap).equals(that.customFieldConfigMap) : that.customFieldConfigMap != null) {
            return false;
        }
        if (this.customFieldManager != null ? !this.customFieldManager.equals(that.customFieldManager) : that.customFieldManager != null) {
            return false;
        }
        if (this.fieldMessages != null ? !((Object)this.fieldMessages).equals(that.fieldMessages) : that.fieldMessages != null) {
            return false;
        }
        if (this.newProjectId != null ? !this.newProjectId.equals(that.newProjectId) : that.newProjectId != null) {
            return false;
        }
        return !(this.projectImportMapper != null ? !this.projectImportMapper.equals(that.projectImportMapper) : that.projectImportMapper != null);
    }

    public int hashCode() {
        int result = this.projectImportMapper != null ? this.projectImportMapper.hashCode() : 0;
        result = 31 * result + (this.customFieldManager != null ? this.customFieldManager.hashCode() : 0);
        result = 31 * result + (this.newProjectId != null ? this.newProjectId.hashCode() : 0);
        result = 31 * result + (this.customFieldConfigMap != null ? ((Object)this.customFieldConfigMap).hashCode() : 0);
        result = 31 * result + (this.fieldMessages != null ? ((Object)this.fieldMessages).hashCode() : 0);
        return result;
    }

    static class CustomFieldConfigMapKey {
        private final String customFieldId;
        private final String issueTypeId;

        CustomFieldConfigMapKey(String customFieldId, String issueTypeId) {
            this.customFieldId = customFieldId;
            this.issueTypeId = issueTypeId;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CustomFieldConfigMapKey that = (CustomFieldConfigMapKey)o;
            if (this.customFieldId != null ? !this.customFieldId.equals(that.customFieldId) : that.customFieldId != null) {
                return false;
            }
            return !(this.issueTypeId != null ? !this.issueTypeId.equals(that.issueTypeId) : that.issueTypeId != null);
        }

        public int hashCode() {
            int result = this.customFieldId != null ? this.customFieldId.hashCode() : 0;
            result = 31 * result + (this.issueTypeId != null ? this.issueTypeId.hashCode() : 0);
            return result;
        }
    }
}

