/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.datetime;

import com.atlassian.jira.datetime.DateTimeFormatStrategy;
import com.atlassian.jira.datetime.DateTimeFormatterServiceProvider;
import com.atlassian.jira.datetime.DateTimeStyle;
import com.atlassian.jira.datetime.JodaFormatterSupplier;
import java.util.Date;
import java.util.Locale;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeFormatter;

class JodaDateTimeFormatter
implements DateTimeFormatStrategy {
    private final DateTimeFormatterServiceProvider serviceProvider;
    private final JodaFormatterSupplier cache;
    private final String patternPropertyName;
    private final DateTimeStyle style;

    protected JodaDateTimeFormatter(DateTimeFormatterServiceProvider serviceProvider, JodaFormatterSupplier cache, String patternPropertyName, DateTimeStyle style) {
        this.serviceProvider = serviceProvider;
        this.cache = cache;
        this.patternPropertyName = patternPropertyName;
        this.style = style;
    }

    @Override
    public String format(DateTime dateTime, Locale locale) {
        DateTimeFormatter formatter = this.cache.get(new JodaFormatterSupplier.Key(this.pattern(), locale));
        return formatter.print((ReadableInstant)dateTime);
    }

    @Override
    public Date parse(String text, DateTimeZone timeZone, Locale locale) {
        DateTimeFormatter formatter = this.cache.get(new JodaFormatterSupplier.Key(this.pattern(), locale)).withZone(timeZone);
        return formatter.parseDateTime(text).toDate();
    }

    @Override
    public DateTimeStyle style() {
        return this.style;
    }

    @Override
    public String pattern() {
        return this.serviceProvider.getDefaultBackedString(this.patternPropertyName);
    }
}

