/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.appconsistency.integrity.check;

import com.atlassian.jira.appconsistency.integrity.amendment.Amendment;
import com.atlassian.jira.appconsistency.integrity.amendment.DeleteEntityAmendment;
import com.atlassian.jira.appconsistency.integrity.check.AbstractEntityRelation;
import com.atlassian.jira.appconsistency.integrity.exception.IntegrityException;
import com.atlassian.jira.ofbiz.OfBizDelegator;
import com.atlassian.jira.ofbiz.OfBizListIterator;
import java.util.ArrayList;
import java.util.List;
import org.ofbiz.core.entity.GenericEntityException;
import org.ofbiz.core.entity.GenericValue;

public class PrimaryEntityRelationDelete
extends AbstractEntityRelation {
    public PrimaryEntityRelationDelete(OfBizDelegator ofBizDelegator, int id, String relationType, String relationName) {
        super(ofBizDelegator, id, relationType, relationName);
    }

    @Override
    public String getDescription() {
        return this.getI18NBean().getText("admin.integrity.check.primary.entity.relation.desc", this.getEntityName(), this.getRelationType() + this.getRelationName());
    }

    @Override
    protected Amendment previewAmendment(GenericValue entity) {
        return new DeleteEntityAmendment(2, this.getI18NBean().getText("admin.integrity.check.primary.entity.relation.delete.preview", this.getRelationType() + this.getRelationName(), this.getEntityName()), entity);
    }

    @Override
    public List correct() throws IntegrityException {
        ArrayList<GenericValue> toRemove = new ArrayList<GenericValue>();
        OfBizListIterator allEntities = null;
        ArrayList<DeleteEntityAmendment> result = new ArrayList<DeleteEntityAmendment>();
        try {
            allEntities = this.getEntities(this.getEntityName());
            GenericValue entity = allEntities.next();
            while (entity != null) {
                try {
                    GenericValue relatedEntity = entity.getRelatedOne(this.getRelationType() + this.getRelationName());
                    if (relatedEntity == null) {
                        result.add(new DeleteEntityAmendment(0, this.getI18NBean().getText("admin.integrity.check.primary.entity.relation.delete.message", this.getRelationType() + this.getRelationName(), this.getEntityName()), entity));
                        toRemove.add(entity);
                    }
                }
                catch (GenericEntityException e) {
                    throw new IntegrityException(e);
                }
                entity = allEntities.next();
            }
        }
        catch (Exception e) {
            throw new IntegrityException("Error occurred while performing check.", e);
        }
        finally {
            if (allEntities != null) {
                allEntities.close();
            }
        }
        if (!toRemove.isEmpty()) {
            try {
                this.ofBizDelegator.removeAll(toRemove);
            }
            catch (Exception e) {
                throw new IntegrityException(e);
            }
        }
        return result;
    }

    @Override
    public boolean isAvailable() {
        return true;
    }
}

