/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira;

import com.atlassian.jira.ComponentContainer;
import com.atlassian.jira.util.NotNull;
import com.atlassian.jira.util.dbc.Assertions;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.picocontainer.ComponentAdapter;
import org.picocontainer.Parameter;
import org.picocontainer.PicoContainer;
import org.picocontainer.PicoInitializationException;
import org.picocontainer.PicoIntrospectionException;
import org.picocontainer.PicoVerificationException;
import org.picocontainer.defaults.ComponentParameter;

class DelegateComponentAdapter<T>
implements ComponentAdapter {
    private final Class<? super T> key;
    private final ComponentAdapter delegate;

    DelegateComponentAdapter(@NotNull Class<? super T> key, @NotNull ComponentAdapter delegate) {
        this.key = (Class)Assertions.notNull((String)"key", key);
        this.delegate = (ComponentAdapter)Assertions.notNull((String)"delegate", (Object)delegate);
    }

    public Class<? extends T> getComponentImplementation() {
        Class componentImplementation = this.delegate.getComponentImplementation();
        return componentImplementation;
    }

    public Class<? super T> getComponentKey() {
        return this.key;
    }

    public T getComponentInstance() throws PicoInitializationException, PicoIntrospectionException {
        Object componentInstance = this.delegate.getComponentInstance();
        return (T)componentInstance;
    }

    public PicoContainer getContainer() {
        return this.delegate.getContainer();
    }

    public void setContainer(PicoContainer picoContainer) {
        this.delegate.setContainer(picoContainer);
    }

    public void verify() throws PicoVerificationException {
        this.delegate.verify();
    }

    public static class Builder<T> {
        private final List<Class<? super T>> implementing = new ArrayList<Class<? super T>>();
        private final Class<T> concrete;
        private final List<Parameter> parameters = new ArrayList<Parameter>();

        public static <T> Builder<T> builderFor(@NotNull Class<T> concrete) {
            return new Builder<T>(concrete);
        }

        Builder(@NotNull Class<T> concrete) {
            this.concrete = (Class)Assertions.notNull((String)"concrete", concrete);
        }

        public Builder<T> parameter(Class<?> parameter) {
            this.parameters.add((Parameter)new ComponentParameter(parameter));
            return this;
        }

        public Builder<T> parameters(Class<?> ... parameters) {
            for (Class<?> parameter : parameters) {
                this.parameter(parameter);
            }
            return this;
        }

        public Builder<T> implementing(Class<? super T> interfaceClass) {
            this.implementing.add(interfaceClass);
            return this;
        }

        public void registerWith(ComponentContainer.Scope scope, ComponentContainer container) {
            Assertions.stateTrue((String)"must implement some interfaces", (!this.implementing.isEmpty() ? 1 : 0) != 0);
            Iterator<Class<T>> interfaces = this.implementing.iterator();
            Class<? super T> registered = interfaces.next();
            if (this.parameters.isEmpty()) {
                container.implementation(scope, registered, this.concrete);
            } else {
                container.implementation(scope, registered, this.concrete, this.parameters.toArray(new Parameter[this.parameters.size()]));
            }
            while (interfaces.hasNext()) {
                Class<? super T> alternate = interfaces.next();
                container.component(scope, new DelegateComponentAdapter<T>(alternate, container.getComponentAdapter(registered)));
            }
        }
    }
}

