/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.workflow.migration;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.ConstantsManager;
import com.atlassian.jira.issue.index.IssueIndexManager;
import com.atlassian.jira.ofbiz.OfBizDelegator;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.scheme.SchemeManager;
import com.atlassian.jira.task.ScalingTaskProgessSink;
import com.atlassian.jira.task.StatefulTaskProgressSink;
import com.atlassian.jira.task.TaskManager;
import com.atlassian.jira.task.TaskProgressSink;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.web.action.admin.workflow.WorkflowMigrationResult;
import com.atlassian.jira.web.action.admin.workflow.WorkflowMigrationResultForMultipleProjects;
import com.atlassian.jira.workflow.AssignableWorkflowScheme;
import com.atlassian.jira.workflow.DraftWorkflowScheme;
import com.atlassian.jira.workflow.JiraWorkflow;
import com.atlassian.jira.workflow.WorkflowException;
import com.atlassian.jira.workflow.WorkflowManager;
import com.atlassian.jira.workflow.WorkflowScheme;
import com.atlassian.jira.workflow.WorkflowSchemeManager;
import com.atlassian.jira.workflow.migration.AbstractWorkflowSchemeMigrationHelper;
import com.atlassian.jira.workflow.migration.DraftWorkflowSchemeMigrationHelper;
import com.atlassian.jira.workflow.migration.EnterpriseWorkflowTaskContext;
import com.atlassian.jira.workflow.migration.ProjectMigrator;
import com.atlassian.jira.workflow.migration.WorkflowSchemeMigrationCompletedEvent;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.ofbiz.core.entity.EntityCondition;
import org.ofbiz.core.entity.EntityExpr;
import org.ofbiz.core.entity.EntityOperator;
import org.ofbiz.core.entity.GenericEntityException;
import org.ofbiz.core.entity.GenericValue;

public class DraftWorkflowSchemeMultipleProjectsMigrationHelper
extends AbstractWorkflowSchemeMigrationHelper<DraftWorkflowScheme>
implements DraftWorkflowSchemeMigrationHelper {
    private final Project initialProject;
    private final List<Project> projects;
    private final ProjectManager projectManager;
    private final Collection<Long> projectIds;

    DraftWorkflowSchemeMultipleProjectsMigrationHelper(Project initialProject, List<Project> projects, DraftWorkflowScheme targetScheme, WorkflowManager workflowManager, OfBizDelegator delegator, SchemeManager schemeManager, I18nHelper i18nHelper, User user, ConstantsManager constantsManager, TaskManager taskManager, IssueIndexManager issueIndexManager, WorkflowSchemeManager workflowSchemeManager, EventPublisher eventPublisher, ProjectManager projectManager) throws WorkflowException, GenericEntityException {
        super(targetScheme, workflowManager, delegator, schemeManager, i18nHelper, user, constantsManager, taskManager, issueIndexManager, workflowSchemeManager, eventPublisher);
        this.initialProject = initialProject;
        this.projects = projects;
        this.projectManager = projectManager;
        this.projectIds = Lists.newArrayListWithCapacity((int)projects.size());
        for (Project project : projects) {
            this.projectIds.add(project.getId());
        }
        this.calculateInputRequired();
    }

    @Override
    JiraWorkflow getExistingWorkflow(String issueTypeId) throws WorkflowException {
        return this.getExistingWorkflowByProjectId(issueTypeId, this.projects.iterator().next().getId());
    }

    @Override
    void quickMigrate() throws GenericEntityException {
        this.workflowSchemeManager.replaceSchemeWithDraft((DraftWorkflowScheme)this.targetScheme);
        ComponentAccessor.getWorkflowSchemeManager().clearWorkflowCache();
    }

    @Override
    EntityCondition getProjectClause(String projectField) {
        return new EntityExpr(projectField, EntityOperator.IN, this.projectIds);
    }

    @Override
    public WorkflowMigrationResult migrate(TaskProgressSink sink) throws GenericEntityException, WorkflowException {
        if (sink == null) {
            sink = TaskProgressSink.NULL_SINK;
        }
        StatefulTaskProgressSink migrationSink = new StatefulTaskProgressSink(0L, 100L, sink);
        String currentSubTask = this.i18nHelper.getText("admin.selectworkflowscheme.subtask.target.scheme");
        migrationSink.makeProgress(0L, currentSubTask, null);
        AssignableWorkflowScheme intermediateScheme = this.prepareTargetScheme();
        migrationSink.makeProgress(5L, currentSubTask, this.i18nHelper.getText("admin.selectworkflowscheme.progress.created.target"));
        currentSubTask = this.i18nHelper.getText("admin.selectworkflowscheme.subtask.project.migration");
        migrationSink.makeProgress(6L, currentSubTask, this.i18nHelper.getText("admin.selectworkflowscheme.progress.migrating.projects"));
        int singleProjectRange = 88 / this.projects.size();
        int start = 7;
        ArrayList projectMigrationResults = Lists.newArrayListWithCapacity((int)this.projects.size());
        boolean atLeastOneWasSuccessful = false;
        for (Project project : this.projects) {
            ProjectMigrator<AssignableWorkflowScheme> projectMigrator = new ProjectMigrator<AssignableWorkflowScheme>(project, intermediateScheme, this.workflowManager, this.schemeManager, this.delegator, this.user, this.constantsManager, this.i18nHelper, this.issueIndexManager, new ProjectMigrator.OnCompleteCallback<AssignableWorkflowScheme>(){

                @Override
                public void onComplete(SchemeManager schemeManager, Project project, AssignableWorkflowScheme workflowScheme, StatefulTaskProgressSink migrationSink) throws GenericEntityException {
                    GenericValue projectGV = DraftWorkflowSchemeMultipleProjectsMigrationHelper.this.projectManager.getProject(project.getId());
                    schemeManager.removeSchemesFromProject(project);
                    GenericValue scheme = DraftWorkflowSchemeMultipleProjectsMigrationHelper.this.workflowSchemeManager.getScheme(workflowScheme.getId());
                    schemeManager.addSchemeToProject(projectGV, scheme);
                }
            });
            ScalingTaskProgessSink projectMigrationSink = new ScalingTaskProgessSink(start, start + singleProjectRange, migrationSink);
            WorkflowMigrationResult projectMigrationResult = projectMigrator.migrate(projectMigrationSink, this.typesNeedingMigration, this.workflowMigrationMapping);
            projectMigrationResults.add(projectMigrationResult);
            start += singleProjectRange;
            if (0 != projectMigrationResult.getResult()) continue;
            atLeastOneWasSuccessful = true;
        }
        migrationSink.makeProgress(95L, currentSubTask, this.i18nHelper.getText("admin.selectworkflowscheme.progress.finished.migrating.projects"));
        WorkflowMigrationResultForMultipleProjects result = new WorkflowMigrationResultForMultipleProjects(projectMigrationResults);
        currentSubTask = this.i18nHelper.getText("admin.selectworkflowscheme.subtask.finalizing");
        migrationSink.makeProgress(96L, currentSubTask, null);
        if (0 == result.getResult() && result.getNumberOfFailedIssues() == 0) {
            this.cleanUpSchemes(intermediateScheme);
        }
        if (atLeastOneWasSuccessful) {
            this.eventPublisher.publish((Object)new WorkflowSchemeMigrationCompletedEvent(this.targetScheme));
        }
        ComponentAccessor.getWorkflowSchemeManager().clearWorkflowCache();
        migrationSink.makeProgress(100L, null, this.i18nHelper.getText("admin.selectworkflowscheme.progress.complete"));
        return result;
    }

    private AssignableWorkflowScheme prepareTargetScheme() {
        String newDescription = this.getIntermediateSchemeDescription();
        return this.workflowSchemeManager.copyDraft((DraftWorkflowScheme)this.targetScheme, this.user, newDescription);
    }

    private String getIntermediateSchemeDescription() {
        StringBuilder sb = new StringBuilder();
        if (StringUtils.isNotBlank((String)((DraftWorkflowScheme)this.targetScheme).getDescription())) {
            sb.append(((DraftWorkflowScheme)this.targetScheme).getDescription()).append(" ");
        }
        sb.append(this.i18nHelper.getText("admin.selectworkflowscheme.migration.draft.auto.generated", ((DraftWorkflowScheme)this.targetScheme).getName()));
        return sb.toString();
    }

    private void cleanUpSchemes(AssignableWorkflowScheme intermediateScheme) {
        AssignableWorkflowScheme originalScheme = this.workflowSchemeManager.getParentForDraft(((DraftWorkflowScheme)this.targetScheme).getId().longValue());
        if (!this.workflowSchemeManager.isActive((WorkflowScheme)originalScheme)) {
            this.workflowSchemeManager.deleteWorkflowScheme((WorkflowScheme)originalScheme);
            intermediateScheme = intermediateScheme.builder().setName(originalScheme.getName()).setDescription(originalScheme.getDescription()).build();
            this.workflowSchemeManager.updateWorkflowScheme(intermediateScheme);
        }
    }

    @Override
    protected String getMigrateAsyncTaskDesc() {
        StringBuilder projectNames = new StringBuilder();
        for (Project project : this.projects) {
            projectNames.append("'").append(project.getName()).append("', ");
        }
        projectNames.delete(projectNames.length() - 2, projectNames.length());
        return this.i18nHelper.getText("admin.selectworkflows.multiple.projects.task.desc", projectNames.toString(), this.schemeName);
    }

    @Override
    EnterpriseWorkflowTaskContext createEnterpriseWorkflowTaskContext() {
        return new EnterpriseWorkflowTaskContext(this.initialProject, this.projects, this.schemeId, true);
    }
}

