/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.workflow.migration;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.ConstantsManager;
import com.atlassian.jira.issue.index.IssueIndexManager;
import com.atlassian.jira.ofbiz.OfBizDelegator;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.scheme.SchemeManager;
import com.atlassian.jira.task.StatefulTaskProgressSink;
import com.atlassian.jira.task.TaskManager;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.workflow.AssignableWorkflowScheme;
import com.atlassian.jira.workflow.WorkflowException;
import com.atlassian.jira.workflow.WorkflowManager;
import com.atlassian.jira.workflow.WorkflowSchemeManager;
import com.atlassian.jira.workflow.migration.AbstractWorkflowSchemeSingleProjectMigrationHelper;
import com.atlassian.jira.workflow.migration.EnterpriseWorkflowTaskContext;
import java.util.HashSet;
import java.util.List;
import org.ofbiz.core.entity.GenericEntityException;
import org.ofbiz.core.entity.GenericValue;

public class AssignableWorkflowSchemeMigrationHelper
extends AbstractWorkflowSchemeSingleProjectMigrationHelper<AssignableWorkflowScheme> {
    private final ProjectManager projectManager;

    AssignableWorkflowSchemeMigrationHelper(Project project, AssignableWorkflowScheme targetScheme, WorkflowManager workflowManager, OfBizDelegator delegator, SchemeManager schemeManager, I18nHelper i18nHelper, User user, ConstantsManager constantsManager, TaskManager taskManager, IssueIndexManager issueIndexManager, WorkflowSchemeManager workflowSchemeManager, EventPublisher eventPublisher, ProjectManager projectManager) throws WorkflowException, GenericEntityException {
        super(project, targetScheme, workflowManager, delegator, schemeManager, i18nHelper, user, constantsManager, taskManager, issueIndexManager, workflowSchemeManager, eventPublisher);
        this.projectManager = projectManager;
    }

    @Override
    EnterpriseWorkflowTaskContext createEnterpriseWorkflowTaskContext() {
        return new EnterpriseWorkflowTaskContext(this.project, this.schemeId, false);
    }

    @Override
    void completeActually(SchemeManager schemeManager, Project project, AssignableWorkflowScheme workflowScheme, StatefulTaskProgressSink migrationSink) throws GenericEntityException {
        if (schemeManager == null) {
            throw new NullPointerException();
        }
        if (project == null) {
            throw new NullPointerException();
        }
        GenericValue projectGV = this.projectManager.getProject(project.getId());
        List workflowSchemes = schemeManager.getSchemes(projectGV);
        HashSet workflowsFromOldScheme = new HashSet();
        for (GenericValue workflowGV : workflowSchemes) {
            workflowsFromOldScheme.addAll(this.workflowManager.getWorkflowsFromScheme(workflowGV));
        }
        this.workflowSchemeManager.cleanUpSchemeDraft(project, this.user);
        schemeManager.removeSchemesFromProject(project);
        if (workflowScheme != null && workflowScheme.getId() != null) {
            GenericValue scheme = this.workflowSchemeManager.getScheme(workflowScheme.getId());
            schemeManager.addSchemeToProject(projectGV, scheme);
        }
        ComponentAccessor.getWorkflowSchemeManager().clearWorkflowCache();
        this.workflowManager.copyAndDeleteDraftWorkflows(this.user, workflowsFromOldScheme);
    }

    public void associateProjectAndWorkflowScheme() throws GenericEntityException {
        this.projectMigrator.complete(this.schemeManager, this.project, this.targetScheme, null);
    }
}

