/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.util;

import com.atlassian.jira.util.UserAgentUtil;
import com.atlassian.jira.util.UserAgentUtilImpl;
import com.atlassian.jira.util.collect.CollectionBuilder;
import com.atlassian.jira.web.util.AccessKeyHelper;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import webwork.action.ActionContext;

public class AccessKeyHelperImpl
implements AccessKeyHelper {
    private static final Set<String> MSIE_RESERVED_KEYS = CollectionBuilder.newBuilder((Object[])new String[]{"d"}).asSet();

    @Override
    public boolean isAccessKeySafe(String accessKey) {
        UserAgentUtil.UserAgent userAgent = this.getUserAgent();
        return userAgent == null || userAgent.getBrowser().getBrowserFamily() != UserAgentUtil.BrowserFamily.MSIE || !MSIE_RESERVED_KEYS.contains(accessKey);
    }

    UserAgentUtil.UserAgent getUserAgent() {
        HttpServletRequest request = ActionContext.getRequest();
        if (request != null) {
            String userAgent = request.getHeader("USER-AGENT");
            UserAgentUtilImpl userAgentUtil = new UserAgentUtilImpl();
            return userAgentUtil.getUserAgentInfo(userAgent);
        }
        return null;
    }
}

