/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.sitemesh;

import com.atlassian.jira.bc.project.ProjectAction;
import com.atlassian.jira.bc.project.ProjectService;
import com.atlassian.jira.config.FeatureManager;
import com.atlassian.jira.plugin.profile.DarkFeatures;
import com.atlassian.jira.plugin.webfragment.SimpleLinkManager;
import com.atlassian.jira.plugin.webfragment.model.JiraHelper;
import com.atlassian.jira.plugin.webfragment.model.SimpleLink;
import com.atlassian.jira.plugin.webfragment.model.SimpleLinkSection;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.template.soy.SoyTemplateRendererProvider;
import com.atlassian.jira.util.ComponentFactory;
import com.atlassian.jira.util.JiraUrlCodec;
import com.atlassian.jira.util.collect.MapBuilder;
import com.atlassian.jira.util.http.JiraUrl;
import com.atlassian.jira.util.lang.Pair;
import com.atlassian.jira.web.ExecutingHttpRequest;
import com.atlassian.jira.web.component.webfragment.AdminTabsWebComponent;
import com.atlassian.jira.web.ui.header.CurrentHeader;
import com.atlassian.plugin.web.WebInterfaceManager;
import com.atlassian.plugin.web.model.WebPanel;
import com.atlassian.soy.renderer.SoyException;
import com.atlassian.soy.renderer.SoyTemplateRenderer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AdminDecoratorHelper {
    static final String COMMON_HEADER_DARK_FEATURE = "com.atlassian.jira.darkfeature.CommonHeader";
    public static final String SYSTEM_ADMIN_TOP_NAVIGATION_BAR = "system.admin.top.navigation.bar";
    public static final String ACTIVE_SECTION_KEY = "admin.active.section";
    public static final String ACTIVE_TAB_LINK_KEY = "admin.active.tab";
    private static final Logger log = LoggerFactory.getLogger(AdminDecoratorHelper.class);
    private final WebInterfaceManager webInterfaceManager;
    private final ProjectService service;
    private final JiraAuthenticationContext authCtx;
    private final AdminTabsWebComponent tabsWebComponent;
    private final DarkFeatures darkFeatures;
    private final SimpleLinkManager linkManager;
    private final SoyTemplateRenderer soyTemplateRenderer;
    private final CurrentHeader currentHeader;
    private String projectKey;
    private String currentTab;
    private String currentSection;
    private String selectedMenuSection;
    private ProjectService.GetProjectResult result;
    private List<Header> headers;
    private Pair<String, Integer> tabInfo;
    private String headerHtml;

    public AdminDecoratorHelper(WebInterfaceManager webInterfaceManager, ProjectService projectService, JiraAuthenticationContext authenticationContext, ComponentFactory componentFactory, FeatureManager featureManager, SimpleLinkManager linkManager, SoyTemplateRendererProvider soyTemplateRendererProvider, CurrentHeader currentHeader) {
        this.webInterfaceManager = webInterfaceManager;
        this.service = projectService;
        this.authCtx = authenticationContext;
        this.linkManager = linkManager;
        this.currentHeader = currentHeader;
        this.tabsWebComponent = componentFactory.createObject(AdminTabsWebComponent.class);
        this.darkFeatures = featureManager.getDarkFeatures();
        this.soyTemplateRenderer = soyTemplateRendererProvider.getRenderer();
    }

    public boolean isNewHeader() {
        return this.darkFeatures.getGlobalEnabledFeatureKeys().contains(COMMON_HEADER_DARK_FEATURE);
    }

    public boolean isAdminMenusAllHidden() {
        for (SimpleLinkSection linkSection : this.getChildSectionsForSection(SYSTEM_ADMIN_TOP_NAVIGATION_BAR)) {
            this.makeSoyRenderData(null, null, SYSTEM_ADMIN_TOP_NAVIGATION_BAR, linkSection.getId());
        }
        return this.getSelectedMenuSection() == null || this.getSelectedMenuSection().equals(SYSTEM_ADMIN_TOP_NAVIGATION_BAR);
    }

    public AdminDecoratorHelper setProject(String projectKey) {
        this.clearCache();
        this.projectKey = StringUtils.stripToNull((String)projectKey);
        return this;
    }

    public AdminDecoratorHelper setCurrentTab(String currentTab) {
        this.clearCache();
        this.currentTab = StringUtils.stripToNull((String)currentTab);
        return this;
    }

    public AdminDecoratorHelper setCurrentSection(String currentSection) {
        this.clearCache();
        this.currentSection = StringUtils.stripToNull((String)currentSection);
        this.selectedMenuSection = StringUtils.contains((String)currentSection, (String)"/") ? currentSection.substring(0, currentSection.indexOf("/")) : currentSection;
        if (StringUtils.equals((String)"atl.jira.proj.config", (String)this.selectedMenuSection)) {
            this.selectedMenuSection = this.currentHeader.get().equals((Object)CurrentHeader.Header.CLASSIC) ? "admin_project_menu" : "admin_project_current";
        }
        return this;
    }

    public String getSelectedMenuSection() {
        return this.selectedMenuSection;
    }

    public boolean hasKey() {
        return this.projectKey != null;
    }

    public List<Header> getHeaders() {
        String headerPanelSection;
        Map context;
        if (this.headers != null) {
            return this.headers;
        }
        Project project = this.getProject();
        if (project == null) {
            context = MapBuilder.build((Object)ACTIVE_SECTION_KEY, (Object)this.currentSection, (Object)ACTIVE_TAB_LINK_KEY, (Object)this.currentTab);
            headerPanelSection = "system.admin.decorator.header";
        } else {
            context = MapBuilder.build((Object)"project", (Object)project, (Object)ACTIVE_SECTION_KEY, (Object)this.currentSection, (Object)ACTIVE_TAB_LINK_KEY, (Object)this.currentTab);
            headerPanelSection = "atl.jira.proj.config.header";
        }
        List panels = this.webInterfaceManager.getDisplayableWebPanels(headerPanelSection, Collections.emptyMap());
        ArrayList<Header> headers = new ArrayList<Header>(panels.size());
        for (WebPanel panel : panels) {
            headers.add(new Header(panel, context));
        }
        this.headers = headers;
        return this.headers;
    }

    public String getHeaderHtml() {
        if (this.headerHtml != null) {
            return this.headerHtml;
        }
        StringBuilder builder = new StringBuilder();
        for (Header header : this.getHeaders()) {
            builder.append(header.getHtml());
        }
        this.headerHtml = StringUtils.trimToEmpty((String)builder.toString());
        return this.headerHtml;
    }

    public boolean isHasHeader() {
        return StringUtils.isNotEmpty((String)this.getHeaderHtml());
    }

    public int getNumberOfTabs() {
        return (Integer)this.getTabInfo().second();
    }

    public String getTabHtml() {
        return (String)this.getTabInfo().first();
    }

    public String getSideMenuHtml(String sectionId) {
        List<SimpleLinkSection> sections = this.getChildSectionsForSection(SYSTEM_ADMIN_TOP_NAVIGATION_BAR);
        SimpleLinkSection section = null;
        for (SimpleLinkSection simpleLinkSection : sections) {
            if (!simpleLinkSection.getId().equals(sectionId)) continue;
            section = simpleLinkSection;
            break;
        }
        if (section == null) {
            return null;
        }
        Map<String, Object> context = this.makeSoyRenderData(null, null, SYSTEM_ADMIN_TOP_NAVIGATION_BAR, sectionId);
        try {
            return this.soyTemplateRenderer.render("com.atlassian.jira.jira-header-plugin:admin-side-nav-menu", "JIRA.Templates.Menu.admin.side.navigation.menusection", context);
        }
        catch (SoyException e) {
            log.warn("Could not render soy template for side admin menu");
            log.debug("Exception: ", (Throwable)e);
            return null;
        }
    }

    private Map<String, Object> makeSoyRenderData(String title, String label, String parentSectionId, String sectionId) {
        if (!this.getSectionContainsAtleastOneLink(parentSectionId, sectionId)) {
            return null;
        }
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("title", title);
        data.put("label", label);
        data.put("parentSectionId", parentSectionId);
        data.put("sectionId", sectionId);
        data.put("links", this.makeLinksForSection(parentSectionId, sectionId));
        data.put("sections", this.makeChildSectionsForSection(sectionId));
        data.put("selectedMenu", this.selectedMenuSection);
        return data;
    }

    private List<Map<String, Object>> makeChildSectionsForSection(String sectionId) {
        ArrayList<Map<String, Object>> sections = new ArrayList<Map<String, Object>>();
        for (SimpleLinkSection linkSection : this.getChildSectionsForSection(sectionId)) {
            Map<String, Object> section = this.makeSoyRenderData(linkSection.getTitle(), linkSection.getLabel(), sectionId, linkSection.getId());
            sections.add(section);
        }
        return sections;
    }

    private List<Map<String, Object>> makeLinksForSection(String parentSectionId, String sectionId) {
        ArrayList<Map<String, Object>> links = new ArrayList<Map<String, Object>>();
        for (SimpleLink simpleLink : this.getLinksForSection(parentSectionId, sectionId)) {
            HashMap<String, Object> link = new HashMap<String, Object>();
            link.put("url", simpleLink.getUrl());
            link.put("id", simpleLink.getId());
            link.put("label", simpleLink.getLabel());
            link.put("accessKey", simpleLink.getAccessKey());
            link.put("selected", this.isSelectedLink(simpleLink));
            links.add(link);
        }
        return links;
    }

    private boolean isSelectedLink(SimpleLink simpleLink) {
        boolean selected;
        boolean bl = selected = simpleLink.getId() != null && simpleLink.getId().equalsIgnoreCase(this.currentTab);
        if (!selected && StringUtils.isBlank((String)this.currentTab) && this.getHttpRequest().getRequestURI().endsWith(JiraUrl.extractActionFromURL((String)simpleLink.getUrl()))) {
            selected = true;
            if (this.selectedMenuSection == null) {
                this.selectedMenuSection = this.findMenuSection(simpleLink);
            }
        }
        return selected;
    }

    private String findMenuSection(SimpleLink simpleLink) {
        String menuSectionId = null;
        List<SimpleLinkSection> mainAdminMenus = this.getChildSectionsForSection(SYSTEM_ADMIN_TOP_NAVIGATION_BAR);
        Iterator<SimpleLinkSection> adminMenusIterator = mainAdminMenus.iterator();
        while (menuSectionId == null && adminMenusIterator.hasNext()) {
            SimpleLinkSection currentSection = adminMenusIterator.next();
            if (!this.doesSectionContainLink(SYSTEM_ADMIN_TOP_NAVIGATION_BAR, currentSection.getId(), simpleLink)) continue;
            menuSectionId = currentSection.getId();
        }
        return menuSectionId;
    }

    private boolean doesSectionContainLink(String parentSection, String section, SimpleLink simpleLink) {
        LinkedList<Pair> parentAndSectionList = new LinkedList<Pair>();
        parentAndSectionList.add(Pair.nicePairOf((Object)parentSection, (Object)section));
        while (!parentAndSectionList.isEmpty()) {
            Pair currentPair = (Pair)parentAndSectionList.pop();
            Iterator<SimpleLinkSection> sectionListIterator = this.getChildSectionsForSection((String)currentPair.second()).iterator();
            while (sectionListIterator.hasNext()) {
                parentAndSectionList.addLast(Pair.of((Object)currentPair.second(), (Object)sectionListIterator.next().getId()));
            }
            List<SimpleLink> linksForSection = this.getLinksForSection((String)currentPair.first(), (String)currentPair.second());
            if (linksForSection.isEmpty() || !linksForSection.contains(simpleLink)) continue;
            return true;
        }
        return false;
    }

    private Pair<String, Integer> getTabInfo() {
        if (this.tabInfo != null) {
            return this.tabInfo;
        }
        this.tabInfo = this.tabsWebComponent.render(this.getProject(), this.currentSection, this.currentTab);
        return this.tabInfo;
    }

    private Project getProject() {
        ProjectService.GetProjectResult projectResult = this.getProjectResult();
        if (projectResult != null && projectResult.isValid()) {
            return projectResult.getProject();
        }
        return null;
    }

    private ProjectService.GetProjectResult getProjectResult() {
        if (this.result == null && this.hasKey()) {
            this.result = this.service.getProjectByKeyForAction(this.authCtx.getLoggedInUser(), this.projectKey, ProjectAction.EDIT_PROJECT_CONFIG);
        }
        return this.result;
    }

    private void clearCache() {
        this.result = null;
        this.headers = null;
        this.tabInfo = null;
        this.headerHtml = null;
    }

    public HttpServletRequest getHttpRequest() {
        return ExecutingHttpRequest.get();
    }

    private String encode(String string) {
        return JiraUrlCodec.encode((String)string, (boolean)true);
    }

    private JiraHelper getJiraHelper() {
        MapBuilder context = MapBuilder.newBuilder();
        context.add((Object)"project", (Object)this.getProject());
        if (this.getProject() != null) {
            context.add((Object)"projectKeyEncoded", (Object)this.encode(this.getProject().getKey()));
        }
        return new JiraHelper(this.getHttpRequest(), this.getProject(), context.toMap());
    }

    public List<SimpleLinkSection> getMainAdminSections() {
        return this.getChildSectionsForSection(SYSTEM_ADMIN_TOP_NAVIGATION_BAR);
    }

    public List<SimpleLinkSection> getChildSectionsForSection(String location) {
        return this.linkManager.getSectionsForLocation(location, this.authCtx.getLoggedInUser(), this.getJiraHelper());
    }

    public List<SimpleLink> getLinksForSection(String parentSection, String section) {
        if (parentSection == "atl.jira.proj.config" && this.getProject() == null) {
            return new ArrayList<SimpleLink>();
        }
        MapBuilder context = MapBuilder.newBuilder();
        context.add((Object)"project", (Object)this.getProject());
        if (this.getProject() != null) {
            context.add((Object)"projectKeyEncoded", (Object)this.encode(this.getProject().getKey()));
        }
        String sectionId = parentSection + "/" + section;
        return this.linkManager.getLinksForSection(sectionId, this.authCtx.getLoggedInUser(), this.getJiraHelper());
    }

    public boolean getSectionContainsAtleastOneLink(String parentSection, String section) {
        LinkedList<Pair> parentAndSectionList = new LinkedList<Pair>();
        parentAndSectionList.add(Pair.nicePairOf((Object)parentSection, (Object)section));
        while (!parentAndSectionList.isEmpty()) {
            Pair currentPair = (Pair)parentAndSectionList.pop();
            Iterator<SimpleLinkSection> sectionListIterator = this.getChildSectionsForSection((String)currentPair.second()).iterator();
            while (sectionListIterator.hasNext()) {
                parentAndSectionList.addLast(Pair.of((Object)currentPair.second(), (Object)sectionListIterator.next().getId()));
            }
            if (this.getLinksForSection((String)currentPair.first(), (String)currentPair.second()).isEmpty()) continue;
            return true;
        }
        return false;
    }

    public static class Header {
        private final Map<String, Object> contextMap;
        private final WebPanel panel;

        private Header(WebPanel panel, Map<String, Object> contextMap) {
            this.contextMap = contextMap;
            this.panel = panel;
        }

        public String getHtml() {
            return this.panel.getHtml(this.contextMap);
        }
    }
}

