/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.filters.steps.requestcleanup;

import com.atlassian.core.logging.ThreadLocalErrorCollection;
import com.atlassian.jira.dashboard.permission.JiraPermissionService;
import com.atlassian.jira.security.JiraAuthenticationContextImpl;
import com.atlassian.jira.util.ImportUtils;
import com.atlassian.jira.util.searchers.ThreadLocalSearcherCache;
import com.atlassian.jira.util.velocity.DefaultVelocityRequestContextFactory;
import com.atlassian.jira.web.filters.steps.FilterCallContext;
import com.atlassian.jira.web.filters.steps.FilterStep;
import java.util.Iterator;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.log4j.Logger;
import org.ofbiz.core.entity.TransactionUtil;

public class RequestCleanupStep
implements FilterStep {
    private static final Logger log = Logger.getLogger(RequestCleanupStep.class);

    @Override
    public FilterCallContext beforeDoFilter(FilterCallContext callContext) {
        JiraAuthenticationContextImpl.clearRequestCache();
        DefaultVelocityRequestContextFactory.cacheVelocityRequestContext(callContext.getHttpServletRequest());
        ThreadLocalErrorCollection.clear();
        return callContext;
    }

    @Override
    public FilterCallContext finallyAfterDoFilter(FilterCallContext callContext) {
        ThreadLocalErrorCollection.clear();
        JiraAuthenticationContextImpl.clearRequestCache();
        ThreadLocalSearcherCache.resetSearchers();
        JiraPermissionService.setAllowEditingOfDefaultDashboard(true);
        try {
            boolean printRequestDetails = false;
            if (!ImportUtils.isIndexIssues()) {
                log.error((Object)"Indexing thread local not cleared. Clearing...");
                ImportUtils.setIndexIssues((boolean)true);
                printRequestDetails = true;
            }
            if (TransactionUtil.getLocalTransactionConnection() != null) {
                log.error((Object)"Connection not cleared from thread local.");
                TransactionUtil.closeAndClearThreadLocalConnection();
                printRequestDetails = true;
            }
            if (printRequestDetails) {
                HttpServletRequest httpServletRequest = callContext.getHttpServletRequest();
                log.error((Object)("The URL of request that did not clear connection is: " + httpServletRequest.getRequestURL()));
                HttpSession session = httpServletRequest.getSession(false);
                if (session != null) {
                    log.error((Object)("The User of request was: " + session.getAttribute("seraph_defaultauthenticator_user")));
                } else {
                    log.error((Object)"No session found. Cannot determine user.");
                }
                log.error((Object)("Content type:" + httpServletRequest.getContentType()));
                Map parameterMap = httpServletRequest.getParameterMap();
                if (parameterMap != null) {
                    int j = 1;
                    Iterator i$ = parameterMap.entrySet().iterator();
                    while (i$.hasNext()) {
                        Map.Entry o;
                        Map.Entry entry = o = i$.next();
                        log.error((Object)("Parameter " + j + " name: " + entry.getKey()));
                        Object value = entry.getValue();
                        if (value != null && value instanceof String[]) {
                            String[] valueArray;
                            for (String s : valueArray = (String[])value) {
                                log.error((Object)("Parameter value: " + s));
                            }
                        } else {
                            log.error((Object)("Parameter value: " + value));
                        }
                        ++j;
                    }
                } else {
                    log.error((Object)"Request did not have any parameters.");
                }
            }
        }
        catch (Throwable t) {
            log.error((Object)"Error while inspecting thread locals.", t);
        }
        return callContext;
    }
}

