/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.setup;

import com.atlassian.jira.bc.license.JiraLicenseService;
import com.atlassian.jira.config.SubTaskManager;
import com.atlassian.jira.exception.CreateException;
import com.atlassian.jira.extension.JiraStartedEvent;
import com.atlassian.jira.issue.fields.layout.field.EditableDefaultFieldLayout;
import com.atlassian.jira.issue.fields.layout.field.FieldLayoutItem;
import com.atlassian.jira.issue.fields.layout.field.FieldLayoutManager;
import com.atlassian.jira.issue.fields.renderer.RenderableField;
import com.atlassian.jira.license.LicenseJohnsonEventRaiser;
import com.atlassian.jira.upgrade.UpgradeManager;
import com.atlassian.jira.user.util.SneakyAutoLoginUtil;
import com.atlassian.jira.util.FileFactory;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.jira.web.action.setup.AbstractSetupAction;
import com.atlassian.jira.web.action.setup.SetupAdminUserSessionStorage;
import com.atlassian.plugin.event.PluginEventManager;
import java.util.Collection;
import java.util.List;
import webwork.action.ActionContext;

public class SetupComplete
extends AbstractSetupAction {
    private final UpgradeManager upgradeManager;
    private final LicenseJohnsonEventRaiser licenseJohnsonEventRaiser;
    private final JiraLicenseService licenseService;
    private final SubTaskManager subTaskManager;
    private final FieldLayoutManager fieldLayoutManager;
    private final PluginEventManager pluginEventManager;

    public SetupComplete(UpgradeManager upgradeManager, LicenseJohnsonEventRaiser licenseJohnsonEventRaiser, JiraLicenseService licenseService, SubTaskManager subTaskManager, FieldLayoutManager fieldLayoutManager, FileFactory fileFactory, PluginEventManager pluginEventManager) {
        super(fileFactory);
        this.pluginEventManager = (PluginEventManager)Assertions.notNull((String)"pluginEventManager", (Object)pluginEventManager);
        this.licenseService = (JiraLicenseService)Assertions.notNull((String)"licenseService", (Object)licenseService);
        this.upgradeManager = (UpgradeManager)Assertions.notNull((String)"upgradeManager", (Object)upgradeManager);
        this.licenseJohnsonEventRaiser = (LicenseJohnsonEventRaiser)Assertions.notNull((String)"licenseJohnsonEventRaiser", (Object)licenseJohnsonEventRaiser);
        this.subTaskManager = (SubTaskManager)Assertions.notNull((String)"subTaskManager", (Object)subTaskManager);
        this.fieldLayoutManager = (FieldLayoutManager)Assertions.notNull((String)"fieldLayoutManager", (Object)fieldLayoutManager);
    }

    protected String doExecute() throws Exception {
        if (this.setupAlready()) {
            return "setupalready";
        }
        this.getApplicationProperties().setString("jira.setup", "true");
        this.initialiseSystemPropertiesBeforeSetupUpgradeTasks();
        if (this.licenseTooOld()) {
            return this.getRedirect("/secure/errors.jsp");
        }
        Collection<String> errors = this.upgradeManager.doSetupUpgrade();
        if (!errors.isEmpty()) {
            for (String error : errors) {
                this.addErrorMessage(error);
            }
        } else {
            this.initialiseSystemPropertiesAfterSetupUpgradeTasks();
            this.pluginEventManager.broadcast((Object)new JiraStartedEvent());
        }
        if (this.logUserIn()) {
            return "loggedin";
        }
        return this.getResult();
    }

    private boolean logUserIn() {
        try {
            SetupAdminUserSessionStorage sessionStorage = (SetupAdminUserSessionStorage)this.request.getSession().getAttribute(SetupAdminUserSessionStorage.SESSION_KEY);
            this.request.getSession().removeAttribute(SetupAdminUserSessionStorage.SESSION_KEY);
            if (sessionStorage != null) {
                return SneakyAutoLoginUtil.logUserIn(sessionStorage.getUsername(), this.request);
            }
            this.log.warn((Object)"Unable to automatically login after setup complete: sessionStorage is null");
        }
        catch (Exception e) {
            this.log.warn((Object)"Error with automatic login after setup complete. The user will need to login in manually.", (Throwable)e);
        }
        return false;
    }

    private void initialiseSystemPropertiesBeforeSetupUpgradeTasks() {
        this.getApplicationProperties().setOption("jira.option.allowunassigned", false);
        this.getApplicationProperties().setOption("jira.option.user.externalmanagement", false);
        this.getApplicationProperties().setOption("jira.option.voting", true);
        this.getApplicationProperties().setOption("jira.option.watching", true);
        this.getApplicationProperties().setOption("jira.option.issuelinking", true);
        this.getApplicationProperties().setString("jira.option.emailvisible", "show");
    }

    private void initialiseSystemPropertiesAfterSetupUpgradeTasks() {
        this.enableSubTasks();
        this.setWikiRendererOnAllRenderableFields();
    }

    private void enableSubTasks() {
        try {
            this.subTaskManager.enableSubTasks();
        }
        catch (CreateException e) {
            this.log.error((Object)"Error encountered when trying to enable sub tasks", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    void setWikiRendererOnAllRenderableFields() {
        EditableDefaultFieldLayout editableDefaultFieldLayout = this.fieldLayoutManager.getEditableDefaultFieldLayout();
        List fieldLayoutItems = editableDefaultFieldLayout.getFieldLayoutItems();
        for (FieldLayoutItem fieldLayoutItem : fieldLayoutItems) {
            RenderableField field;
            if (!(fieldLayoutItem.getOrderableField() instanceof RenderableField) || !(field = (RenderableField)fieldLayoutItem.getOrderableField()).isRenderable()) continue;
            editableDefaultFieldLayout.setRendererType(fieldLayoutItem, "atlassian-wiki-renderer");
        }
        this.fieldLayoutManager.storeEditableDefaultFieldLayout(editableDefaultFieldLayout);
    }

    protected boolean licenseTooOld() {
        return this.licenseJohnsonEventRaiser.checkLicenseIsTooOldForBuild(ActionContext.getServletContext(), this.licenseService.getLicense());
    }

    public String doDefault() throws Exception {
        return this.doExecute();
    }
}

