/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.projectcategory;

import com.atlassian.jira.issue.CustomFieldManager;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectCategory;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.security.xsrf.RequiresXsrfCheck;
import com.atlassian.jira.web.action.ProjectActionSupport;
import com.atlassian.sal.api.websudo.WebSudoRequired;
import java.util.Collection;

@WebSudoRequired
public class DeleteProjectCategory
extends ProjectActionSupport {
    private boolean confirm = false;
    private Long id;
    private final CustomFieldManager customFieldManager;

    public DeleteProjectCategory(ProjectManager projectManager, PermissionManager permissionManager, CustomFieldManager customFieldManager) {
        super(projectManager, permissionManager);
        this.customFieldManager = customFieldManager;
    }

    protected void doValidation() {
        if (!this.isConfirm()) {
            this.addErrorMessage(this.getText("admin.errors.projectcategory.must.confirm.delete"));
        }
        if (null == this.getId() || null == this.projectManager.getProjectCategoryObject(this.getId())) {
            this.addErrorMessage(this.getText("admin.errors.projectcategory.must.specify.category"));
        } else {
            Collection<Project> projectsFromProjectCategory = this.getProjects();
            if (null != projectsFromProjectCategory && !projectsFromProjectCategory.isEmpty()) {
                this.addErrorMessage(this.getText("admin.errors.projectcategory.currently.projects.linked"));
            }
        }
    }

    private Collection<Project> getProjects() {
        return this.projectManager.getProjectsFromProjectCategory(this.getProjectCategory());
    }

    private ProjectCategory getProjectCategory() {
        return this.projectManager.getProjectCategoryObject(this.getId());
    }

    @RequiresXsrfCheck
    protected String doExecute() throws Exception {
        this.customFieldManager.removeProjectCategoryAssociations(this.getProjectCategory());
        this.projectManager.removeProjectCategory(this.getId());
        return this.getRedirect("ViewProjectCategories!default.jspa");
    }

    public boolean isConfirm() {
        return this.confirm;
    }

    public void setConfirm(boolean confirm) {
        this.confirm = confirm;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }
}

