/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.issue.bulkedit;

import com.atlassian.core.util.map.EasyMap;
import com.atlassian.jira.bc.issue.search.SearchService;
import com.atlassian.jira.bulkedit.operation.BulkMoveOperation;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.ConstantsManager;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueFactory;
import com.atlassian.jira.issue.MutableIssue;
import com.atlassian.jira.issue.customfields.OperationContext;
import com.atlassian.jira.issue.customfields.impl.VersionCFType;
import com.atlassian.jira.issue.customfields.view.CustomFieldParams;
import com.atlassian.jira.issue.customfields.view.CustomFieldParamsImpl;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.fields.Field;
import com.atlassian.jira.issue.fields.FieldManager;
import com.atlassian.jira.issue.fields.IssueTypeSystemField;
import com.atlassian.jira.issue.fields.OrderableField;
import com.atlassian.jira.issue.fields.layout.field.FieldLayoutItem;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.collect.MapBuilder;
import com.atlassian.jira.web.action.issue.bulkedit.AbstractBulkOperationDetailsAction;
import com.atlassian.jira.web.bean.BulkEditBean;
import com.atlassian.jira.workflow.JiraWorkflow;
import com.atlassian.jira.workflow.WorkflowException;
import com.atlassian.jira.workflow.WorkflowManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.ofbiz.core.entity.GenericValue;
import webwork.action.Action;
import webwork.action.ActionContext;

public class BulkMove
extends AbstractBulkOperationDetailsAction {
    public static final String RADIO_ERROR_MSG = "buik.edit.must.select.one.action.to.perform";
    private static final String PARENT_SELECTION = "parent";
    private boolean subTaskPhase = false;
    protected BulkMoveOperation bulkMoveOperation;
    protected final FieldManager fieldManager;
    protected final WorkflowManager workflowManager;
    protected final ConstantsManager constantsManager;
    protected final IssueFactory issueFactory;
    protected final PermissionManager permissionManager;

    public BulkMove(SearchService searchService, BulkMoveOperation bulkMoveOperation, FieldManager fieldManager, WorkflowManager workflowManager, ConstantsManager constantsManager, IssueFactory issueFactory, PermissionManager permissionManager) {
        super(searchService);
        this.fieldManager = fieldManager;
        this.workflowManager = workflowManager;
        this.bulkMoveOperation = bulkMoveOperation;
        this.constantsManager = constantsManager;
        this.issueFactory = issueFactory;
        this.permissionManager = permissionManager;
    }

    public String doDefault() throws Exception {
        if (this.getBulkEditBean() == null) {
            return this.redirectToStart();
        }
        this.getBulkEditBean().setIssuesInUse((Collection)this.getBulkEditBean().getSelectedIssues());
        this.getBulkEditBean().setOperationName("BulkMove");
        return super.doDefault();
    }

    @Override
    public String doDetails() {
        BulkEditBean bulkEditBean = this.getRootBulkEditBean();
        if (bulkEditBean == null) {
            return this.redirectToStart();
        }
        this.resetIssueCollection(PARENT_SELECTION);
        bulkEditBean.resetMoveData();
        bulkEditBean.clearAvailablePreviousSteps();
        bulkEditBean.addAvailablePreviousStep(1);
        bulkEditBean.addAvailablePreviousStep(2);
        bulkEditBean.setCurrentStep(3);
        return "input";
    }

    @Override
    public String doPerform() throws Exception {
        if (this.getBulkEditBean() == null) {
            return this.redirectToStart();
        }
        try {
            if (!this.permissionManager.hasPermission(33, this.getLoggedInUser())) {
                this.addErrorMessage(this.getText("bulk.change.no.permission", String.valueOf(this.getBulkEditBean().getSelectedIssues().size())));
            }
            if (!this.getBulkMoveOperation().canPerform(this.getRootBulkEditBean(), this.getLoggedInUser())) {
                this.addErrorMessage(this.getText("bulk.edit.cannotperform.error", String.valueOf(this.getBulkEditBean().getSelectedIssues().size())));
            }
        }
        catch (Exception e1) {
            this.log.error((Object)"Error occurred while testing operation.", (Throwable)e1);
            this.addErrorMessage(this.getText("bulk.canperform.error"));
        }
        if (this.invalidInput()) {
            return "error";
        }
        try {
            this.getBulkMoveOperation().perform(this.getRootBulkEditBean(), this.getLoggedInUser());
        }
        catch (Exception e) {
            this.log.error((Object)"Error while performing Bulk Edit operation.", (Throwable)e);
            this.addErrorMessage(this.getText("bulk.edit.perform.error"));
            return "error";
        }
        return this.finishWizard();
    }

    @Override
    public String doDetailsValidation() throws Exception {
        throw new IllegalArgumentException("This should never be called.");
    }

    public boolean isHasAvailableActions() throws Exception {
        return this.getBulkMoveOperation().canPerform(this.getBulkEditBean(), this.getLoggedInUser());
    }

    public String doContextValidation() throws Exception {
        if (this.getBulkEditBean() == null) {
            return this.redirectToStart();
        }
        this.getBulkEditBean().resetMoveData();
        this.getBulkMoveOperation().chooseContext(this.getBulkEditBean(), this.getLoggedInUser(), (I18nHelper)this, (ErrorCollection)this);
        if (this.invalidInput()) {
            return "error";
        }
        if (!this.getBulkMoveOperation().isStatusValid(this.getBulkEditBean())) {
            return "statuserror";
        }
        return "success";
    }

    public String doStatusValidation() throws Exception {
        if (this.getBulkEditBean() == null) {
            return this.redirectToStart();
        }
        this.getBulkMoveOperation().setStatusFields(this.getBulkEditBean());
        return this.getResult();
    }

    public String doFieldsValidation() throws Exception {
        if (this.getBulkEditBean() == null) {
            return this.redirectToStart();
        }
        this.getBulkMoveOperation().validatePopulateFields(this.getBulkEditBean(), (ErrorCollection)this, (I18nHelper)this);
        if (this.invalidInput()) {
            return "error";
        }
        if (this.getBulkEditBean().getSubTaskBulkEditBean() != null) {
            this.setSubTaskPhase(true);
            return "subtaskphase";
        }
        this.setSubTaskPhase(false);
        this.progressToLastStep();
        return this.getResult();
    }

    public String getFieldHtml(String fieldId, BulkEditBean bulkEditBean) {
        OrderableField orderableField = (OrderableField)this.fieldManager.getField(fieldId);
        return orderableField.getBulkEditHtml((OperationContext)bulkEditBean, (Action)this, bulkEditBean, EasyMap.build((Object)"noHeader", (Object)Boolean.TRUE, (Object)"fieldNamePrefix", (Object)bulkEditBean.getKey()));
    }

    public String getFieldHtml(String fieldId) {
        return this.getFieldHtml(fieldId, this.getBulkEditBean());
    }

    public String getFieldHtml(FieldLayoutItem fieldLayoutItem) {
        OrderableField orderableField = fieldLayoutItem.getOrderableField();
        if (orderableField.isShown(this.getBulkEditBean().getFirstTargetIssueObject())) {
            return orderableField.getBulkEditHtml((OperationContext)this.getBulkEditBean(), (Action)this, this.getBulkEditBean(), EasyMap.build((Object)"noHeader", (Object)Boolean.TRUE));
        }
        return "";
    }

    public boolean isIssueTypesAvailable() {
        IssueTypeSystemField issueTypeField = (IssueTypeSystemField)this.fieldManager.getField("issuetype");
        return !issueTypeField.isHasCommonIssueTypes(this.getBulkEditBean().getSelectedIssues());
    }

    public boolean isSubTaskTypesAvailable() {
        IssueTypeSystemField issueTypeField = (IssueTypeSystemField)this.fieldManager.getField("issuetype");
        List selectedIssues = this.getBulkEditBean().getSelectedIssues();
        ArrayList<Issue> selectedSubTasks = new ArrayList<Issue>();
        for (Issue issue : selectedIssues) {
            if (!issue.isSubTask()) continue;
            selectedSubTasks.add(issue);
        }
        return !issueTypeField.isHasCommonIssueTypes(selectedSubTasks);
    }

    public String getFieldViewHtml(OrderableField orderableField) {
        Map displayParams = MapBuilder.newBuilder((Object)"readonly", (Object)Boolean.TRUE).add((Object)"nolink", (Object)Boolean.TRUE).add((Object)"bulkoperation", (Object)this.getBulkEditBean().getOperationName()).toMutableMap();
        FieldLayoutItem layoutItem = this.getBulkEditBean().getTargetFieldLayout().getFieldLayoutItem(orderableField);
        return orderableField.getViewHtml(layoutItem, (Action)this, this.getBulkEditBean().getFirstTargetIssueObject(), this.getBulkEditBean().getFieldValues().get(orderableField.getId()), displayParams);
    }

    public Collection getMoveFieldLayoutItems() {
        return this.getBulkEditBean().getMoveFieldLayoutItems();
    }

    public String getFieldName(Field field) {
        if (field instanceof CustomField) {
            return field.getName();
        }
        return this.getText(field.getNameKey());
    }

    public String getNewViewHtml(OrderableField field) {
        Map displayParameters = MapBuilder.newBuilder((Object)"readonly", (Object)Boolean.TRUE).add((Object)"nolink", (Object)Boolean.TRUE).toMap();
        return field.getViewHtml(this.getBulkEditBean().getTargetFieldLayout().getFieldLayoutItem(field), (Action)this, this.getBulkEditBean().getFirstTargetIssueObject(), displayParameters);
    }

    public String getNewViewHtml(BulkEditBean bulkEditBean, OrderableField field) {
        Map displayParameters = MapBuilder.newBuilder((Object)"readonly", (Object)Boolean.TRUE).add((Object)"nolink", (Object)Boolean.TRUE).add((Object)"prefix", (Object)(bulkEditBean.getProject().getString("id") + "_" + bulkEditBean.getIssueType().getString("id") + "_")).toMap();
        return field.getViewHtml(bulkEditBean.getTargetFieldLayout().getFieldLayoutItem(field), (Action)this, bulkEditBean.getFirstTargetIssueObject(), displayParameters);
    }

    public boolean isFieldUsingSubstitutions(BulkEditBean bulkEditBean, OrderableField field) {
        Map substitutions = (Map)bulkEditBean.getFieldSubstitutionMap().get(field.getId());
        return substitutions != null;
    }

    public Map<Long, Long> getSubstitutionsForField(BulkEditBean bulkEditBean, OrderableField field) {
        return (Map)bulkEditBean.getFieldSubstitutionMap().get(field.getId());
    }

    public String getMappingViewHtml(BulkEditBean bulkEditBean, OrderableField field, Long id, boolean showProject) {
        FieldLayoutItem fieldLayoutItem = bulkEditBean.getTargetFieldLayout().getFieldLayoutItem(field);
        Issue baseIssue = bulkEditBean.getFirstTargetIssueObject();
        return this.getViewHtmlForId(baseIssue, fieldLayoutItem, field, id, showProject);
    }

    private String getViewHtmlForId(Issue baseIssue, FieldLayoutItem fieldLayoutItem, OrderableField field, Long id, boolean showProject) {
        if (id == null || id == -1L) {
            return this.getText("common.words.unknown");
        }
        CustomFieldParams value = field instanceof CustomField ? this.getValueForId((CustomField)field, id) : this.getValueForId(field, id);
        LinkedHashMap<String, CustomFieldParams> fieldValuesHolder = new LinkedHashMap<String, CustomFieldParams>();
        fieldValuesHolder.put(field.getId(), value);
        MutableIssue dummyIssue = this.issueFactory.cloneIssue(baseIssue);
        field.updateIssue(fieldLayoutItem, dummyIssue, fieldValuesHolder);
        if (showProject) {
            return field.getViewHtml(fieldLayoutItem, (Action)this, (Issue)dummyIssue, MapBuilder.singletonMap((Object)"showProject", (Object)true));
        }
        return field.getViewHtml(fieldLayoutItem, (Action)this, (Issue)dummyIssue);
    }

    private CustomFieldParams getValueForId(CustomField customField, Long id) {
        return new CustomFieldParamsImpl(customField, Collections.singletonList(id.toString()));
    }

    private Collection<Long> getValueForId(OrderableField orderableField, Long id) {
        return Collections.singletonList(id);
    }

    public boolean isAvailable(String action) throws Exception {
        return true;
    }

    public boolean isAllowProjectEdit() {
        return this.isAllowProjectEdit(this.getBulkEditBean());
    }

    public boolean isAllowProjectEdit(BulkEditBean bulkEditBean) {
        return !bulkEditBean.isSubTaskCollection();
    }

    public String getOperationDetailsActionName() {
        return this.getBulkMoveOperation().getOperationName() + "Details.jspa";
    }

    protected void populateFromParams(OrderableField orderableField) {
        orderableField.populateFromParams(this.getBulkEditBean().getFieldValuesHolder(), ActionContext.getParameters());
    }

    public Collection getTargetWorkflowStatuses(String issueTypeId) throws WorkflowException {
        JiraWorkflow workflow = this.getWorkflowForType(this.getBulkEditBean().getTargetPid(), issueTypeId);
        return workflow.getLinkedStatuses();
    }

    public JiraWorkflow getWorkflowForType(Long projectId, String issueTypeId) throws WorkflowException {
        return this.workflowManager.getWorkflow(projectId, issueTypeId);
    }

    public String getStatusName(String id) {
        return this.constantsManager.getStatus(id).getString("name");
    }

    public String getCurrentTargetPid() {
        return String.valueOf(this.getBulkEditBean().getTargetPid());
    }

    public GenericValue getCurrentTargetProject() {
        return this.getBulkEditBean().getTargetProjectGV();
    }

    private void resetIssueCollection(String collectionType) {
        List selectedIssues = this.getBulkEditBean().getSelectedIssues();
        ArrayList<Issue> modifiedSelection = new ArrayList<Issue>();
        if (PARENT_SELECTION.equals(collectionType)) {
            for (Issue issue : selectedIssues) {
                if (issue.isSubTask()) continue;
                modifiedSelection.add(issue);
            }
        } else {
            for (Issue issue : selectedIssues) {
                if (!issue.isSubTask()) continue;
                modifiedSelection.add(issue);
            }
        }
        this.getBulkEditBean().initSelectedIssues(modifiedSelection);
    }

    protected void progressToLastStep() {
        if (this.getRootBulkEditBean() != null) {
            this.getRootBulkEditBean().clearAvailablePreviousSteps();
            this.getRootBulkEditBean().addAvailablePreviousStep(1);
            this.getRootBulkEditBean().addAvailablePreviousStep(2);
            this.getRootBulkEditBean().addAvailablePreviousStep(3);
            this.getRootBulkEditBean().setCurrentStep(4);
        }
    }

    private BulkMoveOperation getBulkMoveOperation() {
        return this.bulkMoveOperation;
    }

    protected MutableIssue getIssueObject(GenericValue issueGV) {
        return this.issueFactory.getIssue(issueGV);
    }

    public ConstantsManager getConstantsManager() {
        return ComponentAccessor.getConstantsManager();
    }

    public String getCurrentIssueType() {
        return ((Issue)this.getBulkEditBean().getSelectedIssues().get(0)).getIssueTypeObject().getId();
    }

    protected String redirectToStart() {
        return super.redirectToStart("bulk.move.session.timeout.message");
    }

    public boolean isSubTaskPhase() {
        return this.subTaskPhase;
    }

    public void setSubTaskPhase(boolean subTaskPhase) {
        this.subTaskPhase = subTaskPhase;
    }

    public boolean isRetainMandatory(OrderableField field) {
        if (field instanceof CustomField) {
            CustomField customField = (CustomField)field;
            return customField.getCustomFieldType() instanceof VersionCFType;
        }
        String id = field.getId();
        return "fixVersions".equals(id) || "versions".equals(id) || "components".equals(id);
    }

    @Override
    public BulkEditBean getBulkEditBean() {
        BulkEditBean bulkEditBean = this.getRootBulkEditBean();
        if (!this.isSubTaskPhase()) {
            return bulkEditBean;
        }
        return bulkEditBean != null ? bulkEditBean.getSubTaskBulkEditBean() : null;
    }
}

